/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dEl5
 */

// forked from Murai's #2 forked from: #1 SingleAsyncImgLoader WonderflBook Interactive3
// forked from Murai's #1 SingleAsyncImgLoader WonderflBook Interactive3
//#1 SingleAsyncImgLoader WonderflBook Interactive3
package {

	import flash.display.Sprite;
	import flash.events.*;

	/*
	   @author Takashi Murai(KAYAC)
	 */

	[SWF( width="465", height="465", backgroundColor="0x000000", frameRate="30" )]
	public class WonderflBook6 extends Sprite {

		public function WonderflBook6() {
			init();
		}

		public function init():void {
			stage.addEventListener( MouseEvent.CLICK, add );
		}

		public function add( e:MouseEvent ):void {
			var box: ImgBox = new ImgBox();
			box.x = stage.mouseX;
			box.y = stage.mouseY;

			box.init();
			box.show();
			addChild( box );
		}
	}
}

import flash.display.*;
import flash.events.*;
import caurina.transitions.Tweener;
import flash.net.URLRequest;

internal class ImgBox extends Sprite {

	private var _loader:Loader;
	private var _lineRect:Sprite;
	private var _maskRect:Sprite;
	private var _bgRect:Sprite;

	private const IMG_SIZE:Number = 100;
	private const HALF_SIZE:Number = IMG_SIZE / 2;

	public function ImgBox() {
	}

	public function init():void {
		_lineRect = new Sprite();
		_lineRect.graphics.lineStyle( 1, 0xFFFFFF, 1, false, LineScaleMode.NONE );
		_lineRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		_lineRect.x = _lineRect.y = -HALF_SIZE;


		_bgRect = new Sprite();
		_bgRect.graphics.beginFill( 0xFFFFFF, 0.5 );
		_bgRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		_bgRect.graphics.endFill();
		_bgRect.x = _bgRect.y = -HALF_SIZE;

		_loader = new Loader();
		_loader.alpha = 0;

		addChild( _bgRect );
		addChild( _lineRect );
		addChild( _loader );

		this.alpha = 0;
		this.scaleX = 0.01;
		this.scaleY = 0.01;
	}

	public function show():void {
		Tweener.addTween( this, { alpha:1, scaleX:0.2, scaleY:0.2, time:30, useFrames:true, transition:"easeOutExpo",onComplete:open });
	}

	public function open():void {
		Tweener.addTween( this, { scaleX:1, scaleY:1, time:30, useFrames:true, transition:"easeOutElastic" });
		Tweener.addTween( _loader, { x:-HALF_SIZE, y:-HALF_SIZE, alpha:1, width:1, time:20, delay:21, useFrames:true, transition:"easeOutExpo", onComplete:load });
	}

	private function load():void {
		_loader.contentLoaderInfo.addEventListener( ProgressEvent.PROGRESS, loading );
		_loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete );

		_loader.load( new URLRequest( "http://wonderfl.net/images/icon/4/48/480f/480f876800731772d8e7a547397888a08d8f71bfm" ));
	}

	private function loading( e:ProgressEvent ):void {
		var percent:Number = e.bytesLoaded / e.bytesTotal;
		Tweener.addTween( _maskRect, { x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE * percent, time:20, useFrames:true, transition:"easeOutExpo" });
	}

	private function complete( e:Event ):void {
		Tweener.addTween( _maskRect, { alpha:1, x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE, time:15, useFrames:true, transition:"easeOutExpo", onComplete:showImg });
	}

	private function showImg():void {
		Tweener.addTween( _maskRect, { x:HALF_SIZE, y:-HALF_SIZE, width:1, time:15, useFrames:true, transition:"easeOutExpo", onComplete:showImg });
		_loader.x = -HALF_SIZE;
		_loader.y = -HALF_SIZE;
		Tweener.addTween( _loader, { alpha:1, time:20, useFrames:true, transition:"easeOutExpo" });
	}
}