/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dDhN
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(width = 465, height = 465, frameRate = 60)]
    public class Instance extends Sprite
    {
        public function Instance()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.9);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(new Tip("Tip #1:\nTips will match the dimensions of their content.\nIn this tip-example, the tip is particularly larger to match the text.", 1, 1));
            addChild(new Tip("Tip #2:\nThis is a smaller Tip.\nEach Tip has a non-filter shadow.", 100, 60));
            
            _init();
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Tip extends Sprite
{
    private var tipText :Text_Output;
    private var tipWidth :Number = 0;
    private var tipHeight :Number = 0;
    
    protected var _x :Number;
    protected var _y :Number;
    
    public function Tip($content:String, $x:Number, $y:Number)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        
        tipText = new Text_Output($content, $x, $y);
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0, 0.75);
        
        graphics.beginFill (0, 0.33);
        graphics.drawRect  (_x, _y, tipWidth, 50);
        graphics.endFill   ();
        
        graphics.beginFill (0, 0.75);
        graphics.moveTo ((_x + 3), ((_y + 50) + 1));
        graphics.lineTo (((_x + tipWidth) + 1), ((_y + 50) + 1));
        graphics.lineTo (((_x + tipWidth) + 1), (_y + 3));
        graphics.lineTo (((_x + tipWidth) + 2), (_y + 3));
        graphics.lineTo (((_x + tipWidth) + 2), ((_y + 50) + 2));
        graphics.lineTo ((_x + 3), ((_y + 50) + 2));
        graphics.endFill ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addChild(tipText);
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function onEnterFrame($e:Event) :void
    {
       tipWidth = tipText.width;
       tipHeight = tipText.height;
           
       if  (tipWidth > 1)
           {_init(); removeEventListener(Event.ENTER_FRAME, onEnterFrame);}
    }
}

class Text_Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Text_Output($content:String, $x:Number, $y:Number, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init(); }
}
