/**
 * Copyright atsushi015 ( http://wonderfl.net/user/atsushi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dDdy
 */

// forked from rsakane's Shapes
/*
 * クリックするだけです。
 */
package
{
    import com.bit101.components.PushButton;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.geom.Point;
    import flash.ui.Mouse;
    import flash.ui.MouseCursor;
    
    public class Main extends Sprite
    {
        public static var instance:Main;
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private var canvas:Sprite;
        
        public function Main()
        {
            Main.instance = this;
            Mouse.cursor = MouseCursor.BUTTON;
            
            graphics.beginFill(0xE0E0E0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            initialize();
        }
        
        private function initialize(event:Event = null):void
        {
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            Shape.maskContainer = null;
            Shape.shapes = [];
            while (this.numChildren) removeChildAt(0);
            new PushButton(this, 365, 445, "RESTART", initialize);
            
            canvas = new Sprite();
            canvas.blendMode = BlendMode.LAYER;
            canvas.graphics.beginFill(Utils.SHAPE_COLOR);
            canvas.graphics.drawRect(0, 0, WIDTH, HEIGHT);
            canvas.filters = [new DropShadowFilter(2.7, 45, 0x555555, 1, 4, 4, 1, 1)];
            addChildAt(canvas, 0);

            Shape.maskContainer = new Sprite();
            Shape.maskContainer.blendMode = BlendMode.ERASE;
            canvas.addChild(Shape.maskContainer);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            canvas.addEventListener(MouseEvent.CLICK, onMouseClick);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            for (var i:int = 0; i < Shape.shapes.length; i++)
            {
                Shape.shapes[i].move();
            }
        }
        
        private function onMouseClick(event:MouseEvent):void 
        {
            if (canvas.getObjectsUnderPoint(new Point(stage.mouseX, stage.mouseY)).length != 1) return;
            
            var mx:int = mouseX;
            var my:int = mouseY;
            
            var polygonData:Array =
            [
                {vertex:5, isStar:true },
                {vertex:5, isStar:false},
                {vertex:3, isStar:false}
            ];
            
            var obj:Object = 
            {
                type:int(Math.random() * Utils.SHAPE_NUM),
                radius:int(15 + Math.random() * 19),
                scale:0.8 + Math.random() * 0.7,
                color:Utils.SHAPE_COLOR,
                rotation:Math.random() * 360,
                polygonData:polygonData[int(Math.random() * polygonData.length)]
            };
            
            var mask:Sprite = Utils.getShape(obj);
            mask.x = mx;
            mask.y = my;
            Shape.maskContainer.addChild(mask);
            
            var shape:Shape = new Shape();
            shape.canvas = shape.addChild(Utils.getShape(obj)) as Sprite;
         //   shape.mask = Shape.maskContainer;
            shape.maskData = mask;
            shape.type = obj.type;
            shape.x = mx;
            shape.y = my;
            addChildAt(shape, 0);
            Shape.shapes.push(shape);
        }
    }
}

import flash.display.CapsStyle;
import flash.display.JointStyle;
import flash.display.Sprite;
import flash.geom.Point;

class Shape extends Sprite
{
    public static var floor:Sprite;
    public static var maskContainer:Sprite;
    public static var shapes/*Shape*/:Array = [];
    public var maskData:Sprite;
    public var canvas:Sprite;
    public var type:int;
    public var vy:Number = 0.27;
    public var obj:Object;
    
    public function move():void
    {
        y += vy;
        vy += 0.05;
        
        if (y >= 500)
        {
            shapes.splice(shapes.indexOf(this), 1);
            Main.instance.removeChild(this);
        }
    }
}

class Utils
{
    public static const SHAPE_COLOR:int = 0xFAFAFA;
    public static const SHAPE_NUM:int = 7;
    public static const shapes/*Function*/:Array = [getRectangleShape, getLeafShape, getCircleShape, getPolygonShape, getOnpuShape, getHeartShape, getFlaskShape, getLockShape];
    
    public static function getShape(obj:Object):Sprite
    {
        return shapes[obj.type](obj);
    }
    
    private static function getLeafShape(obj:Object):Sprite
    {
        var shape:Sprite = new Sprite();
        shape.graphics.lineStyle(6.0, obj.color);
        shape.graphics.beginFill(obj.color);
        shape.graphics.lineTo(12, 22);
        shape.graphics.lineTo(21, 16);
        shape.graphics.lineTo(21, 49);
        shape.graphics.lineTo(34, 37);
        shape.graphics.lineTo(38, 46);
        shape.graphics.lineTo(55, 44);
        shape.graphics.lineTo(50, 61);
        shape.graphics.lineTo(56, 66);
        shape.graphics.lineTo(29, 87);
        shape.graphics.lineTo(31, 100);
        shape.graphics.lineTo(3, 98);
        shape.graphics.lineTo(3, 125);
        shape.graphics.lineTo(6, 130);
        shape.graphics.lineTo(-6, 130);
        shape.graphics.lineTo(-3, 125);
        shape.graphics.lineTo(-3, 98);
        shape.graphics.lineTo(-31, 100);
        shape.graphics.lineTo(-29, 87);
        shape.graphics.lineTo(-56, 66);
        shape.graphics.lineTo(-50, 61);
        shape.graphics.lineTo(-55, 44);
        shape.graphics.lineTo(-38, 46);
        shape.graphics.lineTo(-34, 37);
        shape.graphics.lineTo(-21, 49);
        shape.graphics.lineTo(-21, 16);
        shape.graphics.lineTo(-12, 22);
        shape.graphics.lineTo(0, 0);
        shape.graphics.endFill();
        shape.y = -shape.height / 2;
        
        var leaf:Sprite = new Sprite();
        leaf.addChild(shape);
        leaf.rotation = obj.rotation;
        leaf.scaleX = leaf.scaleY = obj.scale / 2;
        
        return leaf;
    }
    
    private static function getHeartShape(obj:Object):Sprite
    {
        var heart:Sprite = new Sprite();
        heart.graphics.beginFill(obj.color);
        heart.graphics.lineStyle(6.0, obj.color);
        heart.graphics.moveTo(0, 0); 
        heart.graphics.curveTo(-5, -25, -26, -30);
        heart.graphics.curveTo(-50, -25, -50, 0);
        heart.graphics.curveTo(-50, 10, -40, 20); 
        heart.graphics.curveTo(-50, 10, 0, 65); 
        heart.graphics.lineTo(0, 0);
        heart.graphics.curveTo(5, -25, 26, -30);
        heart.graphics.curveTo(50, -25, 50, 0);
        heart.graphics.curveTo(50, 10, 40, 20); 
        heart.graphics.curveTo(50, 10, 0, 65);
        heart.graphics.endFill();

        heart.scaleX = heart.scaleY = obj.scale / 2;
        heart.rotation = obj.rotation;
        
        return heart;
    }
    
    private static function getFlaskShape(obj:Object):Sprite
    {
        var flask:Sprite = new Sprite();
        flask.graphics.lineStyle(6.0, obj.color);
        flask.graphics.beginFill(obj.color);
        flask.graphics.moveTo(-18, 0);
        flask.graphics.lineTo(18, 0);
        flask.graphics.lineTo(23, 8);
        flask.graphics.lineTo(12, 17);
        flask.graphics.lineTo(30, 77);
        flask.graphics.curveTo(35, 92, 28, 95);
        flask.graphics.lineTo( -28, 95);
        flask.graphics.lineTo( -28, 95);
        flask.graphics.curveTo( -35, 92, -30, 77);
        flask.graphics.lineTo( -12, 17);
        flask.graphics.lineTo(-23, 8);
        flask.graphics.lineTo( -18, 0);
        flask.graphics.endFill();
        
        flask.scaleX = flask.scaleY = obj.scale / 2;
        flask.rotation = obj.rotation;

        return flask;
    }
    
    private static function getLockShape(obj:Object):Sprite
    {
        var lock:Sprite = new Sprite();
        lock.graphics.beginFill(obj.color);
        lock.graphics.drawCircle(0, 0, 11);
        lock.graphics.endFill();
        
        lock.graphics.lineStyle(8.0, obj.color, 1, false, "normal", CapsStyle.NONE);
        lock.graphics.moveTo(0, 0);
        lock.graphics.lineTo(0, 25);
        lock.graphics.moveTo(-10, 25);
        lock.graphics.lineTo(10, 25);
        
        lock.graphics.lineStyle(8.0, obj.color);
        lock.graphics.drawRect(-45, -27, 90, 72);
        
        lock.graphics.lineStyle(8.0, obj.color, 1, false, "normal", null, JointStyle.ROUND);
        lock.graphics.moveTo( -35, -27);
        lock.graphics.lineTo( -35, -40);
        lock.graphics.curveTo( -35, -50, -30, -50);
        lock.graphics.lineTo(30, -50);
        lock.graphics.curveTo(35, -50, 35, -40);
        lock.graphics.lineTo(35, -27);
        
        lock.scaleX = lock.scaleY = obj.scale / 2;
        lock.rotation = obj.rotation;
        
        return lock;
    }
    
    private static function getOnpuShape(obj:Object):Sprite
    {
        var onpu:Sprite = new Sprite();
        
        var left:Sprite = getParts();
        left.y = 50;
        onpu.addChild(left);
        
        var right:Sprite = getParts();
        right.x = 40;
        right.y = 60;
        onpu.addChild(right);
        
        var line:Sprite = new Sprite();
        line.graphics.lineStyle(8.0, obj.color);
        line.graphics.moveTo(25, 40);
        line.graphics.lineTo(25, 3);
        line.graphics.lineTo(65, 13);
        line.graphics.lineTo(65, 50);
        line.graphics.moveTo(25, 10);
        line.graphics.lineTo(65, 20);
        onpu.addChild(line);
        
        function getParts():Sprite
        {
            var parts:Sprite = new Sprite();
            parts.graphics.beginFill(obj.color);
            parts.graphics.drawEllipse(0, 0, 30, 20);
            parts.graphics.endFill();
            parts.rotation = -45;
            
            return parts;
        }
        
        var sprite:Sprite = new Sprite();
        sprite.rotation = obj.rotation;
        sprite.scaleX = sprite.scaleY = obj.scale;
        sprite.addChild(onpu);
        onpu.x = -onpu.width / 2 - 10;
        
        return sprite;
    }
    
    private static function getCircleShape(obj:Object):Sprite
    {
        var radius:Number = obj.radius;
        var circle:Sprite = new Sprite();
        circle.graphics.beginFill(obj.color);
        circle.graphics.drawCircle(0, 0, radius);
        circle.graphics.endFill();
        
        return circle;
    }
    
    private static function getRectangleShape(obj:Object):Sprite
    {
        var radius:Number = obj.radius;
        var rect:Sprite = new Sprite();
        rect.graphics.beginFill(obj.color);
        rect.graphics.drawRoundRect( -radius, -radius, radius * 2, radius * 2, 15, 15);
        rect.graphics.endFill();
        
        rect.scaleX = rect.scaleY = obj.scale;
        rect.rotation = obj.rotation;
        
        return rect;
    }
    
    private static function getPolygonShape(obj:Object):Sprite
    {
        var vertex:int = obj.polygonData.vertex;
        var isStar:Boolean = obj.polygonData.isStar;
        
        if (vertex < 3) vertex = 3;
        var radius:int = obj.radius;
        var points:Array = new Array();
        
        var deg:int = 0;
        for (var degree:Number = deg; degree < deg + 360; degree += 360 / vertex)
        {
            var tx:Number = Math.cos(degree * Math.PI / 180) * radius;
            var ty:Number = Math.sin(degree * Math.PI / 180) * radius;
            points.push(new Point(tx, ty));

            if (isStar)
            {
                tx = Math.cos((degree + 360 / vertex / 2) * Math.PI / 180) * (radius / 2);
                ty = Math.sin((degree + 360 / vertex / 2) * Math.PI / 180) * (radius / 2);
                points.push(new Point(tx, ty));
            }
        }

        var star:Sprite = new Sprite();
        star.rotation = obj.rotation;
        star.graphics.beginFill(obj.color);
        star.graphics.moveTo(points[0].x, points[0].y);
        for (var i:int = 1; i < points.length; i++)
        {
            star.graphics.lineTo(points[i].x, points[i].y);
        }
        star.graphics.lineTo(points[0].x, points[0].y);
        
        return star;
    }
}