/**
 * Copyright ShipNK ( http://wonderfl.net/user/ShipNK )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dDcm
 */

package {
    import flash.system.Security;
    import flash.display.Stage;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.media.SoundMixer;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    [SWF(width=700, height=500, frameRate=50, backgroundColor=0xeeeeee)]
    
    public class FlashTest extends Sprite {
        
        private var sv:SoundMixer = new SoundMixer();
        private var tf:TextField = new TextField();
        private var bgm:Sound = new Sound();
        private var sh:Number = 200;
        private var downPower:Number = 0.03;
        private var shape:Shape = new Shape();
        private var shape2:Shape = new Shape();
        private var shape3:Shape = new Shape();
        private var i:int;
        private var bytes:ByteArray = new ByteArray();
        private var arr:Array = [];
        private var arrMax:Array = [];
        private var arr2:Array = [];
        
        public function FlashTest() {
            
            Security.loadPolicyFile( "http://joyfl.kr/shipworld/crossdomain.xml" );
            
            tf.text = "Loading... ";
            tf.textColor = 0;
            addChild( tf );
            bgm.load( new URLRequest( "http://joyfl.kr/shipworld/sound/bgm.mp3" ) );
            bgm.addEventListener(Event.COMPLETE, completeEvent );
            //
            this.addChild( shape );
            this.addChild( shape2 );
            this.addChild( shape3 );
            stage.addEventListener(Event.ENTER_FRAME, process );
        }

        
        private function completeEvent ( e:Event ) :void
        {
            bgm.play( 0, 10000 );
            tf.text = "Play...";
        }
        
        private function process ( e:Event ) :void
        {
            SoundMixer.computeSpectrum( bytes, true, 0 );
            bytes.position = 0;
            i = 0;
            while( bytes.bytesAvailable > 0 )
            {
                arr[ i ] = bytes.readFloat();
                if( arr[ i ] > arrMax[ i ] )
                {
                    arrMax[ i ] = arr[ i ];
                }
                else
                {
                    arrMax[ i ] -= downPower;
                    if( arrMax[ i ] < 0 )
                    {
                        arrMax[ i ] = 0;
                    }
                }
                ++i;
            }
            //
            shape.graphics.clear();
            shape.graphics.lineStyle( 0, 0xcc3300 );
            shape.graphics.moveTo( 0, 250 );
            for( i = 0; i < arr.length; ++ i )
            {
                shape.graphics.lineTo( i * 700 / arr.length, 249 - arr[ i ] * sh );
            }
            //
            shape2.graphics.clear();
            shape2.graphics.lineStyle( 0, 0 );
            shape2.graphics.moveTo( 0, 250 );
            for( i = 0; i < arrMax.length; ++ i )
            {
                shape2.graphics.lineTo( i * 700 / arrMax.length, 249 - arrMax[ i ] * sh );
            }
            //
            
            
            SoundMixer.computeSpectrum( bytes, false );
            bytes.position = 0;
            i = 0;
            while( bytes.bytesAvailable > 0 )
            {
                arr2[ i ] = bytes.readFloat();
                ++i;
            }
            shape3.graphics.clear();
            shape3.graphics.lineStyle( 0, 0 );
            shape3.graphics.moveTo( 0, 0 );
            for( i = 0; i < arr2.length; ++ i )
            {
                shape3.graphics.lineTo( i * 700 / arr2.length, 375 - arr2[ i ] * sh / 2 );
            }
        }        
                
    }
}