/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dDT3
 */

// forked from John_Blackburne's flash on 2013-11-17
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getTimer;
	
	public class Main extends Sprite {
		private const SHIPS_COUNT:int = 1000;
		private var tf:TextField;
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			tf = new TextField();
			tf.width = stage.stageWidth;
			tf.height = stage.stageHeight;
			tf.text = 'Built-in vs. Static benchmark for '+SHIPS_COUNT.toString()+' objects, v 1.0\nClick to run benchmark again\n\n';
			addChild(tf);
			stage.addEventListener(MouseEvent.CLICK, runBench);
			runBench();
			
		}
		
		private function runBench(evt:MouseEvent = null):void {
			
			var ships:Vector.<Ship> = new Vector.<Ship>();
			
			for (var i:int = 0; i < SHIPS_COUNT; i++) {
				ships.push(new Ship(Math.round(Math.random() * stage.stageWidth), Math.round(Math.random() * stage.stageHeight)));
			}
			
			tf.appendText('Benchmark "Built-in" time: ' + runBench1(ships).toString() + ' ms\n');
			tf.appendText('Benchmark "Static" time: ' + runBench2(ships).toString() + ' ms\n');
			tf.appendText('Benchmark "Built-in" time 2: ' + runBench1(ships).toString() + ' ms\n');
			tf.appendText('Benchmark "Static" time 2: ' + runBench2(ships).toString() + ' ms\n\n');

			tf.scrollV = tf.maxScrollV;
			
		}
		
		private function runBench1(ships:Vector.<Ship>):int {
			
			////
			/// Benchmark 1
			//
                        var s1:Ship, s2:Ship, len:Number;			

			var benchStart:int = getTimer();
                        len = ships.length;
			for (var i:int = 0; i < len; i++ ) {
                                s1 = ships[i];
				for (var j:int = 0; j < len; j++ ) {
                                    s2 = ships[j];
    					if (s1 != s2) {
        					var dist:Number = s1.getDist(s2);
					}
				}
			}
			return getTimer() - benchStart;
			
		}
		
		private function runBench2(ships:Vector.<Ship>):int {
			////
			/// Benchmark 2
			//
                        var s1:Ship, s2:Ship, len:Number;			

			var benchStart:int = getTimer();
                        len = ships.length;
			for (var i:int = 0; i < len; i++ ) {
                                s1 = ships[i];
				for (var j:int = 0; j < len; j++ ) {
                                    s2 = ships[j];
    					if (s1 != s2) {
        					var dist:Number =
                                        Distance.getDist(s1, s2);
					}
				}
			}
			return getTimer() - benchStart;
			
		}
		
	}
	
}

class Ship {
		
	public var x:int;
	public var y:int;
	
	final public function Ship(_x:int, _y:int) {
		
		x = _x;
		y = _y;
		
	}
	[Inline]
	public function getDist(otherShip:Ship):Number {
		var dx:Number, dy:Number;
                dx = x - otherShip.x;
                dy = y - otherShip.y;
		return Math.sqrt(dx * dx + dy * dy);
		
	}
	
}

class Distance {
	[Inline]
        public static function getDist(ship1:Ship, ship2:Ship):Number {
		var dx:Number, dy:Number;
                dx = ship1.x - ship2.x;
                dy = ship1.y - ship2.y;
		return Math.sqrt(dx * dx + dy * dy);
	}
	
}