/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dClG
 */

package {
  import flash.display.Sprite;
  import flash.events.FocusEvent;
  import flash.text.TextField;
  import flash.text.TextFieldType;
  import flash.text.TextFormat;
  import flash.utils.Dictionary;
  
  public class ch17ex8 extends Sprite {
    protected const INFMT:TextFormat = new TextFormat("_sans", 12, 0, true);
    protected const OUTFMT:TextFormat = new TextFormat("_sans", 12, 0x808080, false);
    protected var prompts:Dictionary;
    protected var nameTF:TextField;
    protected var phoneTF:TextField;
    protected var emailTF:TextField;

    public function ch17ex8() {
      prompts = new Dictionary();
      
      nameTF = makeInputTextField();
      nameTF.text = "Your name";
      nameTF.setTextFormat(OUTFMT);
      nameTF.maxChars = 40;
      prompts[nameTF] = nameTF.text;
      
      phoneTF = makeInputTextField();
      phoneTF.text = "Your phone number";
      phoneTF.setTextFormat(OUTFMT);
      phoneTF.maxChars = 20;
      phoneTF.restrict = "0-9()\\-";
      prompts[phoneTF] = phoneTF.text;
      
      emailTF = makeInputTextField();
      emailTF.text = "Your email address";
      emailTF.setTextFormat(OUTFMT);
      emailTF.maxChars = 40;
      emailTF.restrict = "a-zA-Z0-9_\\-+=~!@#$%\\^.";
      prompts[emailTF] = emailTF.text;
    }
    
    protected function onFocusIn(event:FocusEvent):void {
      var tf:TextField = TextField(event.target);
      if (tf.text == prompts[tf]) {
        tf.text = "";
      }
      tf.setTextFormat(INFMT);
      tf.defaultTextFormat = INFMT;
    }
    
    protected function onFocusOut(event:FocusEvent):void {
      var tf:TextField = TextField(event.target);
      if (tf.text == "") {
        tf.text = prompts[tf];
        tf.setTextFormat(OUTFMT);
      }
    }
    
    protected function makeInputTextField():TextField {
      var tf:TextField = new TextField();
      tf.type = TextFieldType.INPUT;
      tf.border = true;
      tf.width = 300;
      tf.height = 18;
      tf.y = numChildren * 26;
      tf.addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
      tf.addEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
      addChild(tf);
      return tf;
    }
  }
}