/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dCeS
 */

package {
	import flash.display.DisplayObjectContainer;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import net.wonderfl.utils.SequentialLoader;
    
	//[SWF(width="465", height="465", frameRate="30")]
	public class FlashTest extends Sprite {
		private static var PIG_IMAGE:String = "http://assets.wonderfl.net/images/related_images/d/d3/d3b4/d3b433219e53b955f0e99b4cdb8f80cc2f1635f8";
		private var sf:ScrapField;
		private var loader:Array = new Array();

		public function FlashTest() {
			SequentialLoader.loadImages([PIG_IMAGE], loader, init);
		}
		private function init():void{
			addChild(loader[0]);
			sf = new ScrapField(465, 465, this);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, scrapHandler);
		}
		
		public function scrapHandler(event:MouseEvent):void{
			if(!sf.show) sf.setField();
		}
	}
}

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BitmapDataChannel;
import flash.events.MouseEvent;
import flash.geom.*;

import flash.text.TextField;

class ScrapField extends Sprite{
	private var _parent:DisplayObjectContainer;
	
	//切抜領域のボディ
	private var _stage:BitmapData;
	private var _mask:BitmapData;
	private var _gray:BitmapData;
	private var body:Sprite = new Sprite();
	
	//切り抜き領域の各頂点
	private var upperLeft:ScrapPoint = new ScrapPoint(4,5);
	private var upperRight:ScrapPoint = new ScrapPoint(4,5);
	private var lowerLeft:ScrapPoint = new ScrapPoint(4,5);
	private var lowerRight:ScrapPoint = new ScrapPoint(4,5);
	private var upper:ScrapPoint = new ScrapPoint(3,4);
	private var lower:ScrapPoint = new ScrapPoint(3,4);
	private var left:ScrapPoint = new ScrapPoint(3,4);
	private var right:ScrapPoint = new ScrapPoint(3,4);
	
	private var target:Sprite;
	private var _oldX:Number;
	private var _oldY:Number;
	public var startPoint:Point;
	public var finishPoint:Point;
	public var show:Boolean = false;
	
	public function ScrapField(width:Number, height:Number, parent:DisplayObjectContainer = null):void{
		if(parent) _parent = parent;
		
		_stage = new BitmapData(width, height, true, 0xaa000000);
		_gray = new BitmapData(width, height, true, 0xaa000000);
		_mask = new BitmapData(width, height, true, 0x00000000);

		this.addChild(new Bitmap(_stage));
		this.addChild(body);
		this.addChild(upper);
		this.addChild(lower);
		this.addChild(left);
		this.addChild(right);
		this.addChild(upperLeft);
		this.addChild(upperRight);
		this.addChild(lowerLeft);
		this.addChild(lowerRight);
		
		body.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		upperLeft.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		upperRight.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		lowerLeft.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		lowerRight.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		upper.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		lower.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		left.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		right.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
	}
	public function setField():void{
		if(_parent) _parent.addChild(this);
		show = true;
		target = lowerRight;
		startPoint = new Point(mouseX, mouseY);
		finishPoint = new Point(mouseX, mouseY);
		resize();
		stage.addEventListener(MouseEvent.MOUSE_DOWN, moveCorner);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, moveCorner);
		stage.addEventListener(MouseEvent.MOUSE_UP, moveCorner);
	}
	public function clearField():void{
		if(_parent.getChildIndex(this)) _parent.removeChild(this);
		show = false;
		target = null;
		startPoint = null;
		finishPoint = null;
	}
	
	private function resize():void{
		if(!show) return;
		//各頂点の再描画
		upperLeft.point = startPoint;
		upperRight.point = new Point(finishPoint.x, startPoint.y);
		lowerLeft.point = new Point(startPoint.x, finishPoint.y);
		lowerRight.point = finishPoint;
		upper.point = Point.interpolate(upperLeft.point, upperRight.point, 0.5);
		lower.point = Point.interpolate(lowerLeft.point, lowerRight.point, 0.5);
		left.point = Point.interpolate(upperLeft.point, lowerLeft.point, 0.5);
		right.point = Point.interpolate(upperRight.point, lowerRight.point, 0.5);
		
		//ボディの再描画
		_stage.copyPixels(_gray, _gray.rect, new Point(0, 0));
		_stage.copyChannel(_mask, new Rectangle(0,0,Math.abs(finishPoint.x-startPoint.x),Math.abs(finishPoint.y-startPoint.y)),
						  new Point((startPoint.x<finishPoint.x ? startPoint.x:finishPoint.x), (startPoint.y<finishPoint.y ? startPoint.y:finishPoint.y)),
						  BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
		body.graphics.clear();
		body.graphics.lineStyle(4,0x3366ff);
		body.graphics.beginFill(0xffffff,0);
		body.graphics.drawRect(startPoint.x, startPoint.y, finishPoint.x - startPoint.x, finishPoint.y - startPoint.y);
		body.graphics.endFill();
		
	}
	private function moveCorner(event:MouseEvent):void{
		switch(event.type){
			case MouseEvent.MOUSE_DOWN:
				if(event.currentTarget == stage){
					if(Math.min(Math.max(mouseX,Math.min(startPoint.x, finishPoint.x)-6),Math.max(startPoint.x, finishPoint.x)+6) == mouseX) {
						if(Math.min(Math.max(mouseY,Math.min(startPoint.y, finishPoint.y)-6),Math.max(startPoint.y, finishPoint.y)+6) == mouseY) return;
					}
					clearField();
					return;
				}
				target = event.target as Sprite;
				_oldX = mouseX;
				_oldY = mouseY;
				stage.addEventListener(MouseEvent.MOUSE_MOVE, moveCorner);
				stage.addEventListener(MouseEvent.MOUSE_UP, moveCorner);
			break;
			case MouseEvent.MOUSE_UP:
				stage.removeEventListener(MouseEvent.MOUSE_MOVE, moveCorner);
				stage.removeEventListener(MouseEvent.MOUSE_UP, moveCorner);
			break;
			//各頂点が移動されたら呼び出される
			case MouseEvent.MOUSE_MOVE:
				switch(target){
					case body: startPoint.x -= _oldX-mouseX; startPoint.y -= _oldY-mouseY;
							   finishPoint.x -= _oldX-mouseX; finishPoint.y -= _oldY-mouseY; break;
					case upperLeft: startPoint.x = mouseX; startPoint.y = mouseY; break;
					case upperRight: finishPoint.x = mouseX; startPoint.y = mouseY; break;
					case lowerLeft: startPoint.x = mouseX; finishPoint.y = mouseY; break;
					case lowerRight: finishPoint.x = mouseX; finishPoint.y = mouseY; break;
					case upper: startPoint.y = mouseY; break;
					case lower: finishPoint.y = mouseY; break;
					case left: startPoint.x = mouseX; break;
					case right: finishPoint.x = mouseX; break;
				}
				_oldX = mouseX;
				_oldY = mouseY;
				resize();
			break;
		}
		event.updateAfterEvent();
	}
	
	public function get rect():Rectangle{
		return new Rectangle(Math.min(startPoint.x, finishPoint.x),
							Math.min(startPoint.y, finishPoint.y),
							Math.abs(startPoint.x-finishPoint.x),
							Math.abs(startPoint.y-finishPoint.y));
	}
}

class ScrapPoint extends Sprite{
	public function ScrapPoint(thick:Number, radius:Number, color:uint=0x3366ff):void{
		this.graphics.lineStyle(thick,color);
		this.graphics.beginFill(0xffffff);
		this.graphics.drawCircle(0, 0, radius);
		this.graphics.endFill();
	}
	public function set point(point:Point):void{
		this.x = point.x;
		this.y = point.y;
	}
	public function get point():Point{
		return new Point(this.x, this.y);
	}
}