/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dC2u
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.text.TextField;
	
    public class StalkerDocument extends Sprite {

    
		private var _arrow:Arrow;
		private var _crossLine:CrossLine;
		
		public function StalkerDocument(){
			init();
		}
		
		private function init():void{

			// 矢印インスタンスを生成し、ステージ中央に配置
			_arrow = new Arrow();
			addChild(_arrow);
			_arrow.x = stage.stageWidth / 2;
			_arrow.y = stage.stageHeight / 2;

			// 十字線を作成し、ステージに配置
			_crossLine = new CrossLine(stage.stageWidth, stage.stageHeight);
			addChild(_crossLine);


			stage.addEventListener(Event.ENTER_FRAME, stalk);
		}
		
		private function stalk($event:Event):void{
			var vector:Point = new Point(mouseX - _arrow.x, mouseY - _arrow.y);
			var radians:Number = Math.atan2(vector.y, vector.x);
			_arrow.rotation = radians * 180 / Math.PI;
			_crossLine.update(new Point(mouseX, mouseY), new Point(_arrow.x, _arrow.y));
		}    
	}
}

import flash.display.Sprite;
import flash.geom.Point;
import flash.text.TextField;
class Arrow extends Sprite{
	public function Arrow(){
		init();
	}
	
	private function init():void{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(0xd20000);
		graphics.moveTo(20, 0);
		graphics.lineTo(0, 20);
		graphics.lineTo(0, 10);
		graphics.lineTo(-20, 10);
		graphics.lineTo(-20, -10);
		graphics.lineTo(0, -10);
		graphics.lineTo(0, -20);
		graphics.lineTo(20, 0);
		graphics.endFill();
	}
}

class CrossLine extends Sprite{
	var _xLine:Sprite;
	var _yLine:Sprite;
	var _line:Sprite;
	var _line2:Sprite;
	var _field:TextField;
	var _field2:TextField;
	var _lineColor:uint = 0xcccccc;
	var _lineColor2:uint = 0xeeeeee;
	
	function CrossLine($width, $height){
		init($width, $height);
	}
	
	internal function init($width, $height){
		// 線のインスタンスを作成
		_xLine = new Sprite();
		_xLine.graphics.beginFill(0x003399);
		_xLine.graphics.lineStyle(0, _lineColor);
		_xLine.graphics.moveTo(0, 0);
		_xLine.graphics.lineTo($width, 0);
		_xLine.graphics.endFill();
		
		addChild(_xLine);

		_yLine = new Sprite();
		_yLine.graphics.beginFill(0x003399);
		_yLine.graphics.lineStyle(0, _lineColor);
		_yLine.graphics.moveTo(0, 0);
		_yLine.graphics.lineTo(0, $height);
		_yLine.graphics.endFill();
		addChild(_yLine);
		
		_line = new Sprite();
		addChild(_line);
		
		_line2 = new Sprite();
		addChild(_line2);

		_field = new TextField();
		addChild(_field);
		_field.width = 200;
		_field.height = 100;
		
		_field2 = new TextField();
		addChild(_field2);
		_field2.width = 100;
		_field2.height = 50;
	}
	
	public function update($mousePoint:Point, $arrowPoint:Point){
		_xLine.y = $mousePoint.y;
		_yLine.x = $mousePoint.x;
		//
		_line.graphics.clear();
		_line.graphics.beginFill(0x003399);
		_line.graphics.lineStyle(0, _lineColor2);
		_line.graphics.moveTo($arrowPoint.x, $arrowPoint.y);
		_line.graphics.lineTo($mousePoint.x, $mousePoint.y);
		_line.graphics.endFill();
		//
		
		_line2.graphics.clear();
		_line2.graphics.beginFill(0x003399);
		_line2.graphics.lineStyle(0, _lineColor2);
		_line2.graphics.moveTo($arrowPoint.x, $arrowPoint.y);
		_line2.graphics.lineTo($mousePoint.x, $arrowPoint.y);
		_line2.graphics.endFill();
		
		_field.x = $mousePoint.x;
		_field.y = $mousePoint.y;
		_field.text = (
						'mouseX : ' + $mousePoint.x + '\n' + 
						'mouseY : ' + $mousePoint.y + '\n' + 
						'distance:Point : ' + ($mousePoint.x - $arrowPoint.x) + ',' + ($mousePoint.y - $arrowPoint.y) + '\n'
					   );
		_field2.x = $arrowPoint.x + ($mousePoint.x - $arrowPoint.x) / 3;
		_field2.y = $arrowPoint.y + ($mousePoint.y - $arrowPoint.y) / 3;		
		_field2.text = (
						'tan : ' + (($mousePoint.y - $arrowPoint.y) / ($mousePoint.x - $arrowPoint.x)) + '\n' +
						'atan2 : ' + Math.atan2($mousePoint.y - $arrowPoint.y, $mousePoint.x - $arrowPoint.x) + '\n' + 
						'degree : ' + ( - (Math.atan2($mousePoint.y - $arrowPoint.y, $mousePoint.x - $arrowPoint.x)) * 180 / Math.PI)
					);
	}
}