/**
 * Copyright JorgeBraccini ( http://wonderfl.net/user/JorgeBraccini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dA4d
 */

// forked from JorgeBraccini's Micro Bitmap Rendering
package {
    import flash.events.MouseEvent;
    import flash.display.BlendMode;
    import flash.display.LoaderInfo;
    import flash.utils.ByteArray;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLLoader;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.geom.Point;
    
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.BitmapData;
    import net.hires.debug.Stats;
    import flash.external.ExternalInterface;
    import com.greensock.TweenLite;
    import com.greensock.TimelineLite;
    import com.greensock.easing.*;
    
    public class FlashTest extends Sprite {
       
        private var _engine:BmpEngine;
        private var _children:int  = 10000;
        private var _size:Number = 1;
        private var _child:Bmp;
        private var _intro:Boolean = true;
        
        private var _source:Bitmap;
        
        public function FlashTest() {
            if(stage)     setup();
            else          addEventListener(Event.ADDED_TO_STAGE, setup);
        }
        
        private function setup(e:Event = null):void {
            Console.init(this);
            Console.tracer = trace;
            
            load();
        }
        
        private function load():void {
            Console.log("load()");
            
            var url:URLRequest = new URLRequest("http://www.jbraccini.com/files/bang.png");
            var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleImageLoaded);
                loader.load(url, new LoaderContext(true));
        }

        
        private function handleImageLoaded(e:Event):void {
            Console.log("handleImageLoaded()");
            _source = e.target.content as Bitmap;
            init();
        }
        
        private function init():void {
            Console.log("init()");
            _engine = new BmpEngine(stage.stageWidth, 360);
            //_engine.addEventListener(BmpEngine.ENTER_RENDER, handleRender);
            _engine.start();
            
            addChild(_engine);
            addChild(new Stats());
            
            _child = new Bmp(_source.bitmapData.clone());            
            _engine.addChild(_child);
            
            center();
            
            intro();
        }
        
        private function intro():void {
            TweenLite.to(_child, 1, { delay: 1, scale: 10, ease: Bounce.easeOut, onComplete: outro, onUpdate: center });
        }
        
        private function outro():void {
            TweenLite.to(_child, 1, { delay: 1, scale: 1, ease: Bounce.easeOut, onComplete: intro, onUpdate: center });
        }



        private function center():void {
            _child.x = (_engine.width / 2) - (_child.width / 2);
            _child.y = (_engine.height / 2) - (_child.height / 2);
        }
                
        private function handleRender(e:Event):void {
            var f:Number = .01;
            
        }
        
        private function handleClick(e:MouseEvent):void {
            _child.scale += .1;
            
            center();
            Console.log("scale: " + _child.scale);
            Console.log("w: " + _child.bitmapData.width + " h: " + _child.bitmapData.height);
        }
        
   }

}
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.events.Event;

///////////////////////////////////////////////////////////////////
// MICRO FRAMEWORK ////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

import flash.display.DisplayObjectContainer;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.TimerEvent;
import flash.utils.Timer;


class BmpContainer extends Bitmap {
    
    public var children:Array;
    
    public function BmpContainer(source:BitmapData) {
        super(source);
        children = [];
    }
    
    public function addChild(child:Bitmap):void {
        children.push(child);
    }
    
    public function removeChild(child:Bitmap):void {
        children.splice(children.indexOf(child), 1);
    }
    
}

class Bmp extends BmpContainer {
    
    private var _o:BitmapData;
    private var _scale_f:Number = 1;
    
    public function Bmp(source:BitmapData) {
        _o = source;
        super(_o);
    }

    public function set scale(f:Number):void {
        _scale_f = f;
        
        var w:Number       = (_o.width * f) || 1;
        var h:Number       = (_o.height * f) || 1;
        var t:Boolean      = _o.transparent;
        var r:BitmapData   = new BitmapData(w, h, true, 0);
        var m:Matrix       = new Matrix();
        
        m.scale(f, f);
        r.draw(_o, m);
        
        bitmapData         = r;
    }
    
    public function get scale():Number { return _scale_f; }
    
}


class BmpEngine extends BmpContainer {
    
    public static var ENTER_RENDER:String = "enterRender";
    
    private var _clock:Timer;
    private var _initied:Boolean = false;
    private var _source:BitmapData;
    
    public function BmpEngine(w:Number, h:Number) {
        _source = new BitmapData(w, h, false, 0);
        super(_source);
        init();
    }
    
    public function start():void {
        if(_initied) _clock.start();
    }

    public function stop():void {
       if(_initied) _clock.stop();
    }    
    
    public function forceRender():void {
        render();
    }

    
    // PRIVATE
    
    private function init():void {
        _clock = new Timer(33);
        _clock.addEventListener(TimerEvent.TIMER, handleTick);
        
        _initied = true;
    }
    
    private function render():void {
        dispatchEvent(new Event(BmpEngine.ENTER_RENDER));
        
        _source = new BitmapData(_source.width, _source.height, false, 0x00ff00);
        
        var child:Bitmap;
        var t:int = children.length;
        for(var i:int = 0; i < t; i++) {
            child = children[i];
            _source.copyPixels(child.bitmapData, new Rectangle(0, 0, child.width, child.height), new Point(child.x, child.y));
            bitmapData = _source;
        }
    }

    
    private function handleTick(e:TimerEvent):void {
        render();
    }

}


/////////////////////////////////////////////////////////////////
// TRACE ////////////////////////////////////////////////////////


class Console {
    public static var tracer:Function;
    public static function init(s:DisplayObjectContainer):void {
        inittrace(s);
    }

    public static function log(s:*):void {
       if(tracer != null) tracer(s); 
    }
}

class Force {}


import flash.display.Sprite;
import com.bit101.components.TextArea;
var textarea:TextArea;
function inittrace(mainRef:DisplayObjectContainer):void {
    textarea = new TextArea();
    textarea.editable = false;
    textarea.width = mainRef.stage.stageWidth;
    textarea.height = 100;
    textarea.y = mainRef.stage.stageHeight - textarea.height;
    mainRef.addChild(textarea);
}

function doTrace(...args):void {
    var s:String = "";
    for each(var field:* in args) s += field.toString()+" ";
    s+="\n";    
    textarea.text = s + (textarea.text || "");
}
var trace:Function = doTrace;