/**
 * Copyright TheCoolMuseum ( http://wonderfl.net/user/TheCoolMuseum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d9uR
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.utils.Timer;
    import flash.geom.Matrix;
   
    
    public class Professional extends Sprite {
        private var seed:Array = [
                     [0,0,0,0,1,0,0,0],
                     [0,0,0,0,0,1,0,0],
                     [0,0,0,0,0,0,1,0],
                     [0,1,1,1,1,1,1,1],
                     [0,0,0,0,0,0,1,0],
                     [0,0,0,0,0,1,0,0],
                     [0,0,0,0,1,0,0,0],
                     [0,0,0,0,0,0,0,0]
                 ];
        private var palette:Array = [
            0xff000000,
            0xffffff00,
            0xffff0000,
            0xffff00ff,
            0xff00ffff,
            0xff00ff00,
            0xff008800,
            0xff000000,
        ];
        
        private var cnt:int = 0;
        
        private var matrix:Matrix = new Matrix(16,0,0,16,240,240);
        private var toMatrix:Matrix = new Matrix(16,0,0,16,240,240);
         
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            
            var t:Timer = new Timer(100);
            t.addEventListener(TimerEvent.TIMER, tick);
            t.start();
        }
        
        private function tick(e:Event):void{
            process();
            update();
        }
        private function process():void{
            if(sequence[cnt%sequence.length] is Array){
               for(var i:int=0; i<sequence[cnt%sequence.length].length; i++){
                   functions[sequence[cnt%sequence.length][i]]();
               } 
            }else{
               functions[sequence[cnt%sequence.length]]();
            }
            cnt++;
        }
        
        private var functions:Array =[
            nop,
            color,
            rand,
            trans,
            hline,
            vline,
            left,
            right,
            up,
            down,
            lshift,
            rshift,
            ushift,
            dshift,
        ];
        private var sequence:Array =[
             [1,7],0,0,0,
             [1,7],0,0,0,
             [1,7],0,0,0,
             [1,7],0,0,0,
             
             [1,7],0,0,0,
             [1,7],0,0,0,
             [1,7],0,0,0,
             [1,7],0,1,0,
             
             [1,4,7,13],[0,13],[0,13],[0,13],
             [1,13],[0,13],[0,13],[0,13],
             [1,4,13],[0,13],[0,13],[0,13],
             [1,13],[0,13],[0,13],[0,13],
             
             [1,7,13],[0,13],[0,13],[0,13],
             [1,13],[0,13],[0,13],[0,13],
             [1,13],[0,13],[0,13],[0,13],
             [1,13],[0,13],[1,13],[0,13],
             
             [1,3,10],11,10,11,
             [1,12],13,12,13,
             [1,10],11,10,11,
             [1,12],13,12,13,
             
             [1,10],11,10,11,
             [1,12],13,12,13,
             [1,10],11,10,11,
             [1,12],13,[1,12],13,
             
             [1,3,4],0,2,2,
             1,0,2,2,
             1,0,2,2,
             1,0,1,2,
             
             [1,5],0,2,2,
             1,0,2,2,
             1,0,2,2,
             1,0,1,2,
             
             [1,3],2,4,2,
             [1,4,5],[2,6],[5,6],[2,6],
             1,2,4,2,
             [1,4,5],[2,7],[5,7],[2,7],
             
             [1],2,4,2,
             [1,4,5],[2,8],[5,8],[2,8],
             1,[2,9],[5,9],[2,9],
             [1,4,5],[4,5],[1,4,5],[4,5],
       ];
        
        private function nop():void{
        }
        private function rand():void{
            var r1:int = int(Math.random()*seed.length);
            var r2:int = int(Math.random()*seed[r1].length);
            seed[r1][r2] = (++seed[r1][r2])%palette.length;
        }
        private function color():void{
            var c:int = 0xff;
            c = (c<<8) + int(Math.random()*9)*31;
            c = (c<<8) + int(Math.random()*9)*31;
            c = (c<<8) + int(Math.random()*9)*31;
            palette.push(c);
            while(palette.length>8){
                palette.shift();
            }
        }
        private function left():void{
            for(var i:int = 0; i<seed.length;i++){
                seed[i].push(seed[i].shift());
            }
        }
        private function right():void{
            for(var i:int = 0; i<seed.length;i++){
                seed[i].unshift(seed[i].pop());
            }
        }
        private function up():void{
               seed.push(seed.shift());
        }
        private function down():void{
               seed.unshift(seed.pop());
        }
        private function trans():void{
               toMatrix = new Matrix(
                   int(Math.random()*16+1)*2,
                   Math.random()*6-3,
                   Math.random()*6-3,
                   int(Math.random()*16+1)*2,
                   240,
                   240
               );
        }
        private function hline():void{
           var r1:int = int(Math.random()*seed.length);
           var r2:int = int(Math.random()*palette.length);
           for(var i:int = 0; i<seed[r1].length;i++){
                seed[r1][i] = r2;
            }
        }
        private function vline():void{
           var r1:int = int(Math.random()*seed[0].length);
           var r2:int = int(Math.random()*palette.length);
           for(var i:int = 0; i<seed.length;i++){
                seed[i][r1] = r2;
            }
       }
        private function lshift():void{
           var r1:int = int(Math.random()*seed.length);
           seed[r1].push(seed[r1].shift());
        }
        private function rshift():void{
           var r1:int = int(Math.random()*seed.length);
           seed[r1].unshift(seed[r1].pop());
        }
        private function ushift():void{
           var r1:int = int(Math.random()*seed[0].length);
           var tmp:int = seed[0][r1];
           for(var i:int = 0; i<seed.length;i++){
                               
                seed[i][r1] = (i==seed.length-1)?tmp:seed[i+1][r1];
            }
        }
        private function dshift():void{
           var r1:int = int(Math.random()*seed[0].length);
           var tmp:int = seed[seed[0].length-1][r1];
           for(var i:int = seed.length-1; i>=0; i--){
                               
                seed[i][r1] = i==0?tmp:seed[i-1][r1];
            }
        }
        private function update():void{
            matrix.a += toMatrix.a;
            matrix.a /=2;
            matrix.b += toMatrix.b;
            matrix.b /=2;
            matrix.c += toMatrix.c;
            matrix.c /=2;
            matrix.d += toMatrix.d;
            matrix.d /=2;
            var pattern:BitmapData = BitmapPatternBuilder.build(seed, palette);
            var g:Graphics = graphics;
            g.clear();
            g.beginBitmapFill(pattern, matrix);
            g.drawRect(0,0,480,480);
            g.endFill();
        }
        
 
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}