/**
 * Copyright yuwatanabe ( http://wonderfl.net/user/yuwatanabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d9eY
 */

package {
	import flash.display.DisplayObject;
	import flash.display.DisplayObjectContainer;
	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;

	public class DragFront2 {
		var my_mc:MovieClip;
		var bounds:Rectangle;
		//コンストラクタ
		function DragFront2(drag_mc:MovieClip,... arg) {
			my_mc=drag_mc;
			if (arg[0] is DisplayObject) {
				//引数で指定された表示オブジェクトをドラッグ制限領域にする
				bounds=arg[0].getRect(arg[0].root);
			} else {
				//ステージサイズをドラッグ制限領域にする
				bounds=new Rectangle(0,0,my_mc.stage.stageWidth,my_mc.stage.stageHeight);
			}
			//指カーソルにする
			my_mc.buttonMode=true;
			//マウスイベントの設定
			my_mc.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
		}
		//ドラッグ開始
		function onMouseDown(event:MouseEvent):void {
			my_mc.startDrag(false, bounds);
			my_mc.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
			my_mc.stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
			//ドラッグ中は半透明にする
			my_mc.alpha=0.5;
			//重なりを最前面にする
			var myContainer:DisplayObjectContainer=my_mc.root as DisplayObjectContainer;
			var lastIndex:int=myContainer.numChildren - 1;
			myContainer.setChildIndex(my_mc,lastIndex);
		}
		//ドラッグ中の更新
		function onMouseMove(event:MouseEvent):void {
			event.updateAfterEvent();
		}
		//ドラッグ終了
		function onMouseUp(event:MouseEvent):void {
			my_mc.stopDrag();
			my_mc.removeEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
			my_mc.stage.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
			//標準アルファに戻す
			my_mc.alpha=1.0;
		}
	}
}