/**
 * Copyright alpar ( http://wonderfl.net/user/alpar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d8YD
 */

package {
    import com.bit101.components.*;
    
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width = 465, height = 465, frameRate = 30)]
    
    public class Particles extends Sprite {
        private var fpsMeter:FPSMeter;
        private var meter:Meter;
        private var particleCountStepper:NumericStepper;
        private var maxSizeStepper:NumericStepper;
        private var minSizeStepper:NumericStepper;
        private var maxSpeedStepper:NumericStepper;
        private var minSpeedStepper:NumericStepper;
        private var particle:MovieClip;
        
        public function Particles() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            fpsMeter = new FPSMeter(this, 90, 120, "FPS: ");
            meter = new Meter(this, 10, 10, "FPS Meter");
            meter.maximum = 30;
            
            addEventListener(Event.ENTER_FRAME, fps);
            
            new Label(this, 300, 10, "Particle count");
            particleCountStepper = new NumericStepper(this, 370, 10);
            particleCountStepper.value = 100;
            
            new Label(this, 300, 30, "Max size");
            maxSizeStepper = new NumericStepper(this, 370, 30);
            maxSizeStepper.value = 6;
            
            new Label(this, 300, 50, "Min size");
            minSizeStepper = new NumericStepper(this, 370, 50);
            minSizeStepper.value = 2;
            
            new Label(this, 300, 70, "Max speed");
            maxSpeedStepper = new NumericStepper(this, 370, 70);
            maxSpeedStepper.value = 10;
            
            new Label(this, 300, 90, "Min speed");
            minSpeedStepper = new NumericStepper(this, 370, 90);
            minSpeedStepper.value = 5;
            
            new PushButton(this, 350, 120, "xPlode", xPlode);
        }
        
        private function fps(e:Event):void {
            meter.value = fpsMeter.fps;
        }
        
        private function xPlode(e:MouseEvent):void {
            for (var i:uint = 0; i<particleCountStepper.value; ++i) {
                particle = new MovieClip();
                particle.graphics.beginFill(Math.random() * 0xFFFFFF);
                particle.graphics.drawCircle(0, 0, (Math.floor(Math.random() * (1 + maxSizeStepper.value - minSizeStepper.value)) + minSizeStepper.value) / 2);
                particle.x = 232;
                particle.y = 232;
                particle.rotation = Math.random() * 360;
                particle.speed = Math.floor(Math.random() * (1 + maxSpeedStepper.value - minSpeedStepper.value)) + minSpeedStepper.value;
                addChild(particle);
                particle.addEventListener(Event.ENTER_FRAME, loop);
            }
        }
        
        private function loop(e:Event):void {
            e.target.x += e.target.speed * Math.sin((e.target.rotation * Math.PI) / 180);
            e.target.y -= e.target.speed * Math.cos((e.target.rotation * Math.PI) / 180);
            e.target.alpha -= 0.01;
            if (e.target.alpha <= 0) {
                e.target.removeEventListener(Event.ENTER_FRAME, loop);
                removeChild(MovieClip(e.target));
            }
        }
    }
}