/**
 * Copyright matsumos ( http://wonderfl.net/user/matsumos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d8Te
 */

package
{
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.utils.Dictionary;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author matsumos
     */
    public class CarouselTest extends Sprite
    {
        private const carpusel:Carousel = new Carousel();

        public function CarouselTest()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var headSprite:Sprite = new Sprite();
            headSprite.graphics.beginFill(0xFF0000);
            headSprite.graphics.drawRect(0, 0, 100, 100);
            headSprite.graphics.endFill();
            addChild(headSprite);
            carpusel.appendItem(headSprite);
            
            for (var i:int = 0, ix:int = 100, last:CarouselObject; i < ix; i++)
            {
                var sprite:Sprite = new Sprite();
                sprite.graphics.beginFill(0x000000 + 0xFF / (ix + 1) * (i + 1));
                sprite.graphics.drawRect(0, 0, int(Math.random() * 50) + 50, 100);
                sprite.graphics.endFill();
                addChild(sprite);
                carpusel.appendItem(sprite);
            }
            
            var tailSprite:Sprite = new Sprite();
            tailSprite.graphics.beginFill(0x00FF00);
            tailSprite.graphics.drawRect(0, 0, 100, 100);
            tailSprite.graphics.endFill();
            addChild(tailSprite);
            carpusel.appendItem(tailSprite);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            resizeHandler();
        }
        
        private function resizeHandler(e:Event = null):void 
        {
            carpusel.rightBound = stage.stageWidth;
        }
        
        private function enterFrameHandler( e:Event ):void
        {
            carpusel.carouselX += (stage.mouseX - (stage.stageWidth*0.5)) * 0.5;
            carpusel.update();            
            carpusel.draw();
        }
        
            
    }

}

import flash.display.DisplayObject;

class Carousel
{
    private var _rightBound:int = 1024;
    public function get rightBound():int { return _rightBound; }
    public function set rightBound(value:int):void 
    {
        _rightBound = value;
    }
    
    private var _carouselX:Number = 0;
    public function get carouselX():Number { return _carouselX; }
    public function set carouselX(value:Number):void 
    {
        _carouselX = value;
    }
    
    private var _itemStaticWidth:Number;
    public function get itemStaticWidth():Number { return _itemStaticWidth; }    
    public function set itemStaticWidth(value:Number):void 
    {
        _itemStaticWidth = value;
    }
    
    private var _head:CarouselObject;
    private var _tail:CarouselObject;
    private var _itemsTotalWidth:Number = 0;
    
    public function appendItem(displayObject:DisplayObject):void
    {
        var cal:CarouselObject = new CarouselObject();
        cal.face = displayObject;
        cal.size = _itemStaticWidth ? _itemStaticWidth : displayObject.width;
        
        _itemsTotalWidth += _itemStaticWidth ? _itemStaticWidth : cal.size;
        
        if (!_head && !_tail) {
            _head = cal;
            _tail = cal;
        }
            
        _tail.next = cal;
        cal.prev = _tail;
            
        _tail = cal;
        
        _head.prev = _tail;
        _tail.next = _head;
    }
    
    public function draw():void
    {
        var item:CarouselObject = _head;
        do {
            item.face.x = item.pos;
            item = item.next;
        }
        while (item != _head);            
    }
    
    public function update():void
    {
        _carouselX = _carouselX - _itemsTotalWidth * int( _carouselX / _itemsTotalWidth );

        var item:CarouselObject = _head;
        do {
            item.pos = -100;
            item = item.next;
        }
        while (item != _head);
        
        var right:Number = _carouselX;
        var left:Number = _carouselX;
                    
        if (_carouselX < 0)
        {                
            while (right <= _rightBound)
            {
                if (right >= 0 - item.size) {
                    item.pos = right;
                }
                right += item.size;
                item = item.next;
            }
        }
        else
        {
            var firstXItem:CarouselObject;
            while (left >= 0 - item.size)
            {
                if (left <= _rightBound) {
                    item.pos = left;
                    if(firstXItem == null) firstXItem = item;
                }
                left -= item.prev.size;
                item = item.prev;
            }
            
            if ( firstXItem != null)
            {
                right = firstXItem.pos;
                item = firstXItem;
                while (right <= _rightBound)
                {
                    item.pos = right;
                    right += item.size;
                    item = item.next;
                }
                
            }
        }
    }
    

}

class CarouselObject
{
    public var pos:Number;
    public var size:Number;
    public var face:DisplayObject;
    public var prev:CarouselObject;
    public var next:CarouselObject;
}


