/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d7Og
 */

// forked from fakestar0826's Easing3D
// forked from fakestar0826's BounceInTheBox
package 
{
    import flash.events.Event;
    import flash.display.Sprite;


    public class FlashTest extends Sprite 
    {
        private var ball:Ball3D;
        private var tx:Number;
        private var ty:Number;
        private var tz:Number;
        private var easing:Number = 0.1;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        
        public function FlashTest() 
        {
            ball = new Ball3D();
            addChild(ball);
            
            tx = Math.random() * 500 - 250;
            ty = Math.random() * 500 - 250;
            tz = Math.random() * 500;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            var dx:Number = tx - ball.xpos;
            var dy:Number = ty - ball.ypos;
            var dz:Number = tz - ball.zpos;
            ball.xpos += dx * easing;
            ball.ypos += dy * easing;
            ball.zpos += dz * easing;
            
            var dist:Number = Math.sqrt(dx * dx + dy * dy + dz * dz);
            
            if(dist > 1)
            {
                tx = Math.random() * 500 - 250;
                ty = Math.random() * 500 - 250;
                tz = Math.random() * 500;
            }
            if(ball.zpos > -fl)
            {
                var scale:Number = fl / (fl + ball.zpos);
                ball.scaleX = ball.scaleY = scale;
                ball.x = vpX + ball.xpos * scale;
                ball.y = vpY + ball.ypos * scale;
                ball.visible = true;
            }
            else
            { 
                ball.visible = false;
            }


        }
        
    }
}
import flash.display.Sprite;

class Ball3D extends Sprite
{
    public var r:Number;
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var mass:Number = 1;
    
    public function Ball3D(r:Number = 40, c:uint = 0xFF0000)
    {
        this.r = r;
        graphics.beginFill(c);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }

}
