/**
 * Copyright soulburner ( http://wonderfl.net/user/soulburner )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d58d
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.utils.ByteArray;
    import apparat.memory.Memory;
    
    public class FlashTest extends Sprite {
     
     
        private const ASIZE: int = 1500;
        private const ASIZE2: int = ASIZE*ASIZE;
        private var ttt: TextField = new TextField();
        private var time_mark: Date;
        
        private function timeStart(): void {
            time_mark = new Date();
        }
        
        private function timeStop(): Number {
            var t2: Date = new Date();
            var ms: Number = t2.getTime() - time_mark.getTime();
            return ms;
        }
        
        private function runTest(msg: String, fnc: Function): void {
            
            var time: Number = 0;
            for (var iter: int = 0; iter < 5; iter++) {
                timeStart();
                fnc();
                time += timeStop();
            }
            ttt.appendText(msg + ": " + Math.round(time / iter) + " ms.\n");
            
        } 
 
        public function FlashTest() {
            
            ttt.multiline = true;
            ttt.selectable = true;
            ttt.width = 300;
            ttt.height = 500;
            addChild(ttt);

            var i: int, j: int;
            
            // create storages
            var ar: Array = new Array();
            var ar2d: Array = new Array();
            var v: Vector.<int> = new Vector.<int>(ASIZE*ASIZE, true);
            var v2d: Vector.<Vector.<int>> = new Vector.<Vector.<int>>(ASIZE, true);
            var ba: ByteArray = new ByteArray();
            
            for (i=0; i<ASIZE*ASIZE; i++) {
                ar[i] = 0;
                v[i] = 0;
                ba.writeByte(0);
            }
            
            for (i=0; i<ASIZE; i++) {
                ar2d[i] = new Array();
                v2d[i] = new Vector.<int>(ASIZE, true);
                for (j=0; j<ASIZE; j++) {
                    ar2d[i][j] = 0;
                }
            }
            
            var bd: BitmapData = new BitmapData(ASIZE, ASIZE, false, 0);
            
            
            // run tests
            
            runTest("2D Array - write", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        ar2d[i][j] = 10;
            });
            
            runTest("2D Array - read ", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        if (ar2d[i][j] == 0) continue;
            });
            
            runTest("1D Array - write", function(): void {
                for (i=0; i<ASIZE2; i++)
                    ar[i] = 20;
            });
            
            runTest("1D Array - read ", function(): void {
                for (i=0; i<ASIZE2; i++)
                    if (ar[i] == 0) continue;
            });
            
            runTest("BitmapData - write", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        bd.setPixel(i, j, 20);
            });
            
            runTest("BitmapData - read ", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        if (bd.getPixel(i, j) == 0) continue;
            });
            
            runTest("2D Vector - write", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        v2d[i][j] = 10;
            });
            
            runTest("2D Vector - read ", function(): void {
                for (i=0; i<ASIZE; i++)
                    for (j=0; j<ASIZE; j++)
                        if (v2d[i][j] == 0) continue;
            });
            
            runTest("1D Vector - write", function(): void {
                for (i=0; i<ASIZE2; i++)
                    v[i] = 20;
            });
            
            runTest("1D Vector - read ", function(): void {
                for (i=0; i<ASIZE2; i++)
                    if (v[i] == 0) continue;
            });
            
            runTest("ByteArray - write", function(): void {
                for (i=0; i<ASIZE2; i++)
                    ba[i] = 20;
            });
            
            runTest("ByteArray - read ", function(): void {
                for (i=0; i<ASIZE2; i++)
                    if (ba[i] == 0) continue;
            });
            
            Memory.select(ba);
            
            runTest("Alchemy ByteArray - write", function(): void {
                for (i=0; i<ASIZE2; i++)
                    Memory.writeByte(20, i);
            });
            
            runTest("Alchemy ByteArray - read ", function(): void {
                for (i=0; i<ASIZE2; i++)
                    if (Memory.readUnsignedByte(i) == 0) continue;
            });


        }
    }
}