/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d57H
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import away3d.containers.View3D;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFFFFF")]
    public class Main extends View3D {
        private var _tl:Point;
        private var _br:Point;
        private var _cameraOffset:Vector3D;
        
        //private var _capture:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function Main() {
            Wonderfl.disable_capture();            
            
            AAway3D.init(this);
            _tl = new Point(stage.stageWidth * 3 / 7, stage.stageHeight * 3 / 7);
            _br = new Point(stage.stageWidth * 4 / 7, stage.stageHeight * 4 / 7);
            _cameraOffset = AAway3D.cameraOffset();
            
            //addChild(new Bitmap(_capture));
            
            var io:ImpossibleObject3D = new ImpossibleObject3D(2, 0x0);
            io.moveTo(0, -5000, 0);
            scene.addChild(io);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function onResize(event:Event = null):void {
            width = stage.stageWidth;
            height = stage.stageHeight;
            _tl.setTo(stage.stageWidth * 3 / 7, stage.stageHeight * 3 / 7);
            _br.setTo(stage.stageWidth * 4 / 7, stage.stageHeight * 4 / 7);
        }
        
        private function update(event:Event):void {
            var degreesX:Number = 45, degreesY:Number = 30;
            if (mouseX < _tl.x) {
                degreesX = Math.min(90 - 45 * mouseX / _tl.x, 90);
            } else if (mouseX > _br.x) {
                degreesX = Math.max(0, 45 - 45 * (mouseX - _br.x) / _tl.x);
            }
            if (mouseY < _tl.y) {
                degreesY = Math.max(0, 30 * mouseY / _tl.y);
            } else if (mouseY > _br.y) {
                degreesY = Math.min(30 + 60 * (mouseY - _br.y) / _tl.x, 90);
            }
            
            camera.x = 10000 * Math.sin(degreesX * Math.PI / 180) + _cameraOffset.x;
            camera.y = 10000 * Math.sin(degreesY * Math.PI / 180) + _cameraOffset.y;
            camera.z = -10000 * Math.cos(degreesX * Math.PI / 180) + _cameraOffset.z;
            camera.lookAt(_cameraOffset);
            
            render();
            //renderer.queueSnapshot(_capture);
        }
    }
}
//package {
    import away3d.containers.ObjectContainer3D;
    import flash.geom.Vector3D;
    
    //public 
    class ImpossibleObject3D extends ObjectContainer3D {
        private var _riser:Number;
        private var _subs:Vector.<ImpossibleObject3D>;
        
        private var _tlIndex:int;
        private var _trIndex:int;
        private var _blIndex:int;
        public var trPattern:uint;
        public var blPattern:uint;
        
        private static const RISERS:Array = [
            Math.pow(3.4, 0) * (100 * Math.SQRT1_2) / 10,
            Math.pow(3.4, 1) * (100 * Math.SQRT1_2) / 10,
            Math.pow(3.4, 2) * (100 * Math.SQRT1_2) / 10,
            Math.pow(3.4, 3) * (100 * Math.SQRT1_2) / 10,
            Math.pow(3.4, 4) * (100 * Math.SQRT1_2) / 10,
            Math.pow(3.4, 5) * (100 * Math.SQRT1_2) / 10
        ];
        
        public function ImpossibleObject3D(level:int, pattern:uint) {
            _riser = RISERS[int(level - 1)];
            
            (level == 0) ? buildLevel0() : build(level, pattern);
        }
        
        private function buildLevel0():void {
            AAway3D.addCube(this);
            _tlIndex = _trIndex = _blIndex = 0;
            trPattern = blPattern = 0;
        }
        
        private function build(level:int, pattern:uint):void {
            _subs = new Vector.<ImpossibleObject3D>(10, true);
            
            var type:uint = pattern & 0x1;
            var subPattern:Function, subPos:Function, setProps:Function;
            if (type == 0x0) {
                subPattern = subPattern0; subPos = subPos0; setProps = setProps0;
            } else {
                subPattern = subPattern1; subPos = subPos1; setProps = setProps1;
            }
            
            for (var i:int = 0; i < 10; i++) {
                addChild(_subs[i] = new ImpossibleObject3D(level - 1, subPattern(i, pattern)));
            }
            subPos();
            setProps(type);
        }
        
        private function subPattern0(index:int, pattern:uint):uint {
            switch(index) {
                case 0: { return pattern >> 1; }
                case 1: { return ~_subs[0].trPattern; } case 2: { return ~_subs[1].trPattern; } case 3: { return ~_subs[2].trPattern; }
                case 4: { return ~_subs[3].blPattern; } case 5: { return ~_subs[0].blPattern; } case 6: { return ~_subs[4].blPattern; }                
                case 7: { return ~_subs[5].blPattern; } case 8: { return ~_subs[7].trPattern; } case 9: { return ~_subs[8].trPattern; }
                default: { return 0x0; }
            }
        }
        
        private function subPattern1(index:int, pattern:uint):uint {
            switch(index) {
                case 0: { return pattern >> 1; }
                case 1: { return ~_subs[0].blPattern; } case 2: { return ~_subs[0].trPattern; } case 3: { return ~_subs[2].trPattern; }
                case 4: { return ~_subs[1].blPattern; } case 5: { return ~_subs[3].blPattern; } case 6: { return ~_subs[4].blPattern; }
                case 7: { return ~_subs[6].trPattern; } case 8: { return ~_subs[7].trPattern; } case 9: { return ~_subs[8].trPattern; }
                default: { return 0x0; }
            }
        }
        
        private function subPos0():void {
            subMove(1, 0, 3); subMove(2, 1, 3); subMove(3, 2, 3);
            subMove(4, 3, 1); subMove(6, 4, 1); subMove(9, 6, 1);
            subMove(8, 9, 2); subMove(7, 8, 2); subMove(5, 7, 0);
        }
        
        private function subPos1():void {
            subMove(1, 0, 1); subMove(4, 1, 1); subMove(6, 4, 1);
            subMove(7, 6, 3); subMove(8, 7, 3); subMove(9, 8, 3);
            subMove(5, 9, 0); subMove(3, 5, 0); subMove(2, 3, 2);
        }
        
        private function subMove(targetIndex:int, prevIndex:int, direction:int):void {
            var p:Vector3D, q:Vector3D;
            var target:ImpossibleObject3D = _subs[targetIndex];
            var prev:ImpossibleObject3D = _subs[prevIndex];
            switch(direction) {
                case 0: {
                    p = prev.tl; q = target.bl;
                    target.moveTo(p.x - q.x, p.y - q.y + _riser, p.z - q.z + 100);
                    break;
                }
                case 1: {
                    p = prev.bl;
                    target.moveTo(p.x, p.y + _riser, p.z - 100);
                    break;
                }
                case 2: {
                    p = prev.tl; q = target.tr;
                    target.moveTo(p.x - q.x - 100, p.y - q.y + _riser, p.z - q.z);
                    break;
                }
                case 3: {
                    p = prev.tr;
                    target.moveTo(p.x + 100, p.y + _riser, p.z);
                    break;
                }
            }
        }
        
        private function setProps0(type:uint):void {
            _tlIndex = 0; _trIndex = 3; _blIndex = 7;
            trPattern = (_subs[3].trPattern << 1) + type;
            blPattern = (_subs[7].blPattern << 1) + type;
        }
        
        private function setProps1(type:uint):void {
            _tlIndex = 0; _trIndex = 3; _blIndex = 6;
            trPattern = (_subs[3].trPattern << 1) + type;
            blPattern = (_subs[6].blPattern << 1) + type;
        }
        
        public function get tl():Vector3D { return (_subs) ? _subs[_tlIndex].tl.add(position) : position; }
        public function get tr():Vector3D { return (_subs) ? _subs[_trIndex].tr.add(position) : position; }
        public function get bl():Vector3D { return (_subs) ? _subs[_blIndex].bl.add(position) : position; }
    }
//}
//package {
    import away3d.containers.View3D;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.geom.Vector3D;
    
    //public 
    class AAway3D {
        public static var texture:BitmapData;
        private static var _instance:IAway3D;
        
        public static function init(view:View3D):void {
            texture = createTexture();
            //_instance = new Away3D_3_6(view);
            _instance = new Away3D_4_0(view);
        }
        
        private static function createTexture():BitmapData {
            var result:BitmapData = new BitmapData(128, 128, false, 0x000000);
            var sp:Sprite = new Sprite();
            var g:Graphics = sp.graphics;
            var m:Matrix = new Matrix();
            m.createGradientBox(128, 128);
            g.beginGradientFill(GradientType.RADIAL, [0xffffff, 0x888888], [1, 1], [0, 255], m);
            g.drawRect(0, 0, 128, 128);
            g.endFill();
            result.draw(sp);
            return result;
        }
        
        public static function addCube(io:ImpossibleObject3D):void {
            _instance.addCube(io);
        }
        
        public static function cameraOffset():Vector3D {
            return _instance.cameraOffset();
        }
    }
//}
//package {
    import flash.geom.Vector3D;
    
    //public 
    interface IAway3D {
        function addCube(io:ImpossibleObject3D):void;
        function cameraOffset():Vector3D;
    }
//}
/*
package {
    import away3d.cameras.lenses.OrthogonalLens;
    import away3d.containers.View3D;
    import away3d.lights.DirectionalLight3D;
    import away3d.materials.WhiteShadingBitmapMaterial;
    import away3d.primitives.Cube;
    import away3d.primitives.data.CubeMaterialsData;
    import flash.geom.Vector3D;
    
    //public 
    class Away3D_3_6 implements IAway3D {
        private var _material:WhiteShadingBitmapMaterial;
        
        public function Away3D_3_6(view:View3D) {
            _material = new WhiteShadingBitmapMaterial(AAway3D.texture);
            
            var light:DirectionalLight3D = new DirectionalLight3D( {
                color: 0xFFFFFF, ambient: 0, diffuse: 1, specular: 0,
                direction: new Vector3D(-0.2, -1, 0.6)
            });
            view.scene.addLight(light);
            
            view.camera.lens = new OrthogonalLens();
            view.camera.focus = 3.5;
            view.camera.zoom = 1;
        }
        
        public function addCube(io:ImpossibleObject3D):void {
            io.addChild(
                new Cube({
                    width : 100, height : 10000, depth : 100,
                    faces: new CubeMaterialsData({
                        front: _material, left: _material, bottom: _material
                    })
                })
            );
        }
        
        public function cameraOffset():Vector3D {
            return new Vector3D(0, 1000, -1000);
        }
    }
}
*/
//package {
    import away3d.cameras.lenses.OrthographicLens;
    import away3d.containers.View3D;
    import away3d.entities.Mesh;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.TextureMaterial;
    import away3d.primitives.CubeGeometry;
    import away3d.textures.BitmapTexture;
    import flash.geom.Vector3D;
    
    //public 
    class Away3D_4_0 implements IAway3D {
        private var _cube:CubeGeometry;
        private var _material:TextureMaterial;
        
        public function Away3D_4_0(view:View3D) {
            view.antiAlias = 4;
            
            _cube = new CubeGeometry(100, 10000, 100, 1, 1, 1, false);
            
            var light:DirectionalLight = new DirectionalLight(-0.2, -1, 0.6);
            view.scene.addChild(light);
            
            _material = new TextureMaterial(new BitmapTexture(AAway3D.texture));
            _material.lightPicker = new StaticLightPicker([light]);
            
            view.camera.lens = new OrthographicLens(1800);
            view.camera.lens.near = 0;
            view.camera.lens.far = 20000;
        }
        
        public function addCube(io:ImpossibleObject3D):void {
            io.addChild(new Mesh(_cube, _material));
        }
        
        public function cameraOffset():Vector3D {
            return new Vector3D(200, -500, 0);
        }
    }
//}