/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d4pq
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=183
    public class Euler183 extends Sprite {
        private var _tf : TextField;
  
        public function Euler183() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + solve(10000) + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        private function solve(T : int) : Number
        {
            var ts : Array = enumTerminates(T);
            
            var ret : Number = 0;
            var prevk : int = 1;
            for(var N : int = 5;N <= T;N++){
                var max : Number = 0;
                for(var k : int = prevk;k < T;k++){
                    var v : Number = k * Math.log(N / k);
                    if(max > v)break;
                    max = v;
                }
                k--;
                prevk = k;
                
                var d : int = k / GCD(N, k);
                if(ts[d]){
                    ret -= N;
                }else{
                    ret += N;
                }
            }
            return ret;
        }
        
        private function enumTerminates(n : int) : Array
        {
            var ret : Array = [false];
            for(var i : int = 1;i <= n;i++){
                var his : Object = {};
                for(var v : int = 1;!his[v];his[v] = 1, v = (v * 10) % i);
                ret.push(v == 0);
            }
            return ret;
        }
        
        private static function GCD(a : int, b : int) : int
        {
            return b == 0 ? a : GCD(b, a % b);
        }
    }
}