/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d4lk
 */

package
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='60')]
    
    /**
     * Name           : Main
     * Coded By       : Matt Wakeling
     * Date           : 08th May 2012
     * Description    : Main Class for the Application.
     *                  ActionScript 3 Peter de Jong Attractors - based on code from Cliff Pickover, Paul Bourke and Paul Richards.
     *
     * @author Matt Wakeling
     */
    public class Main extends Sprite
    {
        private var $Resolution:int = 8;
    
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }
        
        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else
                addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage, false, 0, true);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(evtInitialiseStage:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000, 1);
            this.graphics.drawRect(stage.x, stage.y, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            
            initPeterDeJongAttractor();
            
            //addChild(new Stats());
        }
        
        // initCliffordAttractor Method
        private function initPeterDeJongAttractor():void
        {
            var scrPeterDeJong:PeterDeJong = new PeterDeJong(stage.stageWidth, stage.stageHeight, $Resolution);
            scrPeterDeJong.cacheAsBitmap = true;
            scrPeterDeJong.scaleX = 1 / $Resolution;
            scrPeterDeJong.scaleY = 1 / $Resolution;
            
            addChild(scrPeterDeJong);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import frocessing.color.ColorHSV;

class PeterDeJong extends Sprite
{
    private var $Width:int = 0;
    private var $Height:int = 0;
    private var $Scale:int = 3;
    
    private var $AngleA:Number = 1.4;
    private var $AngleB:Number = -2.3;
    private var $AngleC:Number = 1;
    private var $AngleD:Number = -2.1;
    
    private var $MinX:Number   = 0;
    private var $MaxX:Number   = 0;
    
    private var $MinY:Number   = 0;
    private var $MaxY:Number   = 0;
    
    private var $Iterations:int = 100;
    private var $Points:int = 10000;
    
    private var $FrameCounter:int = 0;
    
    private var $BitmapData:BitmapData;
    private var $Bitmap:Bitmap;
    
    private var $AngleTextField:TextField;
        
    // PeterDeJong Constructor
    public function PeterDeJong($StageWidth:int, $StageHeight:int, $StageResolution:int)
    {
        
        $Width     = $StageWidth * $StageResolution;
        $Height = $StageHeight * $StageResolution;
        
        $MinX     = -$Scale;
        $MinY     = $MinX * $Height / $Width;
        
        $MaxX     = $Scale;
        $MaxY     = $MaxX * $Height / $Width;
        
        $BitmapData = new BitmapData($Width, $Height, false, 0x000000);
        $Bitmap = new Bitmap($BitmapData);
        
        addChild($Bitmap);
    
        var $HeaderTextField:TextField = createCustomTextField(320 * $StageResolution, 0);
        $HeaderTextField.text = "xn+1 = sin(a yn) - cos(b xn) \n" + "yn+1 = sin(c xn) - cos(d yn)";
        $HeaderTextField.scaleX = $HeaderTextField.scaleY = 8;
        $HeaderTextField.textColor = 0xAAAAAA;
        $HeaderTextField.background = true;
        $HeaderTextField.backgroundColor = 0x000000;
        $HeaderTextField.selectable = false;
        
        $AngleTextField = createCustomTextField(0, 450 * $StageResolution);
        $AngleTextField.text = "ANGLE A : " + $AngleA + "  ANGLE B : " + $AngleB + "  ANGLE C : " + $AngleC+ "  ANGLE D : " + $AngleD;
        $AngleTextField.scaleX = $AngleTextField.scaleY = 8;
        $AngleTextField.textColor = 0xAAAAAA;
        $AngleTextField.background = true;
        $AngleTextField.backgroundColor = 0x000000;
        $AngleTextField.selectable = false;
        
        addEventListener(Event.ENTER_FRAME, FrameEvent);
    }
    
    // FrameEvent Method
    private function FrameEvent($Event:Event):void
    {
        var $XCoord:Number = 0;
        var $YCoord:Number = 0;
        
        var $StartPoint:Number = Math.random();
        var $PeterDeJongAttractor:PeterDeJongClass = new PeterDeJongClass($StartPoint, 0.0, 0xFFFFFF);
        
        $BitmapData.lock();
        
        for (var $PointCounter:int = 0; $PointCounter < $Points; $PointCounter++)
        {
            var $NextX:Number = Math.sin($AngleA * $PeterDeJongAttractor.$y) - Math.cos($AngleB * $PeterDeJongAttractor.$x);
            var $NextY:Number = Math.sin($AngleC * $PeterDeJongAttractor.$x) - Math.cos($AngleD * $PeterDeJongAttractor.$y);
            $PeterDeJongAttractor.$x = $NextX;
            $PeterDeJongAttractor.$y = $NextY;
            
            if (isNaN($PeterDeJongAttractor.$x) || isNaN($PeterDeJongAttractor.$y))
                break;
            if ($PeterDeJongAttractor.$x == Number.NEGATIVE_INFINITY || $PeterDeJongAttractor.$x == Number.POSITIVE_INFINITY || $PeterDeJongAttractor.$y == Number.NEGATIVE_INFINITY || $PeterDeJongAttractor.$y == Number.POSITIVE_INFINITY)
                break;
          
            $XCoord = ($PeterDeJongAttractor.$x - $MinX) * $Width / ($MaxX - $MinX);
            $YCoord = ($PeterDeJongAttractor.$y - $MinY) * $Height / ($MaxY - $MinY);
        
            if (($XCoord >= 0 && $XCoord <= $Width) && ($YCoord >= 0 && $YCoord <= $Height))
            {
                $BitmapData.setPixel($XCoord, $YCoord, $PeterDeJongAttractor.$color);
            }
        }
        
        $BitmapData.unlock();
        
        if ($FrameCounter++ >= $Iterations)
        {
            removeEventListener(Event.ENTER_FRAME, FrameEvent)
            
            $FrameCounter = 0;
            
            $BitmapData.fillRect($BitmapData.rect, 0x000000);
            
            $AngleC += 0.2;
            
            if ($AngleC > 3) $AngleC = 1;
        
            $AngleTextField.text = "ANGLE A : " + $AngleA + "  ANGLE B : " + $AngleB + "  ANGLE C : " + $AngleC+ "  ANGLE D : " + $AngleD;
        
            addEventListener(Event.ENTER_FRAME, FrameEvent);
        }
    }
    
    // createCustomTextField Method
    private function createCustomTextField($x:Number, $y:Number):TextField
    {
        var $result:TextField = new TextField();
        $result.x = $x;
        $result.y = $y;
        $result.autoSize = TextFieldAutoSize.LEFT;
        
        addChild($result);
        
        return $result;
    }
}

class PeterDeJongClass
{
    public var $x:Number;
    public var $y:Number;
    public var $color:int;
    
    // PeterDeJongClass Constructor
    public function PeterDeJongClass($XCoord:Number, $YCoord:Number, $Color:int)
    {
        $x = $XCoord;
        $y = $YCoord;
        $color = $Color;
    }
}

