/**
 * Copyright PaulKoko ( http://wonderfl.net/user/PaulKoko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d3mg
 */

// forked from PaulKoko's Sensors &amp; Actuators
package 
{
    import flash.display.DisplayObjectContainer;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
   
    [SWF(backgroundColor="#000000", frameRate="30", width="400", height="400")]
    public class FlashTest extends Sprite 
    {
        public function FlashTest()
        {
            var experiment:SensorsAndActuatorsExperiment = new SensorsAndActuatorsExperiment( stage );
            Output.getInstance().start( stage );
        }
    }
}   
    
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    class Output extends Sprite
    {
        private static var _instance:Output;
        private var _txt:TextField;
        
        public function Output( $lock:SingletonEnforcer )
        {
            _txt = new TextField();
            _txt.width = 400;
            _txt.height = 400;
            _txt.x = 0;
            _txt.y = 0;
            _txt.mouseEnabled = false;
            _txt.defaultTextFormat = new TextFormat( 'Arial', 10, 0xFFFFFF );
            _txt.text = 'output';
            addChild( _txt );
            
            
        }
        
        public static function getInstance():Output
        {
              if( !_instance )
              {
                  return _instance = new Output( new SingletonEnforcer() );
              }
              
              return _instance;

        }
        
        public function start( $container:DisplayObjectContainer ):void
        {
            $container.addChild( this );
        }

        public function trace( $message:String ):void
        {
            _txt.text = $message;
            
        }

    } 
    
    class SingletonEnforcer
    {
        
    }

    /**
    27-05-2011 22:59
    having just watched a TED talk by Carlo Ratti I feel the need to eperiment
    with sensors and actuators. 
    http://www.ted.com/talks/carlo_ratti_architecture_that_senses_and_responds.html
    */
    import flash.display.DisplayObjectContainer;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    
    class SensorsAndActuatorsExperiment extends Sprite
    {
         private var _brightnessIndicator:BrightnessIndicator
         private var _lightSensor:LightSensor;
         
         public function SensorsAndActuatorsExperiment( $stage:DisplayObjectContainer )
         {
             $stage.addChild( this );
            
             buildLightMap();//test the lightmap
             $stage.addEventListener( MouseEvent.MOUSE_MOVE, mouseMoveHandler );
         }
         
         private function mouseMoveHandler( $evt:MouseEvent ):void
         {
             
             if( _brightnessIndicator )
             {
                 _brightnessIndicator.x = mouseX;
                 _brightnessIndicator.y = mouseY;
             }
             
             if( _lightSensor )
             {
                 _lightSensor.x = mouseX;
                 _lightSensor.y = mouseY;
             }


         }

         private function buildLightMap():void
         {
             
             var lightMap:LightMap = new LightMap( 100, 100, 1 );
            addChild( lightMap );
            
            _lightSensor = new LightSensor( lightMap );
            
            _brightnessIndicator = new BrightnessIndicator( _lightSensor );
            _brightnessIndicator.on()
            addChild( _brightnessIndicator );
            
            var insect:LightSensingInsect = new LightSensingInsect( lightMap );
            insect.x = 100;
            insect.y = 100;
            addChild( insect );
         }
    }
    
    import flash.geom.Point;
    
    class LightSensingInsect extends Sprite
    {
        private var _map:LightMap;
        
        private var _sensorA:LightSensor;
        private var _sensorB:LightSensor;
        private var _sensorC:LightSensor;
        private var _sensorD:LightSensor;
        
        private var _pointA:Point;
        private var _pointB:Point;
        private var _pointC:Point;
        private var _pointD:Point;
        
        private var _brightnessIndicatorA:BrightnessIndicator;
        private var _brightnessIndicatorB:BrightnessIndicator;
        private var _brightnessIndicatorC:BrightnessIndicator;
        private var _brightnessIndicatorD:BrightnessIndicator;
        
        public function LightSensingInsect( $lightMap:LightMap )
        {
            _map = $lightMap;
            
            _sensorA = new LightSensor( $lightMap );
            _sensorB = new LightSensor( $lightMap );
            _sensorC = new LightSensor( $lightMap );
            _sensorD = new LightSensor( $lightMap );
            
            _pointA = new Point( 0,0 );
            _pointB = new Point( 0,0 );
            _pointC = new Point( 0,0 );
            _pointD = new Point( 0,0 );
            
            _brightnessIndicatorA = new BrightnessIndicator( _sensorA );
            _brightnessIndicatorA.on();
            
            _brightnessIndicatorB = new BrightnessIndicator( _sensorB );
            _brightnessIndicatorB.on();
            
            _brightnessIndicatorC = new BrightnessIndicator( _sensorC );
            _brightnessIndicatorC.on();
            
            _brightnessIndicatorD = new BrightnessIndicator( _sensorD );
            _brightnessIndicatorD.on();
            
            addChild( _brightnessIndicatorA );
            addChild( _brightnessIndicatorB );
            addChild( _brightnessIndicatorC );
            addChild( _brightnessIndicatorD );
            
            this.graphics.beginFill( 0x660066 );
            this.graphics.drawRect( -10,-15,20,30 );
            this.graphics.endFill();
            
            
            addEventListener( Event.ENTER_FRAME, update );
        }
        
        private function update( $evt:Event ):void
        {
             _sensorA.x = mouseX;
             _sensorA.y = mouseY;
             
             
        }

        override public function set x( $value:Number ):void
        {
            
            super.x = $value;
        }
        
        override public function set y( $value:Number ):void
        {
            super.y = $value;
        }
    }
    
    /*
    */
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    class BrightnessIndicator extends Sprite
    {
        
        private var _sensor:LightSensor;
        private var _active:Boolean;
        
        public function BrightnessIndicator( $sensor:LightSensor )
        {
             _sensor = $sensor;
             addEventListener( Event.ENTER_FRAME, update );   
        }
        
        private function update( $evt:Event ):void
        {
            if( !_active ) return;
            
            this.graphics.clear();
            this.graphics.beginFill( 0xFFFFFF, _sensor.data  );
            this.graphics.drawCircle( 0,0,10 );
            this.graphics.endFill();
        }

        public function on():void
        {
            _active = true;
        }

        public function off():void
        {
            _active = false;
        }
    }
    
    
    /**
    */
    interface ISensor
    {
        function get x():Number;
        function set x( $value:Number ):void;
        function get y():Number;
        function set y( $value:Number ):void;
        function get data():Number ;   
    }
    
       
    /**
    Sensors that detects brightness of light
    */
    class LightSensor implements ISensor
    {
        private var _map:LightMap;
        private var _x:Number = 0;
        private var _y:Number = 0;
        
        public function LightSensor( $map:LightMap )
        {
            _map = $map;
        }
        
        //find the brightness at the current position of the sensor with the map
        public function get data():Number
        {
            Output.getInstance().trace( _x + ',' + _y );
            return _map.brightnessAt( _x, _y );
        }  
        
        public function set x( $value:Number ):void
        {
            _x = $value;
        }
        
        public function get x():Number
        {
            return _x;
        }
        
        public function set y( $value:Number ):void
        {
           _y = $value;
        }
        
        public function get y():Number
        {
            return _y;    
        }
    }
    
    /**
       This will form the map that my light sensors will probe
    */
    class LightMap extends Sprite
    {
        private var _perlin:BitmapData;
        
        public function LightMap( $baseX:Number, $baseY:Number, $numOctaves:uint )
        {
            var baseX:Number = $baseX;
            var baseY:Number = $baseY;
            var numOctaves:uint = $numOctaves;
            var randomSeed:int = Math.random() * 10000;
            var stitch:Boolean = false;
            var fractalNoise:Boolean = false;
            var channelOptions:uint = 7;
            var grayScale:Boolean = true;
            var offsets:Array = [];
            
            _perlin = new BitmapData( 400, 400, false, 0xFFFFFF );
            _perlin.perlinNoise( baseX, baseY, numOctaves, randomSeed, stitch, fractalNoise, channelOptions, grayScale, offsets );
            
            var bitmap:Bitmap = new Bitmap( _perlin, 'auto', true );
            addChild( bitmap );    
        } 
        
       // find the brightness at a specific pixel
        public function brightnessAt( $x:Number, $y:Number ):Number
        {
            var pixel:uint = _perlin.getPixel( $x, $y );
            return pixel / 0xFFFFFF; //finds the brightness
        }    
    }