/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d3ZO
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.geom.Point;
	import flash.utils.ByteArray;
	
	// any key press envokes file dialog
	
	import mx.utils.Base64Decoder;
	/**
	 * ...
	 * @author 9re
	 */
	[SWF(backgroundColor="#000000", frameRate=31, width="465", height="465")]
	public class Main extends Sprite 
	{
		public var fr:FileReference;
		private var _pow:Number = 5; // change this number
		private var _scale:Number = 12.0;
		private var _s:Number = 90;
		private var _particles:Vector.<Particle>;
		private var _w:int;
		private var _h:int;
		private var _cw:int;
		private var _ch:int;
		private var _display:BitmapData;
		private var _down:Boolean = false;
		
		public function Main():void 
		{
			var decoder:Base64Decoder = new Base64Decoder();
			decoder.decode(_base64Str);
			_base64Str = "";
			
			var bytes:ByteArray = decoder.toByteArray();
			decoder = null;
			
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			loader.loadBytes(bytes);
		
			_cw = stage.stageWidth >> 1;
			_ch = stage.stageHeight >> 1;
		}
		
		private function completeHandler(e:Event):void 
		{
			e.target.removeEventListener(Event.COMPLETE, completeHandler);
			
			var loader:Loader = e.target.loader as Loader;
			
			
			_display = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xff000000);
			addChild(new Bitmap(_display));
			
			_w = loader.width;
			_h = loader.height;
			
			var bd:BitmapData = new BitmapData(_w, _h);
			bd.draw(loader);
			_particles = new Vector.<Particle>();
			var i:int, j:int;
			
			for (j = 0; j < _h; ++j) {
				for (i = 0; i < _w; ++i) {
					_particles.push(new Particle(i - (_w >> 1), j - (_h >> 1), bd.getPixel(i, j)));
				}
			}
			
			addEventListener(Event.ENTER_FRAME, draw);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			
			loader.unload();
		}
		
		private function keyDownHandler(e:KeyboardEvent):void 
		{
			fr = new FileReference();
			fr.browse([new FileFilter("Image(*.jpg, *.jpeg, *.png)", "*.jpg;*.jpeg;*.png;")]);
			fr.addEventListener(Event.SELECT, onSelect);
		}
		
		private function onSelect(e:Event):void 
		{
			fr.addEventListener(Event.COMPLETE, onComplete, false, 0, true);
			fr.load();
		}
		
		private function onComplete(e:Event):void 
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imagLoaded);
			loader.loadBytes(fr.data);
			
		}
		
		private function imagLoaded(e:Event):void 
		{
			e.target.removeEventListener(Event.COMPLETE, imagLoaded);
			
			var loader:Loader = e.target.loader as Loader;
			var scale:Number = Math.min(1.0, 90 / loader.width, 90 / loader.height);
			var mat:Matrix = new Matrix();
			mat.scale(scale, scale);
			var bd:BitmapData = new BitmapData(loader.width * scale, loader.height * scale);
			bd.draw(loader, mat, null, null, null, true);
			
			
			_particles = new Vector.<Particle>();
			var i:int, j:int;
			
			for (j = 0; j < _h; ++j) {
				for (i = 0; i < _w; ++i) {
					_particles.push(new Particle(i - (_w >> 1), j - (_h >> 1), bd.getPixel(i, j)));
				}
			}
		}
		
		private function mouseDownHandler(e:MouseEvent):void 
		{
			_down = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void 
		{
			_down = false;
		}
		
		private function draw(e:Event):void 
		{
			_display.lock();
			_display.applyFilter(_display, _display.rect, new Point(), new BlurFilter());
			var len:int = _particles.length;
			var i:int = len;
			var p:Particle;
			var q:Point = new Point();
			while (i--) {
				p = _particles[i];
				convert(p.x, p.y, q);
				_display.setPixel(q.x, q.y, p.color);
			}
			
			
			_display.unlock();
		}
		
		private function convert($x:Number, $y:Number, $result:Point):void {
			var dx:Number = $x / _s;
			var dy:Number = $y / _s;
			var mx:Number = (mouseX - _cw) / _s;
			var my:Number = -(mouseY - _ch) / _s;
			var r:Number;
			var t:Number;
			
			dx -= mx;
			dy -= my;
			
			r = Math.pow(Math.sqrt(dx * dx + dy * dy), _pow);
			t = Math.atan2(dx, dy);
			
			dx = r * Math.cos(t * _pow);
			dy = r * Math.sin(t * _pow);
			
			
			dx += mx;
			dy += my;
			
			$result.x = _cw + dx * _s;
			$result.y = _ch + dy * _s;
		}
		
		
		// base 64 data
		private var _base64Str:String = "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";		
	}
	
}

class Particle {
	public var x:Number;
	public var y:Number;
	public var color:uint;
	
	public function Particle($x:Number, $y:Number, $color:uint):void {
		x = $x;
		y = $y;
		color = $color;
	}
}