/**
 * Copyright hebee ( http://wonderfl.net/user/hebee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d32v
 */

// forked from hebee's forked from: Particle
// forked from xoul's Particle

package 
{
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;

    public class dev extends Sprite
    {

        private const NUM_PARTICLES:int = 100;
        private const NUM_LIGHTS:int = 2500;
        private const MAX_SPEED:Number = 1;
        private const MIN_SPEED:Number = 0.5;
        private const MAX_POWER:Number = 100;

        private const WELL_R:Number = 20;// Black Hole radius
        private var WELL_X:Number = 200;// Black Hole X postion
        private var WELL_Y:Number = 300;// Black Hole Y postion

        private var _canvas:BitmapData;
        private var _pixels:Array;
        private var _lights:Array;

        private var _alphaTransform:ColorTransform;
        private var _blurFilter:BlurFilter;

        private var _zeroPoint:Point;

        public function dev()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;

            WELL_X = stage.stageWidth / 2;
            WELL_Y = stage.stageHeight / 2;

            _blurFilter = new BlurFilter(3,3,1);
            _zeroPoint = new Point  ;

            _canvas = new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
            addChild( new Bitmap( _canvas ) );

            _pixels = new Array();

            for (var i : int = 0; i < NUM_PARTICLES*2; ++i)
            {
                var pixel:Object = {};
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.color = 0xFFFFFF;

                pixel.speed = ((Math.random()*(100*(MAX_SPEED*2 - MIN_SPEED))) + (100*MIN_SPEED))/100;
                _pixels[i] = pixel;
            }

            _lights = new Array();

            for (var n : int = 0; n < NUM_LIGHTS; ++n)
            {
                var light:Object = {};
                var p:Point = Point.polar(WELL_X + Math.random() * 100 - 50,n);
                light.x = p.x + WELL_X;
                light.y = p.y + WELL_Y;
                light.dx = 0;
                light.dy = 0;
                light.color = 0x0033CC;

                if ((Math.random()*100 + 1) > 60)
                {
                    light.color = 0x00EEFF;
                }

                light.speed = ((Math.random()*(100*(MAX_SPEED - MIN_SPEED))) + (100*MIN_SPEED))/100;
                _lights[n] = light;
            }

            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function onEnterFrame( e : Event ):void
        {
            _canvas.lock();

            var fade:Number = 5;

            while (fade --)
            {
                _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);
            }

            var pixel:Object;
            var angle:Number;
            var distance_well:Number;
            var distance_mouse:Number;

            for (var n : int = 0; n < NUM_LIGHTS; ++n)
            {
                pixel = _lights[n];

                angle = Math.atan2(pixel.y - WELL_Y,pixel.x - WELL_X);

                distance_well = getAbs(Math.sqrt((pixel.x - WELL_X) * (pixel.x - WELL_X) + (pixel.y - WELL_Y) * (pixel.y - WELL_Y)));
                if ((Math.random()*WELL_R*2+WELL_R) < distance_well || (Math.random()*100 + 1) > 80)
                {
                    pixel.dx -=  pixel.speed * Math.cos(angle);
                    pixel.dy -=  pixel.speed * Math.sin(angle);

                    pixel.dy *= (Math.random()*50)/100 + .5;
                    pixel.dx *= (Math.random()*50)/100 + .5;

                    pixel.x +=  pixel.dx;
                    pixel.y +=  pixel.dy;
                }
                else
                {
                    var p:Point = Point.polar(WELL_X + Math.random() * 100 - 50,n);
                    pixel.x = p.x + WELL_X;
                    pixel.y = p.y + WELL_Y;
                }

                _canvas.setPixel(pixel.x,pixel.y,pixel.color);
            }

            _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);

            for (var i : int = 0; i < NUM_PARTICLES; ++i)
            {
                pixel = _pixels[i];
                
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;

                distance_well = getAbs(Math.sqrt((pixel.x - WELL_X) * (pixel.x - WELL_X) + (pixel.y - WELL_Y) * (pixel.y - WELL_Y)));
                distance_mouse = getAbs(Math.sqrt((pixel.x - mouseX) * (pixel.x - mouseX) + (pixel.y - mouseY) * (pixel.y - mouseY)));

                // Random in there so some of the pixels should be sucked!
                if (distance_well > distance_mouse && (Math.random()*100 + 1) > 3)
                {
                    angle = Math.atan2(pixel.y - mouseY,pixel.x - mouseX);
                }
                else
                {
                    angle = Math.atan2(pixel.y - WELL_Y,pixel.x - WELL_X);
                }

                if ((Math.random()*WELL_R*2+WELL_R/2) < distance_well)
                {
                    pixel.dx -=  pixel.speed * Math.cos(angle);
                    pixel.dy -=  pixel.speed * Math.sin(angle);

                    pixel.dy *= (Math.random()*80)/100 + .5;
                    pixel.dx *= (Math.random()*80)/100 + .5;

                    pixel.x +=  pixel.dx;
                    pixel.y +=  pixel.dy;
                }
                else
                {
                    pixel.lastX = pixel.x = mouseX;
                    pixel.lastY = pixel.y = mouseY;
                }

                drawLine( pixel.lastX, pixel.lastY, pixel.x, pixel.y, pixel.color );
                
                // Mirror time
                pixel = _pixels[i+NUM_PARTICLES];
                
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;

                distance_well = getAbs(Math.sqrt((pixel.x - WELL_X) * (pixel.x - WELL_X) + (pixel.y - WELL_Y) * (pixel.y - WELL_Y)));
                distance_mouse = getAbs(Math.sqrt((pixel.x - (stage.stageWidth-mouseX)) * (pixel.x - (stage.stageWidth-mouseX)) + (pixel.y - (stage.stageHeight-mouseY)) * (pixel.y - (stage.stageHeight-mouseY))));

                // Random in there so some of the pixels should be sucked!
                if (distance_well > distance_mouse && (Math.random()*100 + 1) > 3)
                {
                    angle = Math.atan2(pixel.y - (stage.stageHeight-mouseY),pixel.x - (stage.stageWidth-mouseX));
                }
                else
                {
                    angle = Math.atan2(pixel.y - WELL_Y,pixel.x - WELL_X);
                }

                if ((Math.random()*WELL_R*2+WELL_R/2) < distance_well)
                {
                    pixel.dx -=  pixel.speed * Math.cos(angle);
                    pixel.dy -=  pixel.speed * Math.sin(angle);

                    pixel.dy *= (Math.random()*80)/100 + .5;
                    pixel.dx *= (Math.random()*80)/100 + .5;

                    pixel.x +=  pixel.dx;
                    pixel.y +=  pixel.dy;
                }
                else
                {
                    pixel.lastX = pixel.x = (stage.stageWidth - mouseX);
                    pixel.lastY = pixel.y = (stage.stageHeight - mouseY);
                }

                drawLine( pixel.lastX, pixel.lastY, pixel.x, pixel.y, pixel.color );
            }

            _canvas.applyFilter(_canvas,_canvas.rect,_zeroPoint,_blurFilter);
            _canvas.unlock();
        }

        private function onClick( e : MouseEvent ):void
        {
            var pixel:Object;
            var randAngle:Number;
            var randPower:Number;

            for (var i : int = 0; i < NUM_PARTICLES; ++i)
            {
                pixel = _pixels[i];
                randAngle = Math.random() * ( Math.PI << 1 );
                randPower = Math.random() * MAX_POWER - ( MAX_POWER >> 1 );
                pixel.dx = randPower * Math.cos(randAngle);
                pixel.dy = randPower * Math.sin(randAngle);
                
                
                pixel = _pixels[i+NUM_PARTICLES];
                randAngle = Math.random() * ( Math.PI << 1 );
                randPower = Math.random() * MAX_POWER - ( MAX_POWER >> 1 );
                pixel.dx = randPower * Math.cos(randAngle);
                pixel.dy = randPower * Math.sin(randAngle);
            }
        }

        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ):void
        {
            var dx:Number = endX - startX;
            var dy:Number = endY - startY;
            var a:Number;
            var b:Number;
            var tmp:Number;
            var len:Number;
            var i:int;

            if (getAbs(dx) > getAbs(dy))
            {
                a = dy / dx;
                b = startY;

                if (startX > endX)
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }

                len = endX - startX;
                for (i = 0; i < len; ++i)
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;

                if (startY > endY)
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }

                len = endY - startY;
                for (i = 0; i < len; ++i)
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }

        private function getAbs( x : Number ):Number
        {
            return x < 0 ? -x : x;
        }
    }
}