/**
 * Copyright TetsuroKato ( http://wonderfl.net/user/TetsuroKato )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d2vy
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.media.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.system.Security;

    public class SoundMixer_computeSpectrumExample extends Sprite {
        //波形の基準位置設定
        private const PLOT_HEIGHT:int = stage.stageHeight/2;
        //チャンネル毎のByteArray取得範囲
        private const CHANNEL_LENGTH:int = 10;
        private const MARGIN:int = 1;
        private var rectWidth:Number;
        private var _byteArray:ByteArray = new ByteArray();
        private var _blurFilter:BlurFilter;
        
        //サウンドの再生・毎フレームイベント設定
        public function SoundMixer_computeSpectrumExample() {
            var back:DisplayObject = new DisplayObject();
            rectWidth = stage.stageWidth / (CHANNEL_LENGTH as Number);
            Security.loadPolicyFile("http://hycro.crz.jp/crossdomain.xml");
            var sound:Sound = new Sound();
            var req:URLRequest = new URLRequest( "http://hycro.crz.jp/wonderfl/sound/u-chi-u.mp3" );
            sound.load( req );
            
            var channel:SoundChannel;
            channel = sound.play();
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            channel.addEventListener( Event.SOUND_COMPLETE, playbackCompleteHandler );
            
            //描画した波形にフィルタをかけてみる
//            _blurFilter = new BlurFilter( 5, 5, 3 );
//            filters = [ _blurFilter ];
            
//            {
//                Wonderfl.capture_delay( 33 );
//            }

        }

        //毎フレームサウンドの波形取得・線描画
        private function enterFrameHandler( e:Event ):void {
            //_byteArrayにサウンド波形の値を設定
            SoundMixer.computeSpectrum( _byteArray, false, 0 );
            var g:Graphics = graphics;
            g.beginFill(0);
            g.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            g.endFill();
            g.beginFill(0xffffff);
            g.moveTo( 0, PLOT_HEIGHT );
            
            //ひとまず左チャンネルだけ取得して描画
            var n:Number = 0;
            for ( var i:int = 0; i < CHANNEL_LENGTH; i++ ) {
                //32ビットの浮動小数値をreadFloatで取得
                //インデックス指定なしでbyteArrayを走査できるのは、
                //readFloatを実行する毎に読み取りヘッダが移動するから？要調査
                n = ( (_byteArray.readFloat()+1) * stage.stageHeight );
                g.drawRect(i*rectWidth+MARGIN, stage.stageHeight - n, rectWidth-MARGIN, stage.stageHeight); 
            }
            g.endFill()
        }
        
        //サウンドの再生が終わったらイベント解除
        private function playbackCompleteHandler( e:Event ):void {
            removeEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
    }
}