/**
 * Copyright potix2 ( http://wonderfl.net/user/potix2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d2lO
 */

//@see http://projecteuler.net/index.php?section=problems&id=5
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    
    public class Euler extends Sprite {
        private function main():void {
        		var nFactors:Array = new Array(21);
        		//手計算で求めた素因数分解を配列に保存
        		//2, 3, 5, 7, 11, 13, 17, 19
        		var primes:Array = [2,3,5,7,11,13,17,19];
        		nFactors[2] = [1,0,0,0,0,0,0,0];
        		nFactors[3] = [0,1,0,0,0,0,0,0];
			nFactors[4] = [2,0,0,0,0,0,0,0];
        		nFactors[5] = [0,0,1,0,0,0,0,0];
        		nFactors[6] = [1,1,0,0,0,0,0,0];
        		nFactors[7] = [0,0,0,1,0,0,0,0];
        		nFactors[8] = [3,0,0,0,0,0,0,0];
        		nFactors[9] = [0,2,0,0,0,0,0,0];
        		nFactors[10] = [1,0,1,0,0,0,0,0];
        		nFactors[11] = [0,0,0,0,1,0,0,0];
        		nFactors[12] = [2,1,0,0,0,0,0,0];
        		nFactors[13] = [0,0,0,0,0,1,0,0];
        		nFactors[14] = [1,0,0,1,0,0,0,0];
        		nFactors[15] = [0,1,1,0,0,0,0,0];
        		nFactors[16] = [4,0,0,0,0,0,0,0];
        		nFactors[17] = [0,0,0,0,0,0,1,0];
        		nFactors[18] = [1,2,0,0,0,0,0,0];
        		nFactors[19] = [0,0,0,0,0,0,0,1];
        		nFactors[20] = [2,0,1,0,0,0,0,0];
        		
        		var answer:int = 1;
        		for ( var i:int = 0; i < 8; i++ ) {
        			var max:int = 0;
        			for (var j:int = 2; j < 21; j++ ) {
        				if ( max < nFactors[j][i] ) {
        					max = nFactors[j][i];
        				}
        			}
        			answer *= Math.pow(primes[i], max);
        		}
        		log('answer=' +answer);
        }                
        
        //assume a > b
        private function gcd(a:int, b:int):int {
        		if ( b == 0 ) {
        			return a;
        		}
        		else {
        			return gcd(b, a % b);
        		}
        }
        
        // setup
    		private var _console:TextField;
        public function Euler() {
        		addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void {
        	    	_console = new TextField();
        	    	_console.multiline = true;
        	    	_console.selectable = true;
        	    	_console.autoSize = TextFieldAutoSize.LEFT;
        		addChild(_console);
        		main();
        }
         
        private function log(msg:String):void {
        		_console.appendText("\n" + msg);
        }
        
        private function dumpVector(v:Vector.<int>):void {
        		v.forEach(function (item:int, index:uint, vect:Vector.<int>):void {
        			this.log(item);
        		}, this);       	
        }
        
    }
}
class VectorUtil {
	public static function range(min:int, max:int):Vector.<int> {
		var ret:Vector.<int> = new Vector.<int>(max - min + 1);
		var i:int = 0;
		while(i + min <= max ) {
			ret[i] = min + i;
			i++;
		}
		return ret;
	}
}

