/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/czw4Q
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    public class Euler77 extends Sprite {
        private var _tf : TextField;
  
        public function Euler77() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            _tf.appendText(solve().toString() + "\n");
        }
        
        private function solve() : int
        {
            var cache : Object = {}; // <数字, <その数字が合計となる最小の素数, その組み合わせ>>
            var primes : Array = []; // 素数リスト
            for(var i : int = 2;;i++){
                var ct : int = 0;
                if(isPrime(i)){ // 素数だったらキャッシュに加えておく
                    primes.push(i);
                    if(!cache[i])cache[i] = {};
                    cache[i][i] = 1;
                }
                if(!cache[i])continue;
                
                var c : Object = cache[i];
                for (var k : String in c){ // キャッシュの各要素に対して、最小素数以下の素数を列挙して現在の数に足してキャッシュに足し直す。
                    var ik : int = int(k);
                    ct += c[ik];
                    for each(var p : int in primes){
                        if(p > ik)break;
                        if(!cache[i + p]){
                            cache[i + p] = {};
                        }
                        if(cache[i + p][p]){
                            cache[i + p][p] += c[ik];
                        }else{
                            cache[i + p][p] = c[ik];
                        }
                    }
                }
                delete cache[i]; // いらないキャッシュは削除
//                _tf.appendText(i.toString() + " ct " + ct.toString() + "\n");
                if(ct >= 5000)return i;
            }
            return 0;
        }
        
        private function isPrime(n : int) : Boolean
        {
            var sq : int = Math.sqrt(n);
            for(var i : int = 2;i <= sq && n % i != 0;i++);
            return i == sq + 1;
        }
    }
}
