/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/czuC
 */

// forked from ProjectNya's LightTune (3)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] LightTuneクラスだ！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1158
//
// 背景を暗くするのに ColorTransform を用いた
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    import com.bit101.components.PushButton;
    

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var light:LightTune;
        private var playing:Boolean = true;
        

        public function Main() {
            Wonderfl.capture_delay(3);
            init();
            addChild(new Stats());
            new PushButton(this,110,5,'play/pause',click);
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new LightTune(rect);
            addChild(light);
            light.start();
            //stage.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function click(evt:MouseEvent):void {
            playing = !playing;
            if (playing) {
                light.start();
            } else {
                light.stop();
            }
        }

    }

}


import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
import com.bit101.components.CheckBox;
//ColorTransform
import flash.geom.ColorTransform;

class LightTune extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var bitmapData:BitmapData;
    private static var scale:Number = 1.25;
    private var matrix:Matrix;
    private var blur:BlurFilter;
    private static var point:Point = new Point();
    private var light:EmitLight;
    private var cb:CheckBox;
    //ColorTransform
    private var colorTrans:ColorTransform;

    public function LightTune(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        canvas = new BitmapData(rect.width, rect.height, true, 0xFF000000);
        addChild(new Bitmap(canvas));
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        matrix = new Matrix();
        matrix.scale(scale, scale);
        var w:int = (rect.width - rect.width*scale)*0.5;
        var h:int = (rect.height - rect.height*scale)*0.5;
        matrix.translate(w, h);
        blur = new BlurFilter(1, 1, 3);
        light = new EmitLight();
        addChild(light);
        light.initialize(40);
        light.x = rect.width*0.5;
        light.y = rect.height*0.5;
        //ColorTransform
        colorTrans = new ColorTransform(0.96, 0.96, 0.96, 1, 0, 0, 0, 0);
        cb = new CheckBox(this,80,10,'hl');
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, draw);
    }
    private function draw(evt:Event):void {
        light.create(cb.selected);
        bitmapData.lock();
        bitmapData.draw(this);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        canvas.lock();
        //ColorTransform
        canvas.draw(bitmapData, matrix, colorTrans, null, rect, true);
        canvas.unlock();
        light.emit();
    }

}


import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var radius:uint;
    private var circles:Array;
    private static var deceleration:Number = 0.9;
    private var id:uint;
    private var color:ColorHSV;

    public function EmitLight() {
        init();
    }

    private function init():void {
        circles = new Array();
        color = new ColorHSV(0, 0.6, 1);
    }
    public function initialize(r:uint):void {
        radius = r;
    }
    public function create(isHardLight:Boolean):void {
        //id ++;
        var angle:uint = id%360;
        color.h = angle;
        var circle:Circle = new Circle(color.value);
        addChild(circle);
        circle.x = Math.cos(-angle*Math.PI/180)*radius;
        circle.y = Math.sin(-angle*Math.PI/180)*radius;
        circle.vx = (Math.random()*2 - 1)*20;
        circle.vy = (Math.random()*2 - 1)*20;
        circle.scale = Math.random()*0.75 + 0.25;
        if(isHardLight)circle.blendMode = BlendMode.HARDLIGHT;
        circles.push(circle);
    }
    public function emit():void {
        for (var n:uint = 0; n < circles.length; n++) {
            var circle:Circle = circles[n];
            circle.vx *= deceleration;
            circle.vy *= deceleration;
            circle.x += circle.vx;
            circle.y += circle.vy;
            circle.scale *= deceleration;
            if (circle.scale < 0.1) {
                circles.splice(n, 1);
                removeChild(circle);
                circle = null;
            }
        }
    }

}


import flash.display.Shape;

class Circle extends Shape {
    private static var radius:uint = 10;
    private var rgb:uint = 0xFFFFFF;
    private var _scale:Number = 1;
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Circle(c:uint = 0xFFFFFF) {
        rgb = c;
        draw();
    }

    private function draw():void {
        graphics.clear();
        graphics.beginFill(rgb);
        graphics.drawCircle(0, 0, radius);
        graphics.drawCircle(0, 0, radius*0.6);
        graphics.endFill();
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
