/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/czdH
 */

package
{
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;

    
    /**
     * ...
     * @author taiga
     */
    public class RandomArrayTest extends MovieClip
    {
        
        private var gr_before:TextField;
        private var gr_after:TextField;
        private var gs_before:TextField;
        private var gs_after:TextField;
        
        private var grBeforeArr:Array;
        private var grAfterArr:Array;
        private var gsBeforeArr:Array;
        private var gsAfterArr:Array;
        
        public function RandomArrayTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedHandler);
        }
        
        private function addedHandler(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedHandler);
            setLogo();
            setLayout();
            initialize();
        }
        
        
        
        private function initialize():void
        {
            
            grBeforeArr = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
            gsBeforeArr = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
            grAfterArr = ExRandomArray.getRandomElement(grBeforeArr, 5);
            gsAfterArr = ExRandomArray.getShuffledElement(gsBeforeArr);
            
            gr_before.text = String(grBeforeArr);
            gr_after.text = String(grAfterArr);
            gs_before.text = String(gsBeforeArr);
            gs_after.text = String(gsAfterArr);
        }
        
        //テキストの設定
        private function setLayout():void
        {
            var leftMargin:Number = 42;
            var titleFormat:TextFormat = new TextFormat();
            titleFormat.font = "Georgia";
            titleFormat.size = 20;
            
            var title1:TextField = new TextField();
            title1.text = "getRandomElement(arr:Array,num:uint)";
            title1.y = 61.8;
            title1.width = 443;
            title1.setTextFormat(titleFormat);
            addChild(title1);
            
            var title2:TextField = new TextField();
            title2.text = "getShuffledElement(arr:Array)";
            title2.y = 210.8;
            title2.width = 443;
            title2.setTextFormat(titleFormat);
            addChild(title2);
            
            var subFormat:TextFormat = new TextFormat();
            subFormat.font = "_ゴシック";
            subFormat.size = 10;
            var sub1:TextField = new TextField();
            sub1.text = "第一引数arrで与えられた配列の中からランダムに第二引数で与えられた数を取得して配列で返す。";
            sub1.y = 90.65;
            sub1.width = 443;
            sub1.setTextFormat(subFormat);
            addChild(sub1);
            
            var sub2:TextField = new TextField();
            sub2.text = "引数arrで与えられた配列をシャッフルして返す。";
            sub2.y = 239.65;
            sub2.width = 443;
            sub2.setTextFormat(subFormat);
            addChild(sub2);
            
            var baFormat:TextFormat = new TextFormat();
            baFormat.font = "Georgia";
            baFormat.size = 14;
            
            var before1:TextField = new TextField();
            before1.text = "before";
            before1.y = 126.15;
            before1.width = 50;
            before1.setTextFormat(baFormat);
            addChild(before1);
            
            var before2:TextField = new TextField();
            before2.text = "before";
            before2.y = 275.15;
            before2.width = 50;
            before2.setTextFormat(baFormat);
            addChild(before2);
            
            var after1:TextField = new TextField();
            after1.text = "after";
            after1.y = 153.15;
            after1.width = 50;
            after1.setTextFormat(baFormat);
            addChild(after1);
            
            var after2:TextField = new TextField();
            after2.text = "after";
            after2.y = 302.15;
            after2.width = 50;
            after2.setTextFormat(baFormat);
            addChild(after2);
            
            title1.x = title2.x = sub1.x = sub2.x = before1.x = before2.x = after1.x = after2.x = leftMargin;
            
            gr_before = new TextField();
            gs_before = new TextField();
            gr_after = new TextField();
            gs_after = new TextField();
            addChild(gr_before);
            addChild(gr_after);
            addChild(gs_before);
            addChild(gs_after);
            gr_before.width = gs_before.width = gr_after.width = gs_after.width = 312;
            gr_before.x = gs_before.x = gr_after.x = gs_after.x = 93;
            gr_before.y = 128.4;
            gr_after.y = 156.4;
            gs_before.y = 278.35;
            gs_after.y = 306.35;
        
        }
        
        private function setLogo():void
        {
            var logo:TextField;
            logo = new TextField();
            logo.text = "t2421.jp";
            logo.selectable = false;
            addChild(logo);
            
            var textformat:TextFormat = new TextFormat();
            textformat.font = "Georgia";
            textformat.bold = true;
            textformat.size = 15;
            
       
            logo.setTextFormat(textformat);
            logo.x = 455-logo.width;
            logo.y = 445;
        }
    
    }

}

class ExRandomArray
{
    
    public function ExRandomArray()
    {
    
    }
    
    public static function getRandomElement(arr:Array, num:uint):Array
    {
        var newArr:Array = [];
        var tempArr:Array = arr.slice(); //元の配列を変更しないように複製する。
        for (var i:int = 0; i < num; i++)
        {
            var max:uint = tempArr.length;
            var randNum:int = Math.floor(Math.random() * max);
            newArr[i] = tempArr[randNum];
            tempArr.splice(randNum, 1); //選んだものは配列から削除する。                
        }
        return newArr;
    
    }
    
    public static function getShuffledElement(arr:Array):Array
    {
        var num:uint = arr.length;
        var newArr:Array = arr.concat();
        while (num--)
        {
            var i:uint = uint(Math.random() * (num + 1));
            var t:Object = newArr[num];
            newArr[num] = newArr[i];
            newArr[i] = t;
        }
        return newArr;
    }

}
