/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/czV4
 */

package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _field:Array;
        private var _size:uint;
        
        private const UP:uint = 0;
        private const DOWN:uint = 1;
        private const LEFT:uint = 2;
        private const RIGHT:uint = 3;
        private const MAX:uint = 4;
        
        public function FlashTest() {
            init(8);
            draw();
            
            for (var index:uint = 0; index < 9; ++index) {
                var size:uint = 8 + (index *2);
                var button:SizeButton = new SizeButton(size);
                button.x = 10 + (index * 50);
                button.y = 435;
                this.addChild(button);
                button.addEventListener(MouseEvent.CLICK,
                function(e:MouseEvent):void {
                    init((e.target as SizeButton).size);
                    draw();
                });
            }
        }
        
        private function init(size:uint):void {
            _field = new Array();
            _size = size;
            for (var y:uint = 0; y < _size; ++y) {
                _field.push(new Array());
                
                for (var x:uint = 0; x < _size; ++x) {
                    var dir:uint = 0;
                    if ((x == 0) && (y == 0)) {
                        dir = (uint)(Math.random() * MAX);                        
                    }
                    else if (y == 0) {
                        do {
                            dir = (uint)(Math.random() * MAX);
                            
                            if (!((_field[y][x - 1] == RIGHT) && (dir == LEFT))) break;
                            
                        } while(true);
                    }
                    else if (x == 0) {
                        dir = (uint)(1 + (Math.random() * (MAX - 1)));
                    }
                    else {
                        do {
                            dir = (uint)(1 + (Math.random() * (MAX - 1)));

                            if (!((_field[y][x - 1] == RIGHT) && (dir == LEFT))) break;
                        } while(true);
                    }
                    _field[y].push(dir);
                }
            }            
        }
        
        private function draw():void {
            this.graphics.clear();
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            var gridSize:uint = 400 / 2 / (_size + 1);
            this.graphics.beginFill(0xffffff);

            var paddingX:uint = (465 - ((_size * 2 + 3) * gridSize)) / 2;
            var paddingY:uint = paddingX - 12;
            
            // 枠
            this.graphics.drawRect(paddingX, paddingY, gridSize * (_size + 1) * 2, gridSize );
            this.graphics.drawRect(paddingX + gridSize * (_size + 1) * 2, paddingY, gridSize, gridSize * (_size * 2 + 3) );
            this.graphics.drawRect(paddingX, paddingY + (gridSize * 2), gridSize, gridSize * (_size * 2 + 1) );
            this.graphics.drawRect(paddingX + gridSize, paddingY + gridSize * (_size + 1) * 2, gridSize * (_size * 2 ), gridSize );
            
            // 各パーツ
            for (var y:uint = 0; y < _size; ++y) {
                for (var x:uint = 0; x < _size; ++x) {
                    var left:uint = (x * gridSize * 2 + (gridSize * 2)) + paddingX;
                    var top:uint = (y * gridSize * 2 + (gridSize * 2)) + paddingY;
                    switch (_field[y][x]) {
                        case UP: this.graphics.drawRect(left, top - gridSize, gridSize, gridSize * 2); break;
                        case DOWN: this.graphics.drawRect(left, top, gridSize, gridSize * 2); break;
                        case LEFT: this.graphics.drawRect(left - gridSize, top, gridSize * 2, gridSize); break;
                        case RIGHT: this.graphics.drawRect(left, top, gridSize * 2, gridSize); break;
                    }

                }
            }
            this.graphics.endFill();            
        }


    }
}
import flash.text.TextField;
import flash.display.Sprite;
import flash.display.SimpleButton;

class SizeButton extends SimpleButton {
    private var _size:uint;    
    
    public function SizeButton(size:uint) {
        _size = size;
        var width:uint = 40;
        var height:uint = 20;
        
        var sprite:Sprite = new Sprite();
        sprite.graphics.beginFill(0x404040);
        sprite.graphics.drawRect(0, 0, width, height);
        sprite.graphics.endFill();
        
        var textField:TextField = new TextField();
        textField.width = width;
        textField.height = height;
        textField.text = "" + size + "x" + size;
        
        textField.textColor = 0xffffff;
        sprite.addChild(textField);
        
        super(sprite, sprite, sprite, sprite);
    }
    
    public function get size():uint { return _size; }
}

