/**
 * Copyright nutsu ( http://wonderfl.net/user/nutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/czKY
 */

// forked from dizgid's forked from: stage.qualityとnativeの3D描画について
// forked from dizgid's stage.qualityとnativeの3D描画について
/*
クリックでstageのqualityを変更してsprite生成

赤がLOWのときにつくったsprite
青がHIGHのときにつくったsprite

3Dのspriteがstage.qualityを変更しても生成時の見えが保持されている。
StageQuality.HIGHのときにつくったものは、stage.qualityを変えてもスムーズ。
StageQuality.LOWのときにつくったものは、stage.qualityを変えてもスムーズではない。
この描画を、制御できないのか？
//
sprite.z でキャッシュなテスト
対象Spriite内で描画してみた。
確かにLOWにしたら描画がLOWだけど、若干アンチかかる感じか。
（クリックで画質切り替え）
*/
package  
{
	import flash.display.*;
	import flash.events.*;
	import net.hires.debug.Stats;
	/**
	 * ...
	 * @author nutsu
	 */
	[SWF(width=465,height=465,backgroundColor=0,frameRate=60)]
	public class QTest extends MovieClip
	{
		
		public function QTest() 
		{
			addEventListener( Event.ADDED_TO_STAGE, init );
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.quality = "high";
			
			var s:Sprite = new TestClip();
			s.z = 0;
			s.x = s.y = 224;
			addChild( s );
			
			this.addChild(new Stats());
			stage.addEventListener( MouseEvent.MOUSE_DOWN, onmousedown );
		}
		
		private function onmousedown(e:MouseEvent):void 
		{
			stage.quality = (stage.quality=="LOW") ? "high" : "low";
		}
		
	}
	
}

import flash.display.Sprite;
import flash.events.Event;

class TestClip extends Sprite{
	
	private var dats:Array;
	private var n:int = 20;
	private var lineN:int = 50;
	
	function TestClip() {
		dats = [];
		for (var i:int = 0; i < n; i++) 
		{
			dats.push( { xs:[0], ys:[0], vx:0, vy:0, a:0.03 + Math.random() * 0.03 } );
		}
		addEventListener( Event.ENTER_FRAME, onenterframe );
	}
	
	private function onenterframe(e:Event):void 
	{
		//rotationY += 1;
		graphics.clear();
		graphics.lineStyle( 5, 0xffffff, 0.2 );
		for (var i:int = 0; i < n; i++) {
			var d:Object = dats[i];
			var xs:Array = d.xs;
			var ys:Array = d.ys;
			var len:int = xs.length;
			graphics.moveTo( xs[0], ys[0] );
			for ( var j:int = 1; j < len; j++ ) {
				graphics.lineStyle( 5-5*j/lineN, 0xffffff, 0.2 );
				graphics.lineTo( xs[j], ys[j] );
			}
			var x0:Number = xs[len - 1];
			var y0:Number = ys[len - 1];
			xs.push(  x0 += d.vx += (mouseX - x0 ) * d.a );
			ys.push(  y0 += d.vy += (mouseY - y0 ) * d.a );
			d.vx *= 0.96;
			d.vy *= 0.96;
			if ( len > lineN ) {
				xs.shift();
				ys.shift();
			}
		}
	}
	
}
