/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cylc
 */

package 
{
	import caurina.transitions.properties.CurveModifiers;
	import flash.display.*;
	import flash.events.*;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	import net.hires.debug.Stats;
	
	[SWF(width=465,height=465,backgroundColor=0xFFFFFF,frameRate=60)]
	
	/**
	 * ...
	 * @author ue
	 * 酔い注意
	 */
	
	public class Main extends Sprite 
	{
		private var container:Sprite;
		private var circles:Array = [];
		private var canvas:BitmapData;
		private var ct:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);;
		private var blur:BlurFilter = new BlurFilter(2, 2);
		private var spring:Number = 0.4;
		private var friction:Number = 0.96;
		
		static private const CNT:int = 20;
		
		public function Main():void 
		{
			container = new Sprite();
			addChild(container);
			
			canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
			addChild(new Bitmap(canvas));

			for (var i:int = 0; i < Main.CNT; i++) {
				var circle:Circle = new Circle();
				circle.scaleX = circle.scaleY = 7.0-(i /Main.CNT*5);
				container.addChild(circle);
				circles.push(circle);
			}
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			canvas.draw(container,new Matrix(), ct,BlendMode.SCREEN);
			canvas.colorTransform(canvas.rect, ct);
			for (var i:int = 0; i < circles.length; i++) {
				var circle:Circle = circles[i];
				circle.vx += (mouseX - circle.x)*spring;
				circle.vy += (mouseY - circle.y)*spring;
				circle.vx *= friction;
				circle.vy *= friction;
				circle.x += circle.vx / (20+(i*10));
				circle.y += circle.vy / (20+(i*10));
			}
		}
	}
}

import flash.display.Sprite

class Circle extends Sprite {
	public var vx:Number = 0;
	public var vy:Number = 0;
	public function Circle() {
		graphics.lineStyle(0, 0xAAAAAA);
		graphics.drawCircle(0, 0, 50);
	}
}