/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cyTV
 */

package {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getTimer;
	public class FlashTest extends Sprite {
		
		private var txt:TextField;
		
		private const VALUE1:int = 100;
		private const VALUE2:int = 200;
		
		private const vec:Vector.<int> = Vector.<int>([VALUE1, VALUE2]);
		
		private const TEST_COUNT:int = 10000000;
		
		public function FlashTest() {
			// write as3 code here..
			
			txt = new TextField();
			txt.autoSize = "left";
			
			addChild(txt);
			
			var spr:Sprite = createBtn("one more test", 0, 200);
			spr.addEventListener(MouseEvent.CLICK, test);
			addChild(spr);
			
			test();
		}
		
		private function test(e:MouseEvent = null):void 
		{
			var i:int = TEST_COUNT;
			var tmp:int;
			var local_vec:Vector.<int> = vec;
			txt.text = "";
			var timer:int = getTimer();
			
			//vector演算
			while (i--)
			{
				tmp = vec[i & 0x1];
			}
			
			txt.appendText((getTimer() - timer).toString() + "ms. Vectorテスト\n");
			
			i = TEST_COUNT;
			timer = getTimer();
			
			while (i--)
			{
				tmp = (i & 0x1) ? VALUE1 : VALUE2;
			}
			
			txt.appendText((getTimer() - timer).toString() + "ms. 三項演算テスト\n");
			
			i = TEST_COUNT;
			timer = getTimer();
			
			while (i--)
			{
				tmp = local_vec[i & 0x1];
			}
			
			txt.appendText((getTimer() - timer).toString() + "ms. Vectorテスト（ローカル）\n");
			
			i = TEST_COUNT;
			var value1:int = VALUE1;
			var value2:int = VALUE2;
			timer = getTimer();
			
			while (i--)
			{
				tmp = (i & 0x1) ? value1 : value2;
			}
			
			txt.appendText((getTimer() - timer).toString() + "ms. 三項演算テスト（ローカル）\n");
			
			i = TEST_COUNT;
			var local_vec2:Vector.<int> = Vector.<int>([value1, value2]);
			timer = getTimer();
			
			while (i--)
			{
				tmp = local_vec2[i & 0x1];
			}
			
			txt.appendText((getTimer() - timer).toString() + "ms. Vectorテスト（ローカル2）\n");
		}
		
        private function createBtn(str:String, x:int, y:int):Sprite
        {
            var txt:TextField = new TextField();
            var spr:Sprite = new Sprite();
            txt.autoSize = "left";
            txt.textColor = 0xFFFFFF;
            txt.text = str;
            txt.selectable = false;
            spr.addChild(txt);
            var g:Graphics = spr.graphics;
            g.beginFill(0, 1);
            g.drawRect(0, 0, spr.width, spr.height);
            g.endFill();
            
            spr.x = x;
            spr.y = y;
            
            spr.buttonMode = true;
            
            addChild(spr);
            
            return spr;
        }
    }
}