/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cxK0
 */

package {
    import flash.events.Event;

    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // 立方体
        private var cube:Cube;

        public function MeasuringTheTilt_Accelerometer() {
            // 立方体のためのマテリアルを準備
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial(new ColorMaterial(0xFF0000), "front");
            materialsList.addMaterial(new ColorMaterial(0x00FF00), "back");
            materialsList.addMaterial(new ColorMaterial(0x0000FF), "right");
            materialsList.addMaterial(new ColorMaterial(0xFFFF00), "left");
            materialsList.addMaterial(new ColorMaterial(0xFF00FF), "top");
            materialsList.addMaterial(new ColorMaterial(0x00FFFF), "bottom");

            // 立方体のインスタンスを生成
            cube = new Cube(materialsList, 200, 200, 200);
            scene.addChild(cube);

            // カメラをセット
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            // レンダリング開始
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            // 立方体の角度をセット
            cube.rotationZ = (stage.mouseX / stage.width - 0.5) * 180;
            cube.rotationX = (stage.mouseY / stage.height - 0.5) * 180;

            // シーンをレンダリング
            renderer.renderScene(scene, camera, viewport);
        }
    }
}