/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cwVc
 */

// forked from mex's 【AS100本ノック】1本目：Hello World
/**
 * AS100本ノック
 * 1本目のお題は「Hello World」
 * あなたなりの「Hello World」を表現してください。
 * --
 * 「はじめまして、wonderflさん」って気分で書きました。
 * それはもう「Hello World」って気分で。なのでお題の回答としてブレてマセン。
 * 
 * 初回ということで、wonderflと同じライブラリ環境をローカルに構築するのがメインでした。
 * 次回からは、もう少し考えてみます。たぶん。。。
 */
package
{
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Vector3D;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import com.flashdynamix.utils.SWFProfiler;
	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
	public class HelloWorld extends Sprite
	{
		private static const DEFAULT_TEXT:String = "はろーわんだふる！";
		private static const DEFAULT_FONT:String = "_ゴシック";
		private static const DEFAULT_TEXT_SIZE:uint = 18;
		private static const DEFAULT_POWER:uint = 50;
		private static const OVER_POWER:uint = 100;
		private var _points:PointList;
		private var _swfWidth:uint = 465;
		private var _swfHeight:uint = 465;
		private var _power:uint;
		private var _cmargin:uint = 20;
		private var _ctext:TextField;
		private var _cbutton:PushButton;
		public function HelloWorld()
		{
			Wonderfl.capture_delay(5);
			_cbutton = new PushButton(stage, 0, 0, "Change", changeClickHandler);
			_cbutton.width = 80;
			_cbutton.height = 20;
			_cbutton.x = _swfWidth - _cmargin - _cbutton.width;
			_cbutton.y = _swfHeight - _cbutton.height - _cmargin;
			_ctext = new TextField();
			_ctext.type = TextFieldType.INPUT;
			_ctext.width = _cbutton.x - (_cmargin*2);
			_ctext.height = 20;
			_ctext.x = _cmargin;
			_ctext.y = _swfHeight - _ctext.height - _cmargin;
			_ctext.text = DEFAULT_TEXT;
			_ctext.alpha = 0.7;
			_ctext.border = true;
			_ctext.background = true;
			_ctext.maxChars = 24;
			stage.addChild(_ctext);
			SWFProfiler.init(this);
			init();
		}
		private function init():void
		{
			_power = DEFAULT_POWER;
			_points = new PointList(_ctext.text, DEFAULT_TEXT_SIZE, DEFAULT_FONT);
			_points.attachParticles(this);
			_points.setCenter(_swfWidth/2, _swfHeight/2);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		private function enterFrameHandler(event:Event):void
		{
			_points.powerTo(_power);
		}
		private function mouseDownHandler(event:MouseEvent):void
		{
			_power = OVER_POWER;
		}
		private function mouseUpHandler(event:MouseEvent):void
		{
			_power = DEFAULT_POWER;
		}
		private function mouseMoveHandler(event:MouseEvent):void
		{
			var rY:Number = event.stageX/_swfWidth*90-45;
			var rX:Number = event.stageY/_swfHeight*90-45;
			_points.rotationTo(rX, rY, 0);
		}
		private function changeClickHandler(event:MouseEvent):void
		{
			if(_ctext.text)
			{
				removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
				stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
				stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
				stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
				_points.dropParticles();
				_points = null;
				init();
			}
		}
	}
}

import flash.text.TextFormat;
import flash.text.TextField;
import flash.display.BitmapData;
import flash.display.Bitmap;
import frocessing.color.ColorHSV;
class PointList extends Matrix3D
{
	private var _w:uint;
	private var _h:uint;
	private var _z:uint;
	private var _blockSize:uint;
	private var _particles:Vector.<Particle>;
	private var _sprite:Sprite;
	private var _stageWidth:Number;
	private var _stageHeight:Number;
	private var _rvector:Vector.<Number>;
	public function PointList(str:String, fontSize:uint=12, font:String="_ゴシック")
	{
		_w = 0;
		_h = 0;
		_z = 6;
		_blockSize = 1;
		_stageWidth = 0;
		_stageHeight = 0;
		_rvector = new Vector.<Number>(3);
		init(str, fontSize, font);
	}
	private function init(str:String, fontSize:uint, font:String):void
	{
		var hsv:ColorHSV = new ColorHSV(0, 1, 1, 1);
		var cellWidth:uint = fontSize * str.length;
		var cellHeight:uint = fontSize * 1.2;
		var tf:TextFormat = new TextFormat();
		tf.font = font;
		tf.size = fontSize;
		tf.color = 0xFFFFFF;
		var text:TextField = new TextField();
		text.defaultTextFormat = tf;
		text.autoSize = "left";
		text.text = str;
		var bmd:BitmapData = new BitmapData(cellWidth, cellHeight, true, 0xFF000000);
		bmd.draw(text);
		var vec:Vector.<uint> = bmd.getVector(bmd.rect);
		var posX:Number, posY:Number, posZ:Number;
		_particles = new Vector.<Particle>;
		for(var j:uint=0; j<_z; j++)
		{
			for(var i:uint=0,imax:uint=vec.length; i<imax; i++)
			{
				if(int(vec[i] & 0xffffff) > 0)
				{
					posX = i%cellWidth;
					posY = i/cellWidth;
					posZ = j;
					_w = Math.max(_w, posX * _blockSize);
					_h = Math.max(_h, posY * _blockSize);
					hsv.h = posX / cellWidth * 360 ;
					_particles.push(new Particle(
						posX * _blockSize,
						posY * _blockSize,
						posZ * _blockSize,
						_blockSize,
						hsv.value,
						(posX+posY)/2 * 0.05 + 0.5
					));
				}
			}
		}
		bmd.dispose();
		appendTranslation(-_w/2, -_h/2, -(_z*_blockSize/2));
	}
	public function setCenter(cX:Number, cY:Number):void
	{
		if(!_stageWidth && !_stageHeight)
		{
			appendTranslation(cX, cY, 0);
		}
		else
		{
			appendTranslation(-_stageWidth, -_stageHeight, 0);
			appendTranslation(cX, cY, 0);
		}
		_stageWidth = cX;
		_stageHeight = cY;
	}
	public function rotationTo(rX:Number, rY:Number, rZ:Number):void
	{
		appendTranslation(-_stageWidth, -_stageHeight, 0);
		appendRotation(rX - _rvector[0], Vector3D.X_AXIS);
		appendRotation(rY - _rvector[1], Vector3D.Y_AXIS);
		appendRotation(rZ - _rvector[2], Vector3D.Z_AXIS);
		_rvector[0] = rX;
		_rvector[1] = rY;
		_rvector[2] = rZ;
		appendTranslation(_stageWidth, _stageHeight, 0);
	}
	public function powerTo(power:uint=50):void
	{
		for each(var p:Particle in _particles)
		{
			p.powerMove(power, Vector.<Number>([_w*_blockSize/2, _h*_blockSize/2, _z*_blockSize/2]));
		}
	}
	public function attachParticles(s:Sprite):void
	{
		if(!_sprite)
		{
			_sprite = s;
			_sprite.transform.matrix3D = this;
			for each(var p:Particle in _particles)
			{
				_sprite.addChild(p);
			}

		}
	}
	public function dropParticles():void
	{
		if(_sprite)
		{
			for each(var p:Particle in _particles)
			{
				_sprite.removeChild(p);
			}
		}
	}
}

import flash.display.Sprite;
import flash.geom.Matrix3D;
import flash.geom.Vector3D;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.IObjectTween;
import org.libspark.betweenas3.events.*;
class Particle extends Sprite
{
	private static const MAX_POSITION:uint = 200;
	private var _delay:Number;
	private var _matrix3D:Matrix3D;
	private var _base3D:Vector3D;
	private var _svector:Vector.<Number>;
	private var _isActive:Boolean;
	private var _iotween:IObjectTween;
	public function Particle(posX:Number, posY:Number, posZ:Number, size:Number, color:uint, delay:Number=0)
	{
		graphics.clear();
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, size);
		graphics.endFill();
		_delay = delay;
		_base3D = new Vector3D(posX, posY, posZ);
		_svector = new Vector.<Number>(3);
		_matrix3D = new Matrix3D;
		_matrix3D.appendTranslation(posX, posY, posZ);
		this.transform.matrix3D = _matrix3D;
		_isActive = false;
		init();
	}
	public function init():void
	{
		_iotween = BetweenAS3.tween(
			this,
			{
				mX: 0,
				mY: 0,
				mZ: 0
			},
			{
				mX: randomVal(),
				mY: randomVal(),
				mZ: randomVal()
			},
			1,
			Bounce.easeOut
		);
		_iotween.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
		{
			event.target.target._isActive = true;
		});
		BetweenAS3.delay(_iotween, _delay).play();
	}
	private function randomVal():Number
	{
		return Math.random() * MAX_POSITION * (Math.random() > 0.5 ? 1 : -1);
	}
	public function set mX(num:Number):void
	{
		_matrix3D.appendTranslation(-_svector[0], -_svector[1], -_svector[2]);
		_svector[0] = num;
		_matrix3D.appendTranslation(_svector[0], _svector[1], _svector[2]);
	}
	public function get mX():Number
	{
		return _svector[0];
	}
	public function set mY(num:Number):void
	{
		_matrix3D.appendTranslation(-_svector[0], -_svector[1], -_svector[2]);
		_svector[1] = num;
		_matrix3D.appendTranslation(_svector[0], _svector[1], _svector[2]);
	}
	public function get mY():Number
	{
		return _svector[1];
	}
	public function set mZ(num:Number):void
	{
		_matrix3D.appendTranslation(-_svector[0], -_svector[1], -_svector[2]);
		_svector[2] = num;
		_matrix3D.appendTranslation(_svector[0], _svector[1], _svector[2]);
	}
	public function get mZ():Number
	{
		return _svector[2];
	}
	public function powerMove(power:uint, parent3D:Vector.<Number>):void
	{
		if(_isActive)
		{
			_matrix3D.appendTranslation(-_svector[0], -_svector[1], -_svector[2]);
			var mw:Number = Math.abs(this.mouseX);
			var mh:Number = Math.abs(this.mouseY);
			var msqrt:Number = Math.sqrt((mw*mw)+(mh*mh));
			var psqrt:Number = Math.sqrt((power*power)*2);
			if(msqrt <= psqrt)
			{
				var base:Number = psqrt - msqrt;
				_svector[0] = power * (base/power) * (_matrix3D.position.x - parent3D[0]) / parent3D[0];
				_svector[1] = power * (base/power) * (_matrix3D.position.y - parent3D[1]) / parent3D[1];
				_svector[2] = power * (base/power) * (_matrix3D.position.z - parent3D[2]) / parent3D[2];
			}
			else
			{
				_svector[0] = 0;
				_svector[1] = 0;
				_svector[2] = 0;
			}
			_matrix3D.appendTranslation(_svector[0], _svector[1], _svector[2]);
		}
	}
}
