/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cvwK
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import net.hires.debug.Stats;


    public class MPAngelo2 extends Sprite
    {
        private const NUM_P : uint = 222222;        
        private var p__ : Particle3D;//Particle;
        private var buf : Vector.<uint>;
        private var bmd : BitmapData;
        private var ofscr : BitmapData;
        private var blur : BlurFilter;
        private var dstp : Point;
        private var fcnt : int;
        private var stats:Stats = new Stats();

        public function MPAngelo2()
        {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            //stage.scaleMode = 'noScale';
            //stage.align = 'TL';
            stage.quality = 'high';
            stage.frameRate = 64;
            opaqueBackground = 0x0;
            stage.addChild( stats );
            //ENTRY POINT:
            
            /*trace( "xPos: " + p.x );
            trace( "yPos: " + p.y );
            trace( "zPos: " + p.z );*/

            var p : Particle3D = p__ = new Particle3D();
          //var p : Particle = p__ = new Particle();

            var n : uint = NUM_P;
            while (--n != 0)
            {
                var f : Number = n / NUM_P;
                var a : Number = f * (Math.PI * 2);
                var aa : Number = (1 / f) * (Math.PI * 2);
                var fuz : Number = 0.85 + 0.15 * Math.random();


                p.x   =   p.dx   =   256 +  (2048 - (1024 * Math.cos(aa * fuz) * fuz))  * Math.cos(a * fuz);
                p.y   =   p.dy   =   256 +  (2048 - (1024 * Math.sin(aa * fuz) * fuz))  * Math.sin(a * fuz);
              //p.z   =   p.dz   =   256 +  (2048 - (1024 * Math.sin(aa * fuz) * fuz))  * Math.tan(a * fuz);


                if (f < 0.5)
                {
                    p.rr = 5;
                    p.gg = 3;
                    p.bb = 1;
                } 
                else
                {
                    p.rr = 1;
                    p.gg = 3;
                    p.bb = 5;
                }

                p = p.next = new Particle3D();
              //p = p.next = new Particle();
            }

            bmd = new BitmapData(512, 512, false, 0x0);
            ofscr = bmd.clone();
            buf = new Vector.<uint>(512 * 512, true);

            var bm : Bitmap = new Bitmap(bmd);
            bm.x = bm.y = (465 - 512) / 2;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            blur = new BlurFilter(6, 8, BitmapFilterQuality.HIGH);
            dstp = new Point();

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            fcnt++;

            var t : Number = (fcnt & 131071) / 131072;

            var rx : Number = Math.cos(t);
            var ry : Number = Math.sin(t);

            ofscr.applyFilter(bmd, bmd.rect, dstp, blur);

            var buf : Vector.<uint> = ofscr.getVector(ofscr.rect);
            
            var p:Particle3D  =  p__;
            //var p : Particle = p__;
            
            while (p != null)
            {
                var dx : int = p.dx - 256;
                var dy : int = p.dy - 256;

                p.dx = 256 + (rx * dx) - (ry * dy);
                p.dy = 256 + (rx * dy) + (ry * dx);

                p.x += (p.dx - p.x) >> 4;
                p.y += (p.dy - p.y) >> 7;

                var pos : uint = ((p.y & 511) << 9) + (p.x & 511);

                var c : uint = buf[pos];
                var r : uint = (c >> 16 & 0xFF) + p.rr;
                var g : uint = (c >> 8 & 0xFF) + p.gg;
                var b : uint = (c & 0xFF) + p.bb;

                if (r > 0xFF) r = 0xFF;
                if (g > 0xFF) g = 0xFF;
                if (b > 0xFF) b = 0xFF;

                buf[pos] = r << 16 | g << 8 | b;

                p = p.next;
            }

            bmd.setVector(bmd.rect, buf);
        }
    }
}



internal class Particle 
{
    public var next : Particle;
    public var rr   : uint;
    public var gg   : uint;
    public var bb   : uint;
    public var x    : int;
    public var y    : int;
    public var dx   : int;
    public var dy   : int;
}

internal class Particle3D
{
    public var next : Particle3D;
    public var rr   : uint;
    public var gg   : uint;
    public var bb   : uint;
    public var x    : int;
    public var y    : int;
    public var z    : int;
    public var dx   : int;
    public var dy   : int;
    public var dz   : int;
}


//    [SWF(width = '465', height = '465')]