/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cvZo
 */

// 2010年4月17日
// マウスポインタの周辺だけ記憶の彩りがよみがえります
// 「ベルリン 天使の詩」にこんなのあったような...

package {

	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.net.*;
	import flash.system.*;
	import flash.text.*;

	public class Main extends Sprite {

		private const IMAGE_URL:String = "http://www.tenasaku.com/images/tsutsuji.jpg";

		private var monochrome:BitmapData;
		private var colorful:BitmapData;
		private var backContainer:Sprite;
		private var frontContainer:Sprite;
		private var sight:Shape;

		// 読み込まれたカラー画像からモノクロ画像を生成
		private function generateMonochromeImage():void {
			var X:int,Y:int;
			for ( Y = 0 ; Y < 465 ; ++Y )
			for ( X = 0 ; X < 465 ; ++X ) {
				var sourcePixel:uint = colorful.getPixel(X,Y);
				var r:Number = ((sourcePixel>>16)&255)/255;
				var g:Number = ((sourcePixel>>8)&255)/255;
				var b:Number = (sourcePixel&255)/255;
				var cc:uint = 0xff000000|(0x010101*Math.floor(255.9999*(r+g+b)/3));
				monochrome.setPixel32(X,Y,cc);
			}
		}

		// リモート画像を読み込む
		private function loadSourceImage():void {
			var message:TextField = new TextField();
			var messageFmt:TextFormat = new TextFormat();
			messageFmt.font = "Courier";
			messageFmt.size = 24;
			messageFmt.align = TextFormatAlign.CENTER;
			message.defaultTextFormat = messageFmt;
			message.autoSize = TextFieldAutoSize.CENTER;
			message.textColor = 0xffffff;
			message.background = false;
			message.text = "Sandbox type: "+Security.sandboxType+"\nLOADING IMAGE...";
			message.x = (stage.stageWidth-message.width)/2;
			message.y = (stage.stageHeight - message.height)/2;
			this.addChild(message);
			var context:LoaderContext = new LoaderContext();
			context.checkPolicyFile = true;
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(
				Event.COMPLETE, 
				function (e:Event):void {
					colorful.draw(loader);
					loader.unload();
					message.text = "";
					generateMonochromeImage();
				}
			);
			loader.load(new URLRequest(IMAGE_URL), context);
		}

		private function atEveryFrame(e:Event):void {
			sight.x = this.mouseX;
			sight.y = this.mouseY;
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			monochrome = new BitmapData(465,465,true,0);
			colorful = new BitmapData(465,465,false,0);
			sight = new Shape();
			sight.blendMode = BlendMode.ERASE;
			sight.alpha = 1.0;
			sight.filters = [new BlurFilter(32,16)];
			sight.graphics.clear();
			sight.graphics.beginFill(0xffffff);
			sight.graphics.drawEllipse(-100,-60,200,120);
			sight.graphics.endFill();
			backContainer = new Sprite();
			frontContainer = new Sprite();
			frontContainer.blendMode = BlendMode.LAYER;
			backContainer.addChild(new Bitmap(colorful));
			frontContainer.addChild(new Bitmap(monochrome));
			frontContainer.addChild(sight);
			this.addChild(backContainer);
			this.addChild(frontContainer);
			loadSourceImage();
			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
		}
		// The Main constructor simply calles initialize() function.

		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

