/**
 * Copyright roll.sagawa ( http://wonderfl.net/user/roll.sagawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cuOt
 */

// forked from roll.sagawa's forked from: forked from: 【Away3d-Lite】 CubeDivision
// forked from hacker_rpok935w's forked from: 【Away3d-Lite】 CubeDivision
// forked from dubfrog's 【Away3d-Lite】 CubeDivision
package {
    
    import away3dlite.cameras.Camera3D;
    import away3dlite.containers.ObjectContainer3D;
    import away3dlite.containers.Scene3D;
    import away3dlite.containers.View3D;
    import away3dlite.core.base.Object3D;
    import away3dlite.materials.BitmapMaterial;
    import away3dlite.materials.WireColorMaterial;
    import away3dlite.materials.WireframeMaterial;
    import away3dlite.primitives.Cube6;
    import away3dlite.events.MouseEvent3D;
    import away3dlite.core.utils.Cast;
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.*;
    
    /* @author dubfrog /* 
    
    /* project [Away3d-Lite Demo "CUBE DIVISION"] */
    
    /*Away3d-LiteでCube6分裂遊びです。
    各個体をクリックで個体サイズを保ちながら8分割されていきます。
    最終的に個体サイズが1/8*または1/16になったら消滅します
    
    "http://www10.plala.or.jp/c-s-roll/demo/works-F/motu4.gif"/
    
    [SWF(backgroundColor='0', width='465', height='465')]
    
    public class Main extends MovieClip
    {
        private var scene:Scene3D;
        private var view:View3D;
        private var camera:Camera3D;
        private var rootNode:ObjectContainer3D;
        private var URL:String;
        private var bmp:BitmapData;
        private var stw:Number;
        private var sth:Number;
        private var info:LoaderInfo;
        private var container:Sprite;
        private var nowNum:Number;
        private var division:Number;
        private var size:Number;
        private var cpz:Number;
        private var list:Vector.<Cube6>;
        private var t:TextField;
        
        public function Main():void
        {
            //stage
            stage.frameRate = 30;
            stage.quality = StageQuality.LOW;
            var bgbmp:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            var bgObj:Bitmap = new Bitmap(bgbmp);
            addChild(bgObj);
            
            //container
            container = new Sprite();
            container.x = stage.stageWidth / 2;
            container.y = stage.stageHeight / 2;
            addChild(container);
            //text
            var tf:TextFormat = new TextFormat();
            tf.color = 0xffffff;
            t = new TextField();
            t.defaultTextFormat = tf;
            t.y = stage.stageHeight - 20;
            t.selectable = false;
            addChild(t);
            //detail
            list = new Vector.< Cube6 >();
            nowNum = 0;
            division = 7;
            size = 220;
            URL = "http://www.dubfrog.net/lavo/cubeDivision/image/logomark300sh.jpg";
            
            //start...
            loadImage();
            Wonderfl.capture_delay(15);
        }
        private function loadImage():void
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
            {
                e.target.removeEventListener(Event.COMPLETE, arguments.callee);
                var image:BitmapData = e.target.content.bitmapData;
                createMaterial(image);
                initialize();
            });
            loader.load(new URLRequest(URL), new LoaderContext(true));
        }
        private function createMaterial(_bmp:BitmapData):void
        {
            var m:Sprite = new Sprite();
            for (var i:Number = 0; i <= 5; i++)
            {
                var _bmp_clone:BitmapData = _bmp.clone();
                var _bm:Bitmap = new Bitmap(_bmp_clone);
                if (i % 2 == 0) _bm.y = _bm.height;
                else _bm.y = 0;
                if (i < 3) _bm.x = i * _bm.width;
                else _bm.x = i * _bm.width - (3 * _bm.width);
                _bm.alpha = .5;
                m.addChild(_bm);
            }
            bmp = new BitmapData(m.width, m.height, true, 0x808080);
            bmp.draw(m);
        }
        private function initialize():void
        {
            scene = new Scene3D();
            view  = new View3D();
            camera = new Camera3D();
            rootNode = new ObjectContainer3D();
            view.scene = scene;
            view.camera = camera;
            camera.z = -camera.zoom * camera.focus;
            cpz = camera.z;
            container.addChild(view);
            view.scene.addChild(rootNode);
            
            cellDivisionAct(null, false);//firstAction...
            
            addEventListener(Event.ENTER_FRAME, update);
            
        }
        private function cellDivisionAct(_target:Cube6, _bool:Boolean):void
        {
            var px:Vector.< Number >, py:Vector.< Number >, pz:Vector.< Number >;
            var _divistion:Number, _size:Number;
            const _div:Number = 4;
            //const _div:Number = 2;
            
            
            if (_target != null)
            {
                _divistion = division;
                _size = _target.width / 2;
                
                px = Vector.< Number >([_target.x + _target.width / _div,
                      _target.x + _target.width / _div,
                      _target.x - _target.width / _div,
                      _target.x - _target.width / _div,
                      _target.x + _target.width / _div,
                      _target.x + _target.width / _div,
                      _target.x - _target.width / _div,
                      _target.x - _target.width / _div]);
                py = Vector.< Number >([_target.y + _target.height / _div,
                      _target.y - _target.height / _div,
                      _target.y + _target.height / _div,
                      _target.y - _target.height / _div,
                      _target.y + _target.height / _div,
                      _target.y - _target.height / _div,
                      _target.y + _target.height / _div,
                      _target.y - _target.height / _div]);
                pz = Vector.< Number >([_target.z - _target.depth / _div,
                      _target.z - _target.depth / _div,
                      _target.z - _target.depth / _div,
                      _target.z - _target.depth / _div,
                      _target.z + _target.depth / _div,
                      _target.z + _target.depth / _div,
                      _target.z + _target.depth / _div,
                      _target.z + _target.depth / _div]);
                
            }else {
                
                _divistion = 0;
                _size = size;
                
                px = Vector.< Number >([0]);
                py = Vector.< Number >([0]);
                pz = Vector.< Number >([0]);
            }
            for (var i:Number = 0; i <= _divistion; i++)
            {
                //var _mat:WireColorMaterial = new WireColorMaterial(0x006699, 1, 0x000000, 1, 1);
                var _mat:BitmapMaterial = new BitmapMaterial(Cast.bitmap(bmp));
                var _cube:Cube6 = new Cube6(_mat, _size, _size, _size, 1, 1, 1, 1);
                var _scale:Number = 1;
                _cube.x = px[i] + (Math.random() * 20 - 10);
                _cube.y = py[i] + (Math.random() * 20 - 10);
                _cube.z = pz[i] + (Math.random() * 20 - 10);
                _bool ? _scale = 0 : _scale = 1;
                if (_target == null) _cube.scaleX = _cube.scaleY = _cube.scaleZ = 0;
                BetweenAS3.removeFromParent(_cube);
                var itween:ITween = BetweenAS3.tween(_cube, { x:px[i], 
                                                              y:py[i], 
                                                              z:pz[i], 
                                                              scaleX:_scale, 
                                                              scaleY:_scale, 
                                                              scaleZ:_scale }, 
                                                              null,
                                                              .5, 
                                                              Elastic.easeOut);
                
                itween.onComplete = function(_mc:Cube6):void
                {
                    if (_bool) rootNode.removeChild(_mc);
                    childChecker();
                };
                itween.onCompleteParams = [_cube];
                itween.play();
                
                rootNode.addChild(_cube);
                _cube.addEventListener(MouseEvent3D.MOUSE_DOWN, cubeDown);
            }
        }
        private function cubeDown(e:MouseEvent3D):void
        {
            var target:*= e.target;
            var bool:Boolean;
            var a:Vector.<Number> = Vector.<Number>([4, 8, 16]);
            var r:Number = Math.floor(Math.random() * 2);
            if (target.width == size / a[2]) bool = true;
            else {
                if (target.width == size / a[r] ) bool = true;
                else bool = false;
            }
            cellDivisionAct(target, bool);
            target.removeEventListener(MouseEvent3D.MOUSE_DOWN, cubeDown);
            rootNode.removeChild(target);//自分自身をリムーブ
        }
        private function childChecker():void
        {
            if (rootNode.numChildren == 0) 
            {
                //1秒後にリスタート
                var timer:Timer = new Timer(1000, 1);
                timer.addEventListener(TimerEvent.TIMER_COMPLETE, function():void
                {
                    cellDivisionAct(null, false);
                });
                timer.start();
            }
            t.text = "キューブの数 " + rootNode.numChildren;
        }
        private function update(e:Event):void
        {
            view.render();
            
            var xper:Number = (mouseX / stage.stageWidth - .5) * 2;
            var yper:Number = (mouseY / stage.stageHeight - .5) * 2;
            
            var SPD:Number = .2;
            if (rootNode.numChildren > 0)
            {
                rootNode.rotationY += (xper * 260 - rootNode.rotationY) * SPD;
                rootNode.rotationX += (yper * 60 - rootNode.rotationX) * SPD;
                camera.z += ((yper * 500 + cpz) - camera.z) * SPD;
            }
        }
    }
}
