/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cu0o
 */





package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    [SWF(backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        
        private var _canvas:BitmapData;
        private var _force:BitmapData;
        
        private var _op:Point = new Point;
        private var _disp:BitmapFilter;
        private var _blur:BitmapFilter;
        
        private var _container:Bitmap;
        
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            addChild(_container = new Bitmap());
            
            setup();
            
            addEventListener(Event.ENTER_FRAME,enterframeHandler);
            stage.addEventListener(Event.RESIZE,resizeHandler);
            resizeHandler(null);
        }
        
        private function resizeHandler(e:Event):void{
            setup();
        }
        
        private var _width:Number = 465;
        private var _height:Number = 465;
        
        private function setup():void{
            _width = stage.stageWidth;
            _height = stage.stageHeight;
            
            graphics.beginFill(0x00);
            graphics.drawRect(0,0,_width,_height);
            graphics.endFill();
            
            var map:BitmapData = new BitmapData(_width, _height);
            map.perlinNoise( _width/4, _height/4, 8, 1, true, true );
            //addChild(new Bitmap(map));
            
            _force = new BitmapData(128,128);
            _force.perlinNoise( _width/5, _height/5, 2, 1, true, true );
            
            _disp = new DisplacementMapFilter(
                map, new Point(),
                BitmapDataChannel.RED, BitmapDataChannel.GREEN,
                16, 12,
                DisplacementMapFilterMode.WRAP,
                0x00, 1);
            _blur = new BlurFilter(8,8,3);
            
            _canvas = new BitmapData(_width, _height, true, 0);
            _container.bitmapData = _canvas;
            
            _particles.length = 0;
            const LENGTH:int= _width * _height / 20;
            for( var i:int=0;i<LENGTH; ++i){
               _particles.push(
                   new Particle(
                       Math.random()*_width,
                       Math.random()*_height
                   )
               );
            }    
        }
        
        
        private var _seed:int = 1;
        private function changeForceMap():void{
            _mapOffsets[0].x += 2;
            _mapOffsets[0].y += 1;
            _mapOffsets[1].x += 2;
            _mapOffsets[1].y += 1;
            _mapOffsets[2].x += 2;
            _mapOffsets[2].y += 1;
            
            _force.perlinNoise( _width/5, _height/5, 2, _seed, true,true,7, false, _mapOffsets );
        }
        
        private function changeForceMapSeed():void{
            _seed = Math.random()*10>>0 +1;
        }
        private var _timer:int = 0;
        private var _speed:Number = 1;
        private var _friction:Number = 0.96;
        private var _ctf:ColorTransform = new ColorTransform(1.00, 1.00, 1.0, 0.98, 0,0,0,0);
        
        private var _mapOffsets:Array = [ new Point(), new Point(), new Point(), new Point() ];
        private function enterframeHandler(e:Event):void {
            
        this.rotationX = 80;
        this.scaleX = 6;
        this.scaleY = 4;
        this.x = ((this.width/2) - stage.stageWidth) - 1940;
       // this.y = +50;    
            
            if( _timer % 3 == 0 ) {
                changeForceMap();
            }
            else if( _timer % 23 ) {
                changeForceMapSeed();
            }
            else {
                _ctf.redOffset = ( _ctf.redOffset + 2 ) % 16;
                _ctf.blueOffset = ( _ctf.blueOffset + 2 ) % 32;
            }
            _timer++;
            
            _canvas.lock();
            
            _canvas.applyFilter(_canvas,_canvas.rect,_op,_disp);
            
            for each( var p:Particle in _particles){
                var f:uint = _force.getPixel(p.x>>2,p.y>>2);
                
                p.vx = p.vx * _friction + ((f&0xFF)/0xFF-0.5) * _speed;
                p.vy = p.vy * _friction + (((f>>8)&0xFF)/0xFF-0.5) * _speed;
                p.x += p.vx * 0.8 +p.rdmX;
                p.y += p.vy * 0.8 +p.rdmY;
                
                if( p.x > 465 ) p.x -= 465;
                else if( p.x < 0 ) p.x += 465;
                if( p.y > 465 ) p.y -= 465;
                else if( p.y < 0 ) p.y += 465;
                
                _canvas.setPixel32( p.x, p.y, 0xFFFFFFCC )
            }
            
            _canvas.applyFilter(_canvas,_canvas.rect,_op,_blur);
            _canvas.colorTransform(_canvas.rect,_ctf);
            
            
            _canvas.unlock();
        }
    }
}

class Particle{
    public var vx:Number;
    public var vy:Number;
    public var x:Number;
    public var y:Number;
    public var rdmX:Number = ( Math.random()-0.5 ) *0.2;
    public var rdmY:Number = ( Math.random()-0.5 ) *0.2;
    public function Particle(x:Number,y:Number,vx:Number=0,vy:Number=0){
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
    }
}
