/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ctyT
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.system.System;
    import flash.ui.Keyboard;
    public class FlashTest extends Sprite {
        private var _array:Array;

        public function FlashTest() {
            _array = new Array();

            this.addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        private function onClick(e:MouseEvent):void {
            create();
        }

        private function onKeyDown(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.SPACE) {
                for each (var rect:Rect in _array) {
                    this.removeChild(rect);
                }
                _array = new Array();
                System.gc();
            }
        }
		
		private function create():void {
			var rect:Rect = new Rect();
			rect.x = Math.random() * 465;
			rect.y = -50;
			this.addChild(rect);
            _array.push(rect);
		}

        private function update(e:Event):void {
            updateMove();
            updateCollide();
        }

        private function updateMove():void {
            for each (var rect:Rect in _array) {
                rect.move();
            }
        }

        private function updateCollide():void {
            for (var i:uint = 0; i < _array.length; ++i) {
                for (var j:uint = 0; j < i; ++j) {
                    if (i == j) continue;
                    _array[i].chkCollide(_array[j]);
                }
            }
        }
    }
}

import flash.display.Graphics;
import flash.display.Sprite;

class Rect extends Sprite {
	private var _width:Number;
	private var _height:Number;
	private var _isGround:Boolean;
    private var _speedY:Number;

    public function get isGround():Boolean { return _isGround; }
    public function get left():Number { return this.x - (_width * 0.5); }
    public function get right():Number { return this.x + (_width * 0.5); }
    public function get top():Number { return this.y - _height; }
    public function get bottom():Number { return this.y; }

	public function Rect() {
		_width = 20 + (Math.random() * 80);
		_height = 20 + (Math.random() * 80);
		_isGround = false;
        _speedY = 0.0;
		
		var g:Graphics = this.graphics;
		g.lineStyle(2, 0x4040ff);
		g.beginFill(0xc0c0ff);
		g.drawRect(-_width / 2, - _height, _width, _height);
		g.endFill();
	}

    public function move():void {
        if (_isGround) return;

        _speedY += 0.2;
        if (_speedY > 10.0) {
            _speedY = 10.0;
        }

        this.y += _speedY;
        if (this.y > 460) {
            this.y = 460;
            landing();
        }
    }

    public function chkCollide(rhs:Rect):void {
        if (!this.isGround) {
            if (isCollide(rhs)) {
                this.y = rhs.top;
                landing();
            }
        }
    }

    private function isCollide(rhs:Rect):Boolean {
        if (!rhs.isGround) return false;
        if (this.bottom >= rhs.bottom) return false;

        if ((this.left >= rhs.left && this.left <= rhs.right)
        || (this.right >= rhs.left && this.right <= rhs.right)
        || (rhs.left >= this.left && rhs.left <= this.right)
        || (rhs.right >= this.left && rhs.right <= this.right)
        ) {
            if (this.bottom <= rhs.bottom && this.bottom >= rhs.top) {
                return true;
            }
        }

        return false;
    }

    private function landing():void {
        _speedY = 0.0;
        _isGround = true;
    }
}