/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ctK8
 */

// forked from fukt's forked from: MOIRE WALL
// forked from sakusan393's MOIRE WALL
package  {
    
    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import net.hires.debug.*;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.*;
    
    /**
     * 1.フルスクリーンに
     * 2.じっとモニターから近い距離でじっと見続けます
     * 3.気持ち悪くなって頭が痛くなります。
     */
    public class Moire extends Sprite {
        
        private var _w:int = 465;
        private var _h:int = 465;
        private var _wall0:Sprite,_wall1:Sprite;
        private var _bmd0:BitmapData, _bmd1:BitmapData
        private var _count:Number = Number.MIN_VALUE;
        private var _offsetZ:Number = -1;
        private var _dotSize:int = 4;
        private var _dotContainer0:MovieClip,_dotContainer1:MovieClip;
        private var _ct0:ColorTransform, _ct1:ColorTransform;
        private var _wallColorTime:int = 0.01;
        private var _wallColorTweenDelay:int = 1000;
        private var _wallColorArray00:Array;
        private var _wallColorArray10:Array;
        private var _button:PushButton;
        
        protected var _wallColor0:Object         = { R:0x9C, G:0x89, B:0x6B };
        protected var _wallColor1:Object         = { R:0xBB, G:0xD6, B:0xCF };
        
        protected var _wallColorRed0:Object         = { R:0x9C, G:0x89, B:0x6B };
        protected var _wallColorYellow0:Object     = { R:0x9C, G:0x6B, B:0x6B };
        protected var _wallColorGreen0:Object     = { R:0x89, G:0x6B, B:0x9C };
        protected var _wallColorMosGreen0:Object = { R:0x89, G:0x9C, B:0x9C };
        protected var _wallColorBlue0:Object      = { R:0x6B, G:0x9C, B:0x89 };
        protected var _wallColorPurple0:Object      = { R:0x6B, G:0x89, B:0x89 };
        protected var _wallColorArray0:Array;
        
        protected var _wallColorRed1:Object         = { R:0xBB, G:0xD6, B:0xCF };
        protected var _wallColorYellow1:Object     = { R:0xD6, G:0xD6, B:0xBB };
        protected var _wallColorGreen1:Object     = { R:0xD6, G:0xCF, B:0xBB };
        protected var _wallColorMosGreen1:Object = { R:0xCF, G:0xCF, B:0xD6 };
        protected var _wallColorBlue1:Object      = { R:0xCF, G:0xBB, B:0xD6 };
        protected var _wallColorPurple1:Object      = { R:0xBB, G:0xBB, B:0xCF };
        protected var _wallColorArray1:Array;
                
        public function Moire():void {
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_BORDER;
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            
            var perspectiveProjection:PerspectiveProjection = this.transform.perspectiveProjection;  
            perspectiveProjection.projectionCenter = new Point(_w / 2, _h / 2);
            
            _wallColorArray0 = [_wallColorRed0, _wallColorYellow0,_wallColorGreen0,_wallColorMosGreen0, _wallColorBlue0,_wallColorPurple0];
            _wallColorArray1 = [_wallColorRed1, _wallColorYellow1,_wallColorGreen1,_wallColorMosGreen1,_wallColorBlue1,_wallColorPurple1];
            
            _bmd0 = createBmd(_dotSize, _dotSize, 0xff000000);
            _bmd1 = _bmd0.clone();

            _wall0 = createWall(_w, _h , _bmd0,-_w /2,-_h /2);
            _wall1 = createWall(_w, _h , _bmd1, -_w  / 2, -_h / 2);
            
            _wall0.transform.colorTransform = new ColorTransform(1, 1, 1, 1, 0x00, 0x00, 0x00);
            _wall1.transform.colorTransform = new ColorTransform(1, 1, 1, 1, 0x00, 0x00, 0x00);
            
            addChild(_wall0).y = _h / 2;    
            addChild(_wall1).y = _h / 2;
            
            wallColorNext();
            
       //     stage.addChild(new Stats);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            _button = new PushButton(stage, 0, 0, "FULL SCREEN", onMouseClick);
            _button.x = _w / 2 - 50;
            _button.y = 20;
            
            wallColorNext();
            
            stage.addEventListener(FullScreenEvent.FULL_SCREEN, fullScreenChangeHandler);
            
            BetweenAS3.delay(BetweenAS3.tween(this, { alpha:1 }, { alpha:0 }, 3, Linear.linear), 0.1).play();
        }
        
        private function fullScreenChangeHandler(e:FullScreenEvent):void 
        {
            if (e.fullScreen) _button.visible = false;
            else _button.visible = true;
        }
        
        private function onMouseClick(e:MouseEvent):void 
        {
            stage.displayState = "fullScreen";
        }
        
        protected function wallColorNext(index:int = 0):void {
            var obj0:Object = _wallColorArray0[index];
            var obj1:Object = _wallColorArray1[index];
            var iTween0:ITween = BetweenAS3.delay(BetweenAS3.to(_wall0, { transform:{colorTransform: { redOffset:obj0.R,greenOffset:obj0.G,blueOffset:obj0.B }} }, _wallColorTime, Linear.linear),_wallColorTweenDelay);
            var iTween1:ITween = BetweenAS3.delay(BetweenAS3.to(_wall1, { transform:{colorTransform: { redOffset:obj1.R,greenOffset:obj1.G,blueOffset:obj1.B }} }, _wallColorTime, Linear.linear),_wallColorTweenDelay);
            iTween0.onComplete = function():void {
                index++;
                if (index >= _wallColorArray1.length) index = 0;
                wallColorNext(index);
                _wall0.transform.colorTransform
            };
            iTween0.play();
            iTween1.play();
        }
        
        private function enterFrameHandler(e:Event):void {
            _count += 0.05;
            
            _wall0.x = Math.sin(_count/3) * 50 + _w / 2;
            _wall1.x = Math.sin(_count / 3) * 15 + _w / 2;
            _wall0.z = (1 - Math.sin(_count / 12)) * 20 -160;
            _wall1.z = (1 - Math.sin(_count/12)) * 5 +_offsetZ -160;
            _wall0.rotationY = Math.sin(_count / 1.5) * 1.5;
            _wall1.rotationY = Math.sin(_count / 2) * 1;
            _wall0.rotationZ = (1 - Math.cos(_count / 3)) * 1;
            _wall1.rotationZ = (1 - Math.cos(_count / 9)) * 2000;
        }
        
        private function createWall(w:int, h:int, bmd:BitmapData, x:int = 0, y:int = 0 ):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.clear();
            sp.graphics.beginBitmapFill(bmd);
            sp.graphics.drawRect(x, y, w, h);
            sp.graphics.endFill();
            return sp;
        }
        private function createBmd(w:int, h:int, color:int):BitmapData {
            var bmd:BitmapData = new BitmapData(w, h, true, 0x00000000);
            for (var i:int = 0; i < w; i++){
                for (var ii:int = 0; ii < w; ii++){
                    if ((i < int(w/2) && ii > int(w/2-1)) || (i > int(w/2-1) && ii < int(w/2))){
                        bmd.setPixel32(ii, i, color);
                    }
                }
            }
            return bmd;
        }
    }
}