/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ct79
 */

// forked from kanatara's flash on 2010-8-13
package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.filters.*;
    
    public class FlashTest extends Sprite {
        private var base:Sprite;
        private var rrect:Shape;
        
        public function FlashTest() {
            makeShape(350,350,11);
            makeShape(300,300,15);
            makeShape(250,250,19);           
            makeShape(200,200,21);
            makeShape(150,150,25);
            makeShape(100,100,50);
            makeShape(50,50,100);
        }
        
        private function makeShape(x:uint,y:uint,t:uint){
            base = new Sprite();
            base.x = x;
            base.y = y;
            addChild(base);

            // baseに対して、四角をadd
            rrect = makeRoundRect(80, 80, 5, 0xffCC00);
            rrect.x = -40;
            rrect.y = -40;
            base.addChild(rrect);

            //タイマーの追加
            var timer:Timer=new Timer(t,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();     
        }

        private function onTick(evt:TimerEvent):void {    
            // filter使ったほうがかっこいいよね！
            var filters:Array = new Array;
            filters.push(makeDropShadowFilter());
            filters.push(makeBevelFilter());    
            rrect.filters = filters;
            
            base.rotation += 1;  
        }
        
        //角丸矩形の生成
        private function makeRoundRect(w:uint,h:uint,ew:uint,color:uint):Shape {
            var rrect:Shape=new Shape();
            rrect.graphics.lineStyle(10,0x000000);    //線幅・線色
            rrect.graphics.beginFill(color);         //塗り潰し色
            rrect.graphics.drawRoundRect(0,0,w,h,ew);//XY座標,幅,高さ,角丸幅
            rrect.graphics.endFill();                //塗り潰し終了
            return rrect;
        }

        //ベベルフィルタの生成
        private function makeBevelFilter():BitmapFilter {
            var filter:BevelFilter=new BevelFilter();
            filter.angle         =45;      //角度
            filter.blurX         =3;       //水平方向のぼかし量
            filter.blurY         =3;       //垂直方向のぼかし量
            filter.distance      =10;      //オフセットの距離
            filter.highlightAlpha=0.5;     //ハイライトカラーの透明度
            filter.highlightColor=0xddddff;//ハイライトカラー
            filter.knockout      =false;   //ノックアウト効果有無
            filter.quality       =BitmapFilterQuality.HIGH;//クォリティ
            filter.shadowAlpha   =0.8;     //シャドウカラーの透明度
            filter.shadowColor   =0x000000;//シャドウカラー
            filter.strength      =0.5;     //インプリントやスプレッドの長さ
            filter.type          =BitmapFilterType.INNER;//ベベルの種類
            return filter;
        }

        //ドロップシャドウフィルタの生成
        private function makeDropShadowFilter():BitmapFilter {
            var filter:DropShadowFilter=new DropShadowFilter();
            filter.alpha     =1.0;     //シャドウカラーの透明度
            filter.angle     =45;      //シャドウの角度
            filter.blurX     =5;       //水平方向のぼかし量
            filter.blurY     =5;       //垂直方向のぼかし量
            filter.color     =0x000000;//シャドウのカラー
            filter.distance  =5;       //シャドウのオフセット距離
            filter.hideObject=false;   //シャドウのみの表示
            filter.inner     =false;   //内部シャドウか
            filter.knockout  =false;   //ノックアウト効果の有無
            filter.quality   =BitmapFilterQuality.HIGH;//クォリティ
            filter.strength  =1;       //インプリントやスプレッドの長さ
            return filter;
        }
    }
}
