/**
 * Copyright naoki ( http://wonderfl.net/user/naoki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/csyy
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import caurina.transitions.Tweener;
    import flash.display.LineScaleMode;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    public class Rain extends Sprite {

        //ステージサイズ
        private var SWF_WIDTH:uint = 500;
        private var SWF_HEIGHT:uint = 500;

        //タイマーを定義する
        private var delay:uint = 500;    // 雫の間隔
        private var repeat:uint = 100;   // 雫の数
        private var myTimer:Timer = new Timer(delay, repeat);
      
        [SWF(height=500, width=500, backgroundColor="#FFFFFF", frameRate=10)]

        //
        // コンストラクタ
        //
        public function Rain() {
            
            // タイマーを使って雨の雫をつくる
            myTimer.start();
            myTimer.addEventListener(TimerEvent.TIMER, makeOneDrop);
        }
        //
        // 雨の雫をひとつ作る
        //
        private function makeOneDrop(e:TimerEvent):void
        {
            //ランダムな場所に描く
            var x:int    = Math.random() * SWF_WIDTH;
            var y:int    = Math.random() * SWF_HEIGHT;

            // 雨の雫をひとつ描く
            this.drawOneDrop(x,y);
        }
        //
        // 雨の雫をひとつ描く
        //
        private function drawOneDrop(x:uint,y:uint):void
        {
            var drop:Shape = new Shape();
            
            drop.graphics.lineStyle(3, 0x3333ff, 0.25, false, LineScaleMode.NONE);
            drop.graphics.endFill();
            drop.graphics.drawCircle(0,0,5);
            this.addChild(drop);
            drop.x = x;
            drop.y = y;

            Tweener.addTween(drop,{scaleX:30,scaleY:30,alpha:0,time:10});
        }
    }
 
}
