/**
 * Copyright hashito ( http://wonderfl.net/user/hashito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/csZ9
 */

// forked from hashito's 文字集まる修正
// MainStage
package {
    import flash.display.Sprite;
    [SWF(frameRate=60,width=456,height=456)]
    public class MainStage extends Sprite {
        public function MainStage(){
            addChild(new Main());
        }
    }
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.utils.Timer;
import flash.text.TextField;
import flash.text.TextFormat;
import net.hires.debug.Stats;

//class debug{public static var out:TextField=new TextField();}
//
/*
    t.hashito
    日本語未対応
*/
class MF{
    public static function AFFORD (x:Number,aim:Number,a:Number):Boolean{return (x<=(a+aim))&&(x>=(a-aim));}
    public static function RAN (n:Number=1):Number{return (Math.random()*n);}
    public static function ISPM (n:Number):Number{if(n<0){return -1;}else if(n>0){return 1;}return 0;}
    public static function MAX (n:Number,max:Number):Number{return (n>max)?max:n;}
    public static function MIN (n:Number,min:Number):Number{return (n<min)?min:n;}
    public static function LIMIT (n:Number,max:Number,min:Number):Number{if(n>max){return max;}else if(n<min){return min;}else{return n};}
    public static function RAD_ANG(n:Number):Number{return n*180/Math.PI}
    public static function ANG_RAD(n:Number):Number{return n*Math.PI/180 }
}


class Main extends Sprite{
    public const H:Number = 456;
    public const W:Number = 456;
    private var t:Tx=new Tx(W,H);
    private var timer:Timer=new Timer(5000);
    private var note:TextField=new TextField(),automode:Boolean=false;
    //Constructor
    public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
    //init
    public function init(e:*):void{
        addChild(t);
        note.autoSize=flash.text.TextFieldAutoSize.LEFT;
        addChild(note);
        //modechg();
        timer.addEventListener(flash.events.TimerEvent.TIMER ,nowShow)
        // debug
        ///debug.out.autoSize=flash.text.TextFieldAutoSize.LEFT;
        ///addChild(debug.out);
        ///debug.out.text="0";
        addEventListener(Event.ENTER_FRAME ,update);
        //timer.addEventListener(flash.events.TimerEvent.TIMER,randomChar);
        //stage.addEventListener(MouseEvent.MOUSE_DOWN ,modechg);
        timer.start();
        var s:Stats = new Stats();
        addChild(s);
    }
        public function update(e:Event=null):void{
        t.update();
        //debug.out.text="x="+t.bits[0].x+" y="+t.bits[0].y+" vx="+t.bits[0].vx+" vy="+t.bits[0].vy+" ax="+t.bits[0].ax+" ay="+t.bits[0].ay;
    }
    //
    
    public const H_NOWSHOW_MAX:Number = 7;
    public const H_NOWSHOW:Number = H/H_NOWSHOW_MAX;
    public const W_NOWSHOW:Number = 25;
    public var nowShow_count:Number = 0;
    public function nowShow(e:*){
        var d:Date   = new Date();
        var s:String = d.hours+"時"+d.minutes+"分"+d.seconds+"秒";
        for(var i:int=0;i<s.length;i++){
            t.setChar(s.charAt(i),W_NOWSHOW*i,nowShow_count*H_NOWSHOW);
        }
        nowShow_count++;
        nowShow_count=(nowShow_count>=H_NOWSHOW_MAX)?0:nowShow_count
    }
    
    // mode chg
    // public function modechg(e:MouseEvent=null):void{
    //     if(automode = !automode){
    //         note.text="auto";
    //         timer.start();
    //         stage.removeEventListener(flash.events.KeyboardEvent.KEY_DOWN  ,keydown);
    //     }else{
    //         note.text="manual";
    //         timer.stop();
    //         stage.addEventListener(flash.events.KeyboardEvent.KEY_DOWN  ,keydown);
    //     }
    // }
    // random char
    //public function randomChar(e:TimerEvent=null):void{
    //    t.setChar( String.fromCharCode(Math.floor(MF.RAN(93)+21)),MF.RAN(W),MF.RAN(H))
    //}
    // key down
    public function keydown(e:KeyboardEvent=null):void{
        t.setChar( String.fromCharCode(e.keyCode),MF.RAN(W),MF.RAN(H))
    }
}

// text class
class Tx extends Sprite{
    //+++++++++++++++++++++++++++++++++++++++++++
    // 共有
    //+++++++++++++++++++++++++++++++++++++++++++
    public var W:int;     //画面の幅
    public var H:int;     //画面の高さ
    public const K:int=2; //bitとbitの離れ係数
    // コンストラクタ
    public function Tx(W:int,H:int){
        this.W=W;this.H=H;
        bits_init();
        t_init();
    }
    // 更新
    public function update(t:Number=1):void{
        var i:int,l:int,ret:Boolean=false;
        var v:Vector.<Bit>;
        for(i=0 ; bits.length>i ; i++){
            bits[i].update(t);
        }
        //チームの処理
        for(i=0 ; bitsT.length>i ; i++){
            v=bitsT[i];
            ret=true;
            for(l = 0 ; v.length>l ; l++){
                if(!v[l].isAim()){
                    ret=false;
                    break;
                }
            }
            if(ret){
                while(v.length>0){
                    v[0].endAim();
                    v.splice(0,1);
                }
                bitsT.splice(bitsT.indexOf(v),1);
            }
        }
    }
    // 今、文字を形作ろうとしているbitの配列の配列
    public var bitsT:Vector.<Vector.<Bit>> =new Vector.<Vector.<Bit>>();
    //+++++++++++++++++++++++++++++++++++++++++++
    // 文字作成関連
    //+++++++++++++++++++++++++++++++++++++++++++
    
    // 文字のビットマップを作るbitmapdataの大きさ
    private const B_X:int=40 , B_Y:int=20;
    // 文字のビットマップwk
    private var b:BitmapData =new BitmapData(B_X,B_Y,true,T_BC);
    // ビットマップの元
    private var t:TextField=new TextField();
    // ビットマップの元となるテキストデータの設定値
    private const T_FC:uint=0xffffff,T_BC:uint=0;
    
    // 文字データ作成系の初期化
    private function t_init():void{
        var tf:TextFormat=new TextFormat();
        t.autoSize   = flash.text.TextFieldAutoSize.LEFT;
        t.background = true;
        t.backgroundColor = T_BC;
        t.textColor=T_FC;
        tf.size  = B_Y-1;
        tf.letterSpacing  = 1;
        t.setTextFormat(tf);
    }
    // 文字データ設定(表示したい文字,位置x,位置y)
    public function setChar(c:String,x:int,y:int):void{
        var v:Vector.<Bit> = new Vector.<Bit>();//この文字を表示するbitを入れておく配列
        var bit:Bit;
        t.text = c.charAt(0);    //念のため1文字目を取得
        b.fillRect(b.rect,T_BC); //前の文字を削除
        b.draw(t);               //文字をビットマップ上に描画
        //ビットマップの読み取り
        var w:int=b.width,h:int=b.height;//,ran:int=0;
        for(var ix:int=0;ix<w;ix++){
            for(var iy:int=0;iy<h;iy++){
                if(b.getPixel(ix,iy)==T_FC){
                    bit=getBit();               //空いているbitobject取得
                    bit.setAim(x+ix*K,y+iy*K);  //目的地設定
                    //ran = (ran<bit.MaxRan())? bit.MaxRan():ran;//距離が長い場合更新
                    v.push(bit);                //追加
                }
            }
        }
        bitsT.push(v);
        //return ran;
    }
    //+++++++++++++++++++++++++++++++++++++++++++
    // bitオブジェクト管理系
    //+++++++++++++++++++++++++++++++++++++++++++
    
    // bit全てが属するbitプール
    public var bits:Vector.<Bit> =new Vector.<Bit>(1000,true);
    // bitプールのオブジェクトを順に参照させるためのカウンタ
    private var bitcount:int;
    // 初期化
    private function bits_init():void{
        for(var i:int=0 ; bits.length>i ; i++){
            // bit object 作成
            bits[i] = new Bit(K,MF.RAN(W),MF.RAN(H),MF.RAN(0xffffff));
            addChild(bits[i]);
        }
    }
    // 0→maxまで順にオブジェクトを取得してくれる関数
    public function getBit():Bit{
        var ret:Bit=bits[bitcount];
        if(++bitcount >= bits.length)bitcount=0;
        return ret;
    }

}
class Bit extends Shape{
    public var ix:int,iy:int,k:int,color:uint;
    public var aimx:int,aimy:int;
    public var ax:Number=0,ay:Number=0,vx:Number=0,vy:Number=0;
    
    public function Bit(k:int,x:int,y:int,color:uint){
        this.x = aimx = ix = (x);
        this.y = aimy = iy = (y);
        this.k=k;this.color=color
        this.graphics.beginFill(color);
        this.graphics.drawCircle(0,0,k)
    }
    public function setAim(x:int,y:int):void{
        aimx=x;aimy=y;
        this.graphics.beginFill(0x0);
        this.graphics.drawCircle(0,0,k);
        aim=false;
    }
    public function endAim():void{
        aimx=ix;aimy=iy;
        this.graphics.beginFill(color);
        this.graphics.drawCircle(0,0,k);
    }
    public function isAim():Boolean{
        return aim;
    }
    // public function MaxRan():int{
    //     var dx:int,dy:int ;
    //     dx = Math.abs(x-aimx);
    //     dy = Math.abs(y-aimy);
    //     return (dx>dy)?dx:dy;
    // }
    private var aim:Boolean=true;
    public function update(t:Number=1):void{
        if((x==aimx) && (y==aimy)){
            aim=true;
        }else{
            x+=MF.ISPM(aimx - x);
            y+=MF.ISPM(aimy - y);
        }
    }
    
}
