/**
 * Copyright Nao_u ( http://wonderfl.net/user/Nao_u )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cs7L
 */

// forked from Nao_u's マウスで描いた線が動く
//
//  画面の左から右に向かって線を引くと攻撃
//  敵のＨＰを0以下にすると勝利
//    
//    描いた線を画面右端に当てると、敵のＨＰを削れる
//    描いた線が画面左端に当たると、自分がダメージを受ける
//
//
//    動いてる線はすでに描かれた線にぶつかると消滅する
//    敵は数秒前の自分と同じ動きで攻撃してくる
//    ２ラウンド目以降は、さらに前の自分も攻撃に参加してくる         
//
//
package {  
    import flash.display.Sprite;  
    import flash.events.*;  
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]   
     
    public class FlashTest extends Sprite {  
        public function FlashTest() {  
            Main = this;  
            initialize();     
            stage.addEventListener(Event.ENTER_FRAME,update);   
            stage.addEventListener(MouseEvent.MOUSE_UP,    MouseCheckUp);    
            stage.addEventListener(MouseEvent.MOUSE_DOWN,  MouseCheckDown);    
         }  
    }  
}          

import flash.display.Sprite;   
import flash.events.Event; 
import flash.events.MouseEvent;    
import flash.geom.*;
import flash.text.TextField;  
import flash.text.TextFormat;  
import flash.text.TextFormatAlign;  
import flash.display.*;
import flash.geom.Matrix; 

var Text:TextField   
var ResultText:TextField   
var ResultText2:TextField   

var Main:Sprite;  
var SCREEN_W:Number = 465; 
var SCREEN_H:Number = 465; 

var g_LineLst:Array;
var g_Player:Player;
var g_Enemy:Player;
var g_EnemyAry:Array;
var g_Trace:Trace;
var g_Cnt:int;
var g_StageNo:int = 0;
var g_State:int = 0;
var g_StateTimer:int = 0;

var g_PlayerHp:Number;
var g_EnemyHp:Number;

var g_PlayerDamageCnt:Number;
var g_EnemyDamageCnt:Number;


function initialize():void{ 

    var fm:TextFormat = new TextFormat;  
    fm.font = "_typewriter"; fm.bold = true;  
    fm.size = 48; fm.color = 0x000000;  
    ResultText = new TextField();    
    ResultText.defaultTextFormat = fm;  
    ResultText.text = "";  
    ResultText.autoSize = "left";  
    ResultText.x = 48; 
    ResultText.y = 128; 
    ResultText.width = 128;  
    Main.addChild(ResultText);     

    fm.font = "_typewriter"; fm.bold = true;  
    fm.size = 16; fm.color = 0x000000;  
    ResultText2 = new TextField();    
    ResultText2.defaultTextFormat = fm;  
    ResultText2.text = "";  
    ResultText2.autoSize = "left";  
    ResultText2.x = 144; 
    ResultText2.y = 384; 
    ResultText2.width = 128;  
    Main.addChild(ResultText2);     

    fm.font = "_typewriter"; fm.bold = true;  
    fm.size = 12; fm.color = 0x000000;  
    Text = new TextField();    
    Text.defaultTextFormat = fm;  
    Text.text = "";  
    Text.autoSize = "left";  
    Text.x = 226; 
    Text.y = 0; 
    Main.addChild(Text);     

//    stageStart(); 
}  

function gameInit():void{ 
    g_EnemyAry = new Array;
    g_StageNo = 0;
}

function stageStart():void{ 
    g_LineLst = new Array;
    g_Player = new Player;
    g_Enemy = new Player;
    g_EnemyAry.push( g_Enemy );
    g_Trace = new Trace;

    g_Cnt = 0;
    g_State = 0;

    g_PlayerHp = 100;
    g_EnemyHp = 100;

    g_StageNo++;

    g_PlayerDamageCnt = 0.0;
    g_EnemyDamageCnt = 0.0;

    Text.text = "";  
}

function update(e :Event):void{  
    Main.graphics.clear(); 

    var col:int;
    if( g_PlayerDamageCnt > 0 ){
        col = 255 - 255.0 * g_PlayerDamageCnt;
        g_PlayerDamageCnt *= 0.95;
        g_PlayerDamageCnt -= 0.01;

        drawGradientBox(-50, 0xff0000 + (col<<8) + col);    
    }
    if( g_EnemyDamageCnt > 0 ){
        col = 255 - 255.0 * g_EnemyDamageCnt;
        g_EnemyDamageCnt *= 0.95;
        g_EnemyDamageCnt -= 0.01;

        drawGradientBox(SCREEN_W-50, 0xff0000 + (col<<8) + col);

    }
        
    updateGame();
    draw();

    MouseUpdate(); 
}

    
function updateGame():void{  
    
    switch( g_State ){
        case 0:    updateTitle();        break;
        case 1:    updateStageStart();   break;
        case 2:    updateStage();        break;
        case 3:    updateResult();       break;
        case 4:    updateGameOver();     break;
    }
}

function updateTitle():void{
    ResultText2.text = "  Click Start";
    if( MouseData & MOUSE_LEFT_TRG ){
        ResultText2.text = "";
        gameInit();
        stageStart();
        g_State = 1;
    }
}

function updateStageStart():void{
    
    ResultText.text = "Round "+g_StageNo+" Start";
    g_StateTimer++; 
    if( g_StateTimer > 90 ){
        ResultText.text = "";
        g_State = 2;
        g_StateTimer = 0;
    }
}

function updateResult():void{
    ResultText.text = "   You Win";
    g_StateTimer++; 
    if( g_StateTimer > 160 ){
        g_StateTimer = 0;
        stageStart();
        g_State = 1;
    }
}

function updateGameOver():void{
    ResultText.text = "  Game Over";
    g_StateTimer++; 
    if( g_StateTimer > 120 ){
        g_StateTimer = 0;
        g_State = 0;
    }
}

function updateStage():void{  

//    Text.text = "PlayerHp:"+g_PlayerHp.toString()
//              + " EnemyHp:"+g_EnemyHp .toString();

    if( g_EnemyHp  <= 0 ) g_State = 3;
    if( g_PlayerHp <= 0 ) g_State = 4;


    g_Cnt++;
    var cd:ControlData = new ControlData( Main.stage.mouseX, Main.stage.mouseY, MouseData );
    g_Trace.add( cd );

    g_Player.update( cd );

    var enemyCnt:int = g_Cnt - 120;
    if( enemyCnt < 0 ) enemyCnt = 0;
    if( enemyCnt > 0 ){
        var ecd:ControlData = g_Trace.DataAry[enemyCnt ];
        var ecd2:ControlData = new ControlData( SCREEN_W-ecd.X, SCREEN_H-ecd.Y, ecd.Mouse );

        g_Enemy.update( ecd2 );
        
        Main.graphics.lineStyle(0,0x000000);        
        Main.graphics.beginFill(0xb00000,1);    
        Main.graphics.drawCircle(ecd2.X,ecd2.Y, 9);    
        Main.graphics.endFill();    
    }

    var minus:int = 240 - g_StageNo * 80;
    if( minus < 0 ) minus = 0;
    var div:Number = 3 - g_StageNo * 0.2;
    if( div < 1.0 ) div = 1.0;
    enemyCnt = (g_Cnt - minus)/div;
    for( var i:int=0; i<g_EnemyAry.length-1; i++ ){ 
        g_EnemyAry[i].updateTrace( enemyCnt );

        Main.graphics.lineStyle(0,0x000000);        
        Main.graphics.beginFill(0xb00000,2);    
        Main.graphics.drawCircle(g_EnemyAry[i].PosX,g_EnemyAry[i].PosY, 7);    
        Main.graphics.endFill();    
    }
    
    var lp:int;
    for( lp=0; lp<g_LineLst.length; lp++ ){
        if( g_LineLst[lp].PosAry.length == 0 ){ 
            g_LineLst.splice(lp,1); 
        }else{ 
            g_LineLst[lp].update(); 
        } 
    }
}

function drawHp():void{  
    Text.text = g_StageNo.toString();  

    Main.graphics.lineStyle(7,0x000000);     
    Main.graphics.moveTo( SCREEN_W/2+20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2+20+150, 10 );
    Main.graphics.endFill();    

    Main.graphics.lineStyle(6,0xff4040);     
    Main.graphics.moveTo( SCREEN_W/2+20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2+20+150, 10 );
    Main.graphics.endFill();    

    Main.graphics.lineStyle(6,0xffff40);     
    Main.graphics.moveTo( SCREEN_W/2+20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2+20+(g_EnemyHp*150/100), 10 );
    Main.graphics.endFill();    

    Main.graphics.lineStyle(7,0x000000);     
    Main.graphics.moveTo( SCREEN_W/2-20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2-20-150, 10 );
    Main.graphics.endFill();    

    Main.graphics.lineStyle(6,0xff4040);     
    Main.graphics.moveTo( SCREEN_W/2-20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2-20-150, 10 );
    Main.graphics.endFill();    

    Main.graphics.lineStyle(6,0xffff40);     
    Main.graphics.moveTo( SCREEN_W/2-20,     10 );     
    Main.graphics.lineTo( SCREEN_W/2-20-(g_PlayerHp*150/100), 10 );
    Main.graphics.endFill();    
}

function draw():void{  

    if( g_State != 0 ) drawHp();

    var lp:int;
    for( lp=0; lp<g_LineLst.length; lp++ ){
        g_LineLst[lp].draw();
    }

} 

function drawGradientBox( posX:Number, color:int):void{
    var type:String = GradientType.RADIAL; 
    var colors:Array = [color, 0xffffff]; 
    var alphas:Array = [1, 1]; 
    var ratios:Array = [0, 255]; 
    var spreadMethod:String = SpreadMethod.PAD; 
    var interp:String = InterpolationMethod.LINEAR_RGB; 
    var focalPtRatio:Number = 0; 

    var matrix:Matrix = new Matrix(); 
    var boxWidth:Number = 100; 
    var boxHeight:Number = SCREEN_H*2; 
    var boxRotation:Number = 0;//Math.PI/2; // 90° 
    var tx:Number = posX; 
    var ty:Number = -SCREEN_H/2; 
    matrix.createGradientBox(boxWidth, boxHeight, boxRotation, tx, ty); 
 
    Main.graphics.beginGradientFill(type,  
                            colors, 
                            alphas, 
                            ratios,  
                            matrix,  
                            spreadMethod,  
                            interp,  
                            focalPtRatio); 
    Main.graphics.drawRect(posX, 0, 100, SCREEN_H); 
}

class LineList{  
    public var PosAry:Array; 
    public var StartPnt:int;
    public var TopPnt:int;
    public var Mx:Number= 1.005;
    public var MoveStart:Boolean = false;
    public var IsHit:Boolean = false;
    public var IsAttack:Boolean = true;

    public function LineList( p:Point ){  
        PosAry = new Array;
        PosAry.push( p );
        PosAry.push( p );
        TopPnt = StartPnt = 0;
    }  

    public function addPoint( p:Point ):void{  
        Main.graphics.lineStyle(3,0xd0d000);
        var l:int = PosAry.length-1;
        var lx:int = PosAry[l-1].x-PosAry[l].x;
        var ly:int = PosAry[l-1].y-PosAry[l].y;
        var len:int = lx*lx + ly*ly;
        var maxLen:int = 1;
        if( len > maxLen*maxLen ){
            PosAry.push( p );
        }else{
            PosAry[l] = p;
        }
    }  

    public function update():void{  

        if( MoveStart == false ) return;
        if( PosAry.length == 0 ) return;
        if( IsHit == true){
            for( var l:int=0; l<2; l++ ){
                PosAry.splice(StartPnt,1); 
                if( StartPnt >= PosAry.length ) StartPnt = 0;
            }
            return;
        }
        if( g_Cnt&1 ) return;

        hitCheckOrherLine();

        var mi:int = StartPnt-1;
        var pl:int = StartPnt+1;
        if( mi < 0 ) mi = PosAry.length-1;
        if( pl > PosAry.length-1 ) pl = 0;
        var lx:int = PosAry[mi].x - PosAry[StartPnt].x;
        var ly:int = PosAry[mi].y - PosAry[StartPnt].y;
        PosAry[StartPnt].x = PosAry[pl].x + (lx * Mx);
        PosAry[StartPnt].y = PosAry[pl].y + (ly * Mx);

        StartPnt++;

        if( StartPnt > PosAry.length-1 ) {
            var del:int = PosAry.length/20 + 1;
            PosAry.splice(PosAry.length-del,del);
            StartPnt = 0;
        }
 
    }

    public function hitCheckOrherLine( ):void{
        var l:int = TopPnt;//PosAry.length-1;
        var px:Number = PosAry[l].x;
        var py:Number = PosAry[l].y;

        for( var lp:int=0; lp<g_LineLst.length; lp++ ){
            var othLine:LineList = g_LineLst[lp];
            if( othLine == this ) continue;
            for( var i:int=0; i<othLine.PosAry.length-2; i+=2 ){ 
                
                var dist2:Number = getLinePntDist2( 
                othLine.PosAry[i].x, othLine.PosAry[i].y, 
                othLine.PosAry[i+1].x, othLine.PosAry[i+1].y, 
                px, py );
                
                if( dist2 < 10 ){
                   IsHit = true; 
                   return;
                }
            } 
        }
    }

    public function getLinePntDist2( x0:Number, y0:Number, x1:Number, y1:Number, px:Number, py:Number ):Number{
        var vx:Number = x1 - x0; 
        var vy:Number = y1 - y0; 
        var len:Number = Math.sqrt(vx*vx+vy*vy);
        vx /= len;
        vy /= len;
        var pvx:Number = px - x0;
        var pvy:Number = py - y0;
        var dot:Number = vx*pvx + vy*pvy;
        if( dot < 0.0 ) dot = 0.0;
        if( dot > len ) dot = len;
        var cx:Number = x0 + vx * dot;
        var cy:Number = y0 + vy * dot;
        
        vx = cx - px;
        vy = cy - py;
        return Math.sqrt(vx*vx + vy*vy);
    }

    public function draw():void{  
        if( PosAry.length == 0 ) return;

        var s:int = StartPnt;

        var size:Number;

        var minX:int = 99999999;
        var minY:int = 99999999;
        var maxX:int = -99999999;
        var maxY:int = -99999999;
        for( var i:int=0; i<PosAry.length-1; i++ ){
            size = i / 8.0;
            if( size > 5.0 ) size = 5.0;
            if( size < 1.5 ) size = 1.5;
            var col:int = 0x40 * (PosAry.length-i) / PosAry.length + 0x60;
            var c:int = (col << 16) + (col << 8) + col;
            Main.graphics.lineStyle(size,c);     

            if( minX > PosAry[s].x ) minX = PosAry[s].x;
            if( minY > PosAry[s].y ) minY = PosAry[s].y;
            if( maxX < PosAry[s].x ) maxX = PosAry[s].x;
            if( maxY < PosAry[s].y ) maxY = PosAry[s].y;
            Main.graphics.moveTo( PosAry[s].x, PosAry[s].y );     
            s++;
            if( s > PosAry.length-1 ) s = 0;
            Main.graphics.lineTo( PosAry[s].x, PosAry[s].y );
            if( s > PosAry.length-1 ) s = 0;
        }
        
        size = PosAry.length/2;
        if( size > 5.5 ) size = 5.5;
        if( IsAttack ){
            Main.graphics.lineStyle(0,0xc0c0c0);        
            Main.graphics.beginFill(0x000000,1);    
            Main.graphics.drawCircle(PosAry[s].x,PosAry[s].y, size);    
            Main.graphics.endFill();    
        }
        TopPnt = s;

        if( IsAttack == true){
            if( PosAry[TopPnt].y > 0 && PosAry[TopPnt].y < SCREEN_H ){
                if( PosAry[TopPnt].x < 0 ){
                    IsAttack = false;
                    g_PlayerHp -= 10;
                    g_PlayerDamageCnt = 1.0;

                }
                if( PosAry[TopPnt].x > SCREEN_H ){
                    IsAttack = false;
                    g_EnemyHp -= 10;
                    g_EnemyDamageCnt = 1.0;
                }
            }
        }

        if( minX > SCREEN_W || maxX < 0 || minY > SCREEN_H || maxY < 0 ){
            PosAry = new Array;
        }


    }  

}  

class ControlData{  
    public var X:Number; 
    public var Y:Number; 
    public var Mouse:int;   

    public function ControlData( x:Number, y:Number, mouse:int ):void{
        X = x;
        Y = y;
        Mouse = mouse;
    }
}

class Trace{  
    public var DataAry:Array; 
    public function Trace(){  
        DataAry = new Array;
    }  
    
    public function add( cd:ControlData ):void{
        DataAry.push( cd );
    }
}

class Player{
    public var NowDrawingLine:LineList;
    public var TraceData:Trace;
    public var PosX:Number;
    public var PosY:Number;

    public function Player(){
        NowDrawingLine = null;
        TraceData = new Trace;
        PosX = 9999;
        PosY = 9999;
    }

    public function updateTrace( cnt:int ):void{
        if( cnt > 0 && cnt < TraceData.DataAry.length ){
            update( TraceData.DataAry[cnt] );
            PosX = TraceData.DataAry[cnt].X;
            PosY = TraceData.DataAry[cnt].Y;
        }
    }
    
    public function update( c:ControlData ):void{
        TraceData.add( c );

        if( c.Mouse & MOUSE_LEFT_TRG ){
            if( NowDrawingLine == null ){
                NowDrawingLine = new LineList( new Point( c.X, c.Y ) )
                g_LineLst.push( NowDrawingLine );
            }
        }
 
        if( c.Mouse & MOUSE_LEFT ){
           NowDrawingLine.addPoint( new Point( c.X, c.Y ) );
        }else{
            if( NowDrawingLine != null ){
                NowDrawingLine.MoveStart = true;
                NowDrawingLine = null;
            }
        }

    }
}





var MOUSE_LEFT:int = 0x01;   
var MOUSE_LEFT_TRG:int = 0x02;   
var MouseData:int;   
function MouseCheckDown(event:MouseEvent):void{   
    MouseData |= MOUSE_LEFT;   
    MouseData |= MOUSE_LEFT_TRG;   
}            

function MouseCheckUp(event:MouseEvent):void{   
    MouseData &= ~MOUSE_LEFT;   
}            

function MouseUpdate():void{   
    MouseData &= ~MOUSE_LEFT_TRG;   
} 
