/**
 * Copyright H.S ( http://wonderfl.net/user/H.S )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cs6n
 */

package{
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    public class Main extends Sprite{
        
        public function Main():void{
            
            //Clockworkオブジェクト
            var clockwork:Clockwork = new Clockwork(232, 215, 100, 10, true);
            stage.addChild(clockwork);
            
            //矢印
            var arrow_r:int = 85;
            var length_a:int = Math.round(Math.tan(Math.PI / 8) * arrow_r);
            var length_b:int = Math.round(Math.sin(Math.PI / 4) * arrow_r);
            var arrow:Shape = new Shape();
            arrow.x = 232;
            arrow.y = 215;
            arrow.graphics.beginFill(0xFF8080, 1);
            arrow.graphics.moveTo(arrow_r - 9, 0);
            arrow.graphics.lineTo(arrow_r + 9, 0);
            arrow.graphics.lineTo(arrow_r, 14);
            arrow.graphics.endFill();
            arrow.graphics.lineStyle(2, 0xFF8080);
            arrow.graphics.moveTo(0, -arrow_r);
            arrow.graphics.curveTo(length_a, -arrow_r, length_b, -length_b);
            arrow.graphics.curveTo(arrow_r, -length_a, arrow_r, 0);
            stage.addChild(arrow);
            
            //ハムスター
            var hamster:Sprite = new Sprite();
            hamster.mouseEnabled = false;
            hamster.mouseChildren = false;
            hamster.x = 232;
            hamster.y = 265;
            stage.addChild(hamster);
            var hamster_rest:Loader = new Loader();
            hamster_rest.load(new URLRequest("http://blog-imgs-61.fc2.com/c/9/9/c9975/hamster_rest.swf"));
            var hamster_move:Loader = new Loader();
            hamster_move.load(new URLRequest("http://blog-imgs-61.fc2.com/c/9/9/c9975/hamster_move.swf"));
            hamster_rest.x = hamster_move.x = -33;
            hamster.addChild(hamster_rest);
            
            //メーター
            var Meter:Shape = new Shape();
            Meter.x = 157;
            Meter.y = 340;
            Meter.graphics.beginFill(0x808080, 1);
            Meter.graphics.drawRect(0, 0, 150, 10);
            stage.addChild(Meter);
            
            stage.addEventListener(Event.ENTER_FRAME, enter_flameHundler);
            function enter_flameHundler(event:Event):void{
                
                //ハムスターを動かす
                if (clockwork.state=="move"){
                    hamster.removeChildAt(0);
                    hamster.addChild(hamster_move);
                }
                else{
                    hamster.removeChildAt(0);
                    hamster.addChild(hamster_rest);
                }
                if (clockwork.direction=="clockwise" && clockwork.count >= 0){
                    hamster.scaleX = -1;
                }
                else if (clockwork.direction=="counterclockwise"){
                    hamster.scaleX = 1;
                }
                
                //メーターの描画
                var energy:int = clockwork.count * 15 + Math.round(clockwork.wheelRotation / 360 * 15);
                if (energy > 150){
                    energy = 150;
                }
                else if (energy < 0){
                    energy = 0;
                }
                Meter.graphics.clear();
                Meter.graphics.beginFill(0x808080, 1);
                Meter.graphics.drawRect(0, 0, 150, 10);
                Meter.graphics.beginFill(0xFF8080, 1);
                Meter.graphics.drawRect(0, 0, energy, 10);
            }
        }
    }
}



import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

//Clockworkクラス
class Clockwork extends Sprite{
    
    public var wheel:Sprite = new Sprite();
    public var wheel_r:uint; //半径
    public var center_x:int; //中心のＸ座標
    public var center_y:int; //中心のＹ座標
    public var state:String;//状態
    public var direction:String;//回転の方向
    public var count:int=0; //回転数
    public var wheelRotation:int = 0; //回転角
    public var count_max:uint; //最大回転数
    public var autoRewind:Boolean; //自動巻き戻しの設定
    public var speed:uint = 10;//巻き戻るスピード
    
    private var overrun:uint = 0; 
    private var mouseFlag:uint = 0;
    private var rotation_staringPoint:int = 0;
    private var rotation_gap:int = 0;
    private var rotation_cursor:int = 0;
    public var wheelRotation_old:int = 0;
    
    public function Clockwork(x:int = 100, y:int = 100, r:int = 100, max:int = 1000, rewind:Boolean = true):void {    
        wheel_r = r;
        center_x = x;
        center_y = y;
        autoRewind = rewind;
        count_max = max;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(event:Event = null):void{
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        
        this.x = center_x;
        this.y = center_y;
        
        var length_a:int = Math.round(Math.sin(Math.PI / 4) * wheel_r);
        wheel.x = wheel.y = 0;
        wheel.graphics.lineStyle(2, 0x808080, 1);
        wheel.graphics.beginFill(0xFFFFFF, 1);
        wheel.graphics.drawCircle(0, 0, wheel_r);
        wheel.graphics.moveTo(length_a, -length_a);
        wheel.graphics.lineTo(-length_a, length_a);
        wheel.graphics.moveTo(length_a, length_a);
        wheel.graphics.lineTo(-length_a, -length_a);
        this.addChild(wheel);
        
        var hitTestShape1:Shape = new Shape();
        hitTestShape1.alpha = 0;
        hitTestShape1.x = -10
        hitTestShape1.y = -100;
        hitTestShape1.graphics.beginFill(0xFF0000, 1);
        hitTestShape1.graphics.drawRect(0, 0, 20, 20);
        wheel.addChild(hitTestShape1);
        
        var hitTestShape2:Shape = new Shape();
        hitTestShape2.alpha = 0;
        hitTestShape2.x = -100;
        hitTestShape2.y = -100;
        hitTestShape2.graphics.beginFill(0xFF0000, 1);
        hitTestShape2.graphics.drawRect(0, 0, 90, 90);
        this.addChild(hitTestShape2);
        
        wheel.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
        function mouseDownHandler(event:MouseEvent):void{
            mouseFlag = 1;
            rotation_staringPoint = Math.round(Math.atan2(mouseX, mouseY * -1) * 180 / Math.PI);
            rotation_gap = wheel.rotation - rotation_staringPoint;
        }
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        function mouseUpHandler(event:MouseEvent):void{
            mouseFlag = 0;
        }
        stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler)
        function enterFrameHandler(event:Event):void{
            //ドラッグで回転する
            if (mouseFlag){
                rotation_cursor = Math.round(Math.atan2(mouseX, mouseY * -1) * 180 / Math.PI);
                
                wheelRotation = rotation_cursor + rotation_gap;
                if (wheelRotation < 0){
                    wheelRotation = 720 + wheelRotation;
                }
                if (wheelRotation >= 360){
                    wheelRotation = wheelRotation - 360;
                }
                wheel.rotation = wheelRotation;
            }
            //マウスアップで巻き戻る
            else if (autoRewind){
                if (count == count_max){
                    wheelRotation = wheelRotation % 90;
                }
                if (count >= 0){
                    wheelRotation -= speed;
                    if (wheelRotation < 0){
                        if (count == 0){
                            wheelRotation = 0;
                        }
                        else{
                            wheelRotation = 360 + wheelRotation;
                        }
                    }
                }
                else{
                    if (wheelRotation == 0){
                        count = 0;
                    }
                    else{
                        wheelRotation = 270 + (wheelRotation % 90);
                    }
                }
                wheel.rotation = wheelRotation;
            }
            
            //回転数をカウントする
            if (hitTestShape1.hitTestObject(hitTestShape2)){
                if (hitTestShape2.x == 10){
                    if (count < count_max){
                        count++;
                    }
                    overrun = 1;
                }
                else if (hitTestShape2.x == -100 && wheelRotation != 0){
                    if (count >= 0){
                        count--;
                    }
                    overrun = 1;
                }
            }
            else{
                overrun = 0;
            }
            if (wheelRotation >= 0 && wheelRotation < 180){
                hitTestShape2.x = -100;
            }
            else{
                hitTestShape2.x = 10;
            }
            
            //回転の方向を確認する
            if (!overrun) {
                if (wheelRotation > wheelRotation_old) {
                    state = "move";
                    direction = "clockwise";
                }
                else if (wheelRotation < wheelRotation_old) {
                    state = "move";
                    direction = "counterclockwise";
                }
                else {
                    state = "stop";
                }
            }
            wheelRotation_old = wheelRotation;
        }
    }
}