/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cs4r
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    
    [SWF()]
    public class Line extends Sprite {
    	
        private var _canvas:Sprite;
        
    	
        public function Line() {
            
           if(stage)
            	init();
            else
            	addEventListener(Event.ADDED_TO_STAGE , init);
            
        }
        
        
        private function init(e:Event = null):void
        {
        	if(hasEventListener(Event.ADDED_TO_STAGE))
        		removeEventListener(Event.ADDED_TO_STAGE , init);
        		
        	_canvas = new Sprite();
        	stage.addEventListener(MouseEvent.MOUSE_MOVE , handleMouseMove);
        	stage.addEventListener(MouseEvent.CLICK , handleClick);
        	
        	addChild(_canvas);
        }
        
        private var _point:Point = new Point(0,0);
        private var _tf:TextField = new TextField();
        private var _color:uint = 0x000000;
        private var _colorChangeNum:int = 5;
        private function handleMouseMove(e:MouseEvent):void
        {
        	_tf.width = stage.stageWidth;
        	_tf.text = "mouseMove "+mouseX+" : "+mouseY+"  color ="+_color;
        	addChild(_tf);
        	_color += _colorChangeNum 
                if(_color < 1 || _color > 0xFFFFFF)
                   _colorChangeNum = -_colorChangeNum;
                   
        	_canvas.graphics.lineStyle(1,_color);
        	_canvas.graphics.moveTo(_point.x , _point.y);
        	_canvas.graphics.lineTo(mouseX , mouseY);
        	
        	_point.x = mouseX;
        	_point.y = mouseY;
        	
        }
        
        private function handleClick(e:MouseEvent):void
        {
			_tf.text = "click";
            _canvas.graphics.clear();
        }
    }
}