/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/criT
 */

// forked from nabe's DisplacementMapFilterで四分の一円
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.BlendMode;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	public class Main extends Sprite 
	{
		private var bg_data:BitmapData;
		private var cursor_data:BitmapData;
		private var cursor_:Bitmap;
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			var s_:Sprite = new Sprite;
			var g_:Graphics = s_.graphics;

			//適当に地のビットマップを用意する。
			bg_data = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x8080);
			bg_data.noise(new Date().getTime());
			bg_data.applyFilter(bg_data.clone(), bg_data.rect, new Point(0, 0), new BlurFilter(0x8, 0x8));

			g_.clear();
			g_.lineStyle(3, 0xFFCCCC);
			g_.drawRoundRect(110, 150, 200, 50, 5, 5);
			bg_data.draw(s_);

			this.addChild(new Bitmap(bg_data));

			//四分の一円のカーソルを用意する。
			cursor_data = new BitmapData(0x80, 0x80, true, 0);

			g_.clear();
			g_.beginFill(0xFF);
			g_.drawCircle(0, 0, 0x80);
			g_.endFill();
			cursor_data.draw(s_);

			cursor_ = new Bitmap(cursor_data);
			cursor_.filters = [newFilter()];
			this.addChild(cursor_);

			//カーソルの更新。
			update_(null);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, update_);
		}

		private function update_(e:Event):void {
			cursor_data.copyPixels(bg_data, new Rectangle(mouseX, mouseY, 0x2, 0x80), new Point(0, 0));
			cursor_.x = mouseX;
			cursor_.y = mouseY;
		}
		
		private function newFilter():DisplacementMapFilter
		{
		//左上を中心として、左端の内容で四分の一円を描く。
			var bd_:BitmapData = new BitmapData(0x80, 0x80, false, 0x8080);
			var s_:Sprite = new Sprite();
			var g_:Graphics = s_.graphics;
			var m_:Matrix = new Matrix();

			//左からの距離を緑から減算。
			g_.clear();
			m_.createGradientBox(0x80, 0x80);
			g_.beginGradientFill(GradientType.LINEAR, [0, 0x7F00], null, null, m_);
			g_.drawRect(0, 0, 0x80, 0x80);
			g_.endFill();
			bd_.draw(s_, null, null, BlendMode.SUBTRACT);
			
			//左上からの距離を青に加算。
			g_.clear();
			m_.createGradientBox(0xFF, 0xFF, 0, -0x7F, -0x7F);
			g_.beginGradientFill(GradientType.RADIAL, [0, 0x7F], null, null, m_);
			g_.drawRect(0, 0, 0x80, 0x80);
			g_.endFill();
			bd_.draw(s_, null, null, BlendMode.ADD);

			//上からの距離を青から減算。
			g_.clear();
			m_.createGradientBox(0x80, 0x80, Math.PI * .5);
			g_.beginGradientFill(GradientType.LINEAR, [0, 0x7F], null, null, m_);
			g_.drawRect(0, 0, 0x80, 0x80);
			g_.endFill();
			bd_.draw(s_, null, null, BlendMode.SUBTRACT);

			return new DisplacementMapFilter(bd_, null, BitmapDataChannel.GREEN, BitmapDataChannel.BLUE, 0x100, 0x100, "color", 0xFF0000, 0);
		}
	}
	
}