/**
 * Copyright fernet ( http://wonderfl.net/user/fernet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cr6J
 */

package { 
    import flash.display.Sprite;
    public class Const extends Sprite {
        // プレイフィールドの設定
        public static const FIELD_SIZE:int = 300;
        public static const FIELD_OFFSET_X:int = 100;
        public static const FIELD_OFFSET_Y:int = 165;
        public static const FIELD_LEFT_BOUND:int = -120;
        public static const FIELD_RIGHT_BOUND:int = 370;
        public static const FIELD_WAVE_TIME:int = 30000; //(ms)
        public static const FIELD_QB_QUOTA:int = 20;
        // プレイヤーの基礎値
        public static const PLAYER_SPEED:Number = 60; //(px/s)
        public static const PLAYER_SWAP_TIME:int = 500; //(ms)
        public static const PLAYER_INVINCIBLE_TIME_ON_DAMAGED:int = 250; //(ms)
        public static const PLAYER_INVINCIBLE_TIME_ON_RECOVER:int = 5000; //(ms)
        public static const PLAYER_RECOVER_TIME:int = 20000; //(ms)
        public static const PLAYER_GAS_INTERVAL:int = 500; //(ms)
        public static const PLAYER_SEND_INTERVAL:int = 250; //(ms)
        public static const PLAYER_BOUNDS_HALF_WIDTH:int = 10;
        public static const PLAYER_BOUNDS_HEIGHT:int = 28;
        // キャラクターのID
        public static const CHARACTER_MADOKA:int = 0;
        public static const CHARACTER_HOMURA:int = 3;
        public static const CHARACTER_SAYAKA:int = 6;
        public static const CHARACTER_MAMI:int = 9;
        public static const CHARACTER_KYOKO:int = 12;
        public static const CHARACTER_QB:int = 15;
        public static const CHARACTER_MADOGAMI:int = 18;
        public static const CHARACTER_MEGAHOMU:int = 21;
        public static const CHARACTER_CHARLOTTE:int = 24;
        public static const CHARACTER_HITOMI:int = 27;
        public static const CHARACTER_KUROSAYA:int = 30;
        public static const CHARACTER_IDS:Array = [
            Const.CHARACTER_MADOKA,
            Const.CHARACTER_HOMURA,
            Const.CHARACTER_SAYAKA,
            Const.CHARACTER_MAMI,
            Const.CHARACTER_KYOKO,
            Const.CHARACTER_MADOGAMI,
            Const.CHARACTER_MEGAHOMU,
            Const.CHARACTER_KUROSAYA,
            Const.CHARACTER_CHARLOTTE,
            Const.CHARACTER_HITOMI
        ];
        // キャラクターの名前
        public static const CHARACTER_NAME_MADOKA:String = "鹿目まどか";
        public static const CHARACTER_NAME_HOMURA:String = "暁美ほむら";
        public static const CHARACTER_NAME_SAYAKA:String = "美樹さやか";
        public static const CHARACTER_NAME_MAMI:String = "巴マミ";
        public static const CHARACTER_NAME_KYOKO:String = "佐倉杏子";
        public static const CHARACTER_NAME_MADOGAMI:String = "概念まどか";
        public static const CHARACTER_NAME_MEGAHOMU:String = "メガネほむら";
        public static const CHARACTER_NAME_KUROSAYA:String = "絶望さやか";
        public static const CHARACTER_NAME_CHARLOTTE:String = "お菓子の魔女";
        public static const CHARACTER_NAME_HITOMI:String = "志筑仁美";
        // 武器のID
        public static const NUM_WEAPONS:int = 14;
        public static const WEAPON_PISTOL:int = 0;
        public static const WEAPON_MASKET:int = 1;
        public static const WEAPON_MINIMI:int = 2;
        public static const WEAPON_ROSEBOW:int = 3;
        public static const WEAPON_BLACKBOW:int = 4;
        public static const WEAPON_EXTINGUISHER:int = 5;
        public static const WEAPON_PIPEBOMB:int = 6;
        public static const WEAPON_RPG7:int = 7;
        public static const WEAPON_GOLFCLUB:int = 8;
        public static const WEAPON_METALBAT:int = 9;
        public static const WEAPON_SABER:int = 10;
        public static const WEAPON_SPEAR:int = 11;
        public static const WEAPON_TIROFINALE:int = 12;
        public static const WEAPON_PUNCH:int = 13;
        // 武器攻撃タイプのID
        public static const ATTACKTYPE_SHOOTING:int = 0;
        public static const ATTACKTYPE_EXPLOSIVE:int = 1;
        public static const ATTACKTYPE_MELEE:int = 2;
        
        public static const DEGREES_TO_RADIANS:Number = Math.PI / 180;
        
        public static const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/7/77/774d/774ddf59e7146c65f530e5f57f6f49e273659bdb";
        
        public static const FONT:String = "Azuki";
        
        public static const EXP_TABLE:Array = [
              50,   70,  100,  120,  140,  170,  210,  250,  300,
             350,  410,  470,  530,  600,  670,  740,  820,  900,
            1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800,
            2000, 2200, 2400, 2600, 2800, 3000, 3200, 3400, 3600,
            3900, 4200, 4500, 4800, 5100, 5400, 5700, 6000, 6300,
            7000, 7400, 7800, 8200, 8600, 9000, 9400, 9800, 9999,
            9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
            9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
            9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
            9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
            9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999
        ];
        
        public static const ENEMY_TABLE:XML =
        <root>
            <wave num= "1" amount= "15" hp= "100" str= "5" vx= "40" />
            <wave num= "2" amount= "18" hp= "100" str= "5" vx= "40" />
            <wave num= "3" amount= "20" hp= "100" str= "5" vx= "40" />
            <wave num= "4" amount= "22" hp= "100" str= "5" vx= "40" />
            <wave num= "5" amount= "25" hp= "100" str= "5" vx= "40" />
            <wave num= "6" amount= "30" hp= "102" str= "5" vx= "41" />
            <wave num= "7" amount= "35" hp= "104" str= "5" vx= "41" />
            <wave num= "8" amount= "40" hp= "106" str= "5" vx= "41" />
            <wave num= "9" amount= "45" hp= "108" str= "5" vx= "41" />
            <wave num="10" amount= "50" hp= "110" str= "6" vx= "42" />
            <wave num="11" amount= "55" hp= "112" str= "6" vx= "42" />
            <wave num="12" amount= "60" hp= "114" str= "6" vx= "42" />
            <wave num="13" amount= "65" hp= "116" str= "6" vx= "42" />
            <wave num="14" amount= "70" hp= "118" str= "6" vx= "43" />
            <wave num="15" amount= "75" hp= "120" str= "7" vx= "43" />
            <wave num="16" amount= "80" hp= "122" str= "7" vx= "43" />
            <wave num="17" amount= "85" hp= "124" str= "7" vx= "44" />
            <wave num="18" amount= "90" hp= "126" str= "7" vx= "44" />
            <wave num="19" amount= "95" hp= "128" str= "7" vx= "44" />
            <wave num="20" amount="100" hp= "130" str= "8" vx= "45" />
            <wave num="21" amount="110" hp= "132" str= "8" vx= "45" />
            <wave num="22" amount="120" hp= "134" str= "8" vx= "46" />
            <wave num="23" amount="130" hp= "136" str= "8" vx= "46" />
            <wave num="24" amount="140" hp= "138" str=" 8" vx= "47" />
            <wave num="25" amount="150" hp= "140" str= "9" vx= "47" />
            <wave num="26" amount="160" hp= "142" str= "9" vx= "48" />
            <wave num="27" amount="170" hp= "144" str= "9" vx= "48" />
            <wave num="28" amount="180" hp= "146" str= "9" vx= "49" />
            <wave num="29" amount="190" hp= "148" str= "9" vx= "49" />
            <wave num="30" amount="200" hp= "150" str="10" vx= "50" />
            <wave num="31" amount="210" hp= "155" str="10" vx= "51" />
            <wave num="32" amount="220" hp= "160" str="10" vx= "52" />
            <wave num="33" amount="230" hp= "165" str="11" vx= "53" />
            <wave num="34" amount="240" hp= "170" str="11" vx= "54" />
            <wave num="35" amount="250" hp= "175" str="11" vx= "55" />
            <wave num="36" amount="260" hp= "180" str="12" vx= "56" />
            <wave num="37" amount="270" hp= "185" str="12" vx= "57" />
            <wave num="38" amount="280" hp= "190" str="12" vx= "58" />
            <wave num="39" amount="290" hp= "195" str="13" vx= "59" />
            <wave num="40" amount="300" hp= "200" str="13" vx= "60" />
            <wave num="41" amount="320" hp= "220" str="13" vx= "62" />
            <wave num="42" amount="340" hp= "240" str="14" vx= "64" />
            <wave num="43" amount="360" hp= "260" str="14" vx= "66" />
            <wave num="44" amount="380" hp= "280" str="14" vx= "68" />
            <wave num="45" amount="400" hp= "300" str="15" vx= "70" />
            <wave num="46" amount="420" hp= "320" str="15" vx= "72" />
            <wave num="47" amount="440" hp= "340" str="15" vx= "74" />
            <wave num="48" amount="460" hp= "360" str="16" vx= "76" />
            <wave num="49" amount="480" hp= "380" str="16" vx= "78" />
            <wave num="50" amount="500" hp= "400" str="16" vx= "80" />
            <wave num="51" amount="530" hp= "450" str="17" vx= "84" />
            <wave num="52" amount="560" hp= "500" str="17" vx= "88" />
            <wave num="53" amount="590" hp= "550" str="17" vx= "92" />
            <wave num="54" amount="620" hp= "600" str="18" vx= "96" />
            <wave num="55" amount="650" hp= "650" str="18" vx="100" />
            <wave num="56" amount="680" hp= "700" str="18" vx="104" />
            <wave num="57" amount="710" hp= "750" str="19" vx="108" />
            <wave num="58" amount="740" hp= "800" str="19" vx="112" />
            <wave num="59" amount="770" hp= "850" str="19" vx="116" />
            <wave num="60" amount="800" hp= "900" str="20" vx="120" />
            <wave num="61" amount="800" hp="1330" str="25" vx="123" />
            <wave num="62" amount="800" hp="1460" str="25" vx="126" />
            <wave num="63" amount="800" hp="1590" str="25" vx="129" />
            <wave num="64" amount="800" hp="1720" str="25" vx="132" />
            <wave num="65" amount="800" hp="1850" str="25" vx="135" />
            <wave num="66" amount="800" hp="1980" str="25" vx="138" />
            <wave num="67" amount="800" hp="2110" str="25" vx="141" />
            <wave num="68" amount="800" hp="2240" str="25" vx="144" />
            <wave num="69" amount="800" hp="2370" str="25" vx="147" />
            <wave num="70" amount="800" hp="2500" str="25" vx="150" />
            <wave num="71" amount="800" hp="2630" str="25" vx="153" />
            <wave num="72" amount="800" hp="2760" str="25" vx="156" />
            <wave num="73" amount="800" hp="2890" str="25" vx="159" />
            <wave num="74" amount="800" hp="3020" str="25" vx="162" />
            <wave num="75" amount="800" hp="3150" str="25" vx="165" />
            <wave num="76" amount="800" hp="3280" str="25" vx="168" />
            <wave num="77" amount="800" hp="3410" str="25" vx="171" />
            <wave num="78" amount="800" hp="3540" str="25" vx="174" />
            <wave num="79" amount="800" hp="3670" str="25" vx="177" />
            <wave num="80" amount="800" hp="3800" str="25" vx="180" />
            <wave num="81" amount="800" hp="3930" str="25" vx="183" />
            <wave num="82" amount="800" hp="4060" str="25" vx="186" />
            <wave num="83" amount="800" hp="4190" str="25" vx="189" />
            <wave num="84" amount="800" hp="4320" str="25" vx="192" />
            <wave num="85" amount="800" hp="4450" str="25" vx="195" />
            <wave num="86" amount="800" hp="4580" str="25" vx="198" />
            <wave num="87" amount="800" hp="4710" str="25" vx="201" />
            <wave num="88" amount="800" hp="4840" str="25" vx="204" />
            <wave num="89" amount="800" hp="4970" str="25" vx="207" />
            <wave num="90" amount="800" hp="5100" str="25" vx="210" />
            <wave num="91" amount="800" hp="5230" str="25" vx="213" />
            <wave num="92" amount="800" hp="5360" str="25" vx="216" />
            <wave num="93" amount="800" hp="5490" str="25" vx="219" />
            <wave num="94" amount="800" hp="5620" str="25" vx="222" />
            <wave num="95" amount="800" hp="5750" str="25" vx="225" />
            <wave num="96" amount="800" hp="5880" str="25" vx="228" />
            <wave num="97" amount="800" hp="6010" str="25" vx="231" />
            <wave num="98" amount="800" hp="6140" str="25" vx="234" />
            <wave num="99" amount="800" hp="6270" str="25" vx="237" />
            <wave num="100" amount="800" hp="6400" str="25" vx="240" />
        </root>;
        
        public static const WEAPON_QUALITY_TABLE:XML =
        <root>
            <quality id="bonecrash" name="ボンクラ" lv="1" wave="1" score="0">
                <level num="0" score="0" dmg="-20" />
                <level num="1" score="30" dmg="-5" crit="3" />
                <level num="2" score="70" dmg="10" crit="5" pene="1" />
            </quality>
            <quality id="normal" name="" lv="1" wave="1" score="50">
                <level num="0" score="0" />
                <level num="1" score="50" dmg="12" crit="3" />
                <level num="2" score="100" dmg="24" crit="5" pene="1" />
            </quality>
            <quality id="irregular" name="イレギュラー" lv="10" wave="10" score="200">
                <level num="0" score="0" dmg="35" />
                <level num="1" score="80" dmg="48" crit="3" />
                <level num="2" score="150" dmg="60" crit="5" pene="1" />
            </quality>
            <quality id="magical" name="マジカル" lv="20" wave="25" score="400">
                <level num="0" score="0" dmg="75" crit="3" pene="1" />
                <level num="1" score="150" dmg="90" crit="5" pene="1" />
                <level num="2" score="300" dmg="100" crit="7" pene="2" />
            </quality>
            <quality id="ultimate" name="アルティメット" lv="30" wave="35" score="700">
                <level num="0" score="0" dmg="125" crit="6" pene="1" />
                <level num="1" score="200" dmg="160" crit="8" pene="2" />
                <level num="2" score="400" dmg="200" crit="10" pene="3" />
            </quality>
        </root>;
        
        public static const WEAPON_BASE_TABLE:XML =
        <root>
            <base id={Const.WEAPON_PISTOL.toString()} name="ピストル" bmin="15" brand="25" brange="100" battack="400" breload="1000" bammo="12">
                <level num="0" score="0" />
                <level num="1" score="100" range="20" attack="10" str="2" vit="2" dex="2" luc="2" />
                <level num="2" score="300" range="40" attack="20" str="6" vit="6" dex="6" luc="6" />
                <level num="3" score="900" range="100" attack="40" str="15" vit="15" dex="15" luc="15" />
            </base>
            <base id={Const.WEAPON_MASKET.toString()} name="マスケット銃" bmin="55" brand="40" brange="180" battack="600" breload="2400" bammo="8">
                <level num="0" score="0" crit="15" />
                <level num="1" score="100" range="10" crit="20" />
                <level num="2" score="300" range="20" ammo="25" crit="25" />
                <level num="3" score="900" range="50" ammo="50" crit="30" />
            </base>
            <base id={Const.WEAPON_MINIMI.toString()} name="ミニミ" bmin="5" brand="25" brange="150" battack="150" breload="4000" bammo="50">
                <level num="0" score="0" dex="-2" />
                <level num="1" score="100" attack="10" ammo="10" dex="-4" />
                <level num="2" score="300" min="5" attack="20" ammo="20" dex="-6" />
                <level num="3" score="900" min="15" attack="30" ammo="50" dex="-8" />
            </base>
            <base id={Const.WEAPON_ROSEBOW.toString()} name="ローズボウ" bmin="10" brand="15" brange="120" battack="200" breload="2500" bammo="24">
                <level num="0" score="0" pene="3" />
                <level num="1" score="100" range="10" luc="3" pene="4" />
                <level num="2" score="300" range="20" luc="9" pene="5" />
                <level num="3" score="900" range="50" luc="20" pene="10" />
            </base>
            <base id={Const.WEAPON_BLACKBOW.toString()} name="ブラックボウ" bmin="10" brand="40" brange="130" battack="300" breload="2600" bammo="18">
                <level num="0" score="0" pene="1" />
                <level num="1" score="100" range="10" dex="3" crit="3" pene="1" />
                <level num="2" score="300" range="20" dex="9" crit="5" pene="2" />
                <level num="3" score="900" range="50" dex="20" crit="10" pene="5" />
            </base>
            <base id={Const.WEAPON_EXTINGUISHER.toString()} name="消火器" bmin="5" brand="15" brange="36" battack="500" breload="2500" bammo="10">
                <level num="0" score="0" kb="14" />
                <level num="1" score="100" crit="3" kb="17" />
                <level num="2" score="300" crit="5" kb="20" />
                <level num="3" score="900" crit="10" kb="30" />
            </base>
            <base id={Const.WEAPON_PIPEBOMB.toString()} name="パイプ爆弾" bmin="20" brand="30" brange="36" battack="350" breload="2700" bammo="15">
                <level num="0" score="0" kb="2" />
                <level num="1" score="100" attack="5" reload="5" kb="3" />
                <level num="2" score="300" attack="10" reload="10" kb="4" />
                <level num="3" score="900" attack="30" reload="30" kb="5" />
            </base>
            <base id={Const.WEAPON_RPG7.toString()} name="ロケットランチャー" bmin="40" brand="100" brange="45" battack="1000" breload="3500" bammo="4">
                <level num="0" score="0" dex="-3" kb="10" />
                <level num="1" score="100" range="5" dex="-6" kb="12" />
                <level num="2" score="300" range="10" ammo="25" dex="-9" kb="14" />
                <level num="3" score="900" range="30" ammo="50" dex="-12" kb="20" />
            </base>
            <base id={Const.WEAPON_GOLFCLUB.toString()} name="ゴルフクラブ" bmin="25" brand="20" brange="38" battack="150" breload="450" bammo="1">
                <level num="0" score="0" />
                <level num="1" score="100" reload="10" crit="5" />
                <level num="2" score="300" reload="20" crit="10" />
                <level num="3" score="900" reload="40" crit="20" />
            </base>
            <base id={Const.WEAPON_METALBAT.toString()} name="金属バット" bmin="0" brand="89" brange="38" battack="150" breload="600" bammo="1">
                <level num="0" score="0" crit="10" kb="4" />
                <level num="1" score="100" rand="10" crit="15" kb="6" />
                <level num="2" score="300" rand="30" crit="20" kb="8" />
                <level num="3" score="900" rand="100" crit="25" kb="10" />
            </base>
            <base id={Const.WEAPON_SABER.toString()} name="サーベル" bmin="45" brand="10" brange="38" battack="150" breload="600" bammo="1">
                <level num="0" score="0" />
                <level num="1" score="100" dmg="10" reload="5" vit="3" />
                <level num="2" score="300" dmg="30" reload="10" vit="9" />
                <level num="3" score="900" dmg="50" reload="20" vit="20" />
            </base>
            <base id={Const.WEAPON_SPEAR.toString()} name="スピア" bmin="40" brand="40" brange="48" battack="150" breload="900" bammo="1">
                <level num="0" score="0" />
                <level num="1" score="100" range="10" str="3" kb="3" />
                <level num="2" score="300" range="20" str="9" kb="6" />
                <level num="3" score="900" range="40" str="20" kb="9" />
            </base>
            <base id={Const.WEAPON_TIROFINALE.toString()} name="ティロフィナーレ" bmin="30" brand="50" brange="200" battack="100" breload="20000" bammo="5">
                <level num="0" score="0" vit="-3" pene="10" />
                <level num="1" score="100" vit="-6" crit="5" kb="5" pene="20" />
                <level num="2" score="300" vit="-9" crit="10" kb="7" pene="30" />
                <level num="3" score="900" vit="-12" crit="20" kb="10" pene="40" />
            </base>
            <base id={Const.WEAPON_PUNCH.toString()} name="パンチ" bmin="70" brand="30" brange="24" battack="150" breload="450" bammo="1">
                <level num="0" score="0" kb="10" />
                <level num="1" score="100" min="10" kb="12" />
                <level num="2" score="300" min="25" kb="16" />
                <level num="3" score="900" min="50" kb="24" />
            </base>
        </root>;
        
        public static const WEAPON_PREFIX_TABLE:XML =
        <root>
            <prefix id="none" name="" lv="1" wave="1" score="0" base="11111111111111">
                <level num="0" score="0" />
            </prefix>
            <prefix id="syosinsya" name="初心者用" lv="1" wave="1" score="20" base="11111111111111">
                <level num="0" score="0" dmg="4" />
                <level num="1" score="10" dmg="8" />
                <level num="2" score="20" dmg="12" />
                <level num="3" score="30" dmg="16" />
                <level num="4" score="40" dmg="20" />
            </prefix>
            <prefix id="syobokure" name="しょぼくれた" lv="1" wave="1" score="20" base="11111111111111">
                <level num="0" score="0" dmg="-20" str="1" vit="1" dex="1" luc="1" />
                <level num="1" score="10" dmg="-40" str="2" vit="2" dex="2" luc="2" />
                <level num="2" score="20" dmg="-60" str="3" vit="3" dex="3" luc="3" />
                <level num="3" score="30" dmg="-80" str="4" vit="4" dex="4" luc="4" />
                <level num="4" score="40" dmg="-100" str="5" vit="5" dex="5" luc="5" />
            </prefix>
            <prefix id="kegare" name="穢れた" lv="1" wave="1" score="20" base="11111111111111">
                <level num="0" score="0" min="2" rand="-4" />
                <level num="1" score="10" min="4" rand="-8" />
                <level num="2" score="20" min="6" rand="-12" />
                <level num="3" score="30" min="8" rand="-16" />
                <level num="4" score="40" min="10" rand="-20" />
            </prefix>
            <prefix id="horobinageki" name="滅びと嘆きの" lv="1" wave="1" score="20" base="11111111111111">
                <level num="0" score="0" min="-2" rand="4" />
                <level num="1" score="10" min="-4" rand="8" />
                <level num="2" score="20" min="-6" rand="12" />
                <level num="3" score="30" min="-8" rand="16" />
                <level num="4" score="40" min="-10" rand="20" />
            </prefix>
            <prefix id="yurusarenai" name="許されない" lv="1" wave="1" score="20" base="11111000111111">
                <level num="0" score="0" range="4" />
                <level num="1" score="10" range="8" />
                <level num="2" score="20" range="12" />
                <level num="3" score="30" range="16" />
                <level num="4" score="40" range="20" />
            </prefix>
            <prefix id="inga" name="因果の" lv="1" wave="1" score="20" base="11111111111111">
                <level num="0" score="0" dmg="-8" min="-4" attack="3" reload="2" />
                <level num="1" score="10" dmg="-9" min="-4" attack="6" reload="4" />
                <level num="2" score="20" dmg="-10" min="-4" attack="9" reload="6" />
                <level num="3" score="30" dmg="-11" min="-4" attack="12" reload="8" />
                <level num="4" score="40" dmg="-12" min="-4" attack="15" reload="10" />
            </prefix>
            <prefix id="hidosugi" name="ひどすぎる" lv="1" wave="1" score="20" base="11111111000010">
                <level num="0" score="0" attack="5" ammo="-10" />
                <level num="1" score="10" attack="10" ammo="-20" />
                <level num="2" score="20" attack="15" ammo="-30" />
                <level num="3" score="30" attack="20" ammo="-40" />
                <level num="4" score="40" attack="25" ammo="-50" />
            </prefix>
            <prefix id="hituyounai" name="必要のない" lv="1" wave="1" score="20" base="11111111000010">
                <level num="0" score="0" attack="-3" reload="4" />
                <level num="1" score="10" attack="-6" reload="8" />
                <level num="2" score="20" attack="-9" reload="12" />
                <level num="3" score="30" attack="-12" reload="16" />
                <level num="4" score="40" attack="-15" reload="20" />
            </prefix>
            <prefix id="sagi" name="詐欺の" lv="1" wave="1" score="20" base="111111110000000">
                <level num="0" score="0" range="-8" ammo="4" />
                <level num="1" score="10" range="-16" ammo="8" />
                <level num="2" score="20" range="-24" ammo="12" />
                <level num="3" score="30" range="-32" ammo="16" />
                <level num="4" score="40" range="-40" ammo="20" />
            </prefix>
            <prefix id="zettaiokasi" name="絶対おかしい" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" min="1" rand="1" />
                <level num="1" score="15" min="2" rand="2" />
                <level num="2" score="30" min="3" rand="3" />
                <level num="3" score="45" min="4" rand="4" />
                <level num="4" score="60" min="5" rand="5" />
            </prefix>
            <prefix id="gusya" name="愚者の" lv="2" wave="3" score="60" base="00000000111101">
                <level num="0" score="0" reload="3" />
                <level num="1" score="15" reload="6" />
                <level num="2" score="30" reload="9" />
                <level num="3" score="45" reload="12" />
                <level num="4" score="60" reload="15" />
            </prefix>
            <prefix id="mubousugi" name="無謀すぎる" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" str="2" />
                <level num="1" score="15" str="3" />
                <level num="2" score="30" str="4" />
                <level num="3" score="45" str="5" />
                <level num="4" score="60" str="6" />
            </prefix>
            <prefix id="hakanaiasita" name="儚い明日の" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" vit="2" />
                <level num="1" score="15" vit="3" />
                <level num="2" score="30" vit="4" />
                <level num="3" score="45" vit="5" />
                <level num="4" score="60" vit="6" />
            </prefix>
            <prefix id="mienai" name="人には見えない" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" dex="2" />
                <level num="1" score="15" dex="3" />
                <level num="2" score="30" dex="4" />
                <level num="3" score="45" dex="5" />
                <level num="4" score="60" dex="6" />
            </prefix>
            <prefix id="hadesugi" name="派手すぎる" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" luc="2" />
                <level num="1" score="15" luc="3" />
                <level num="2" score="30" luc="4" />
                <level num="3" score="45" luc="5" />
                <level num="4" score="60" luc="6" />
            </prefix>
            <prefix id="wakewakaran" name="わけがわからない" lv="2" wave="3" score="60" base="11111111111111">
                <level num="0" score="0" crit="1" pene="1" />
                <level num="1" score="15" crit="2" pene="1" />
                <level num="2" score="30" crit="3" pene="1" />
                <level num="3" score="45" crit="4" pene="1" />
                <level num="4" score="60" crit="5" pene="1" />
            </prefix>
            <prefix id="benri" name="便利な" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" str="1" vit="1" />
                <level num="1" score="25" str="2" vit="2" />
                <level num="2" score="50" str="3" vit="3" />
                <level num="3" score="75" str="4" vit="4" />
                <level num="4" score="100" str="5" vit="5" />
            </prefix>
            <prefix id="jiman" name="自慢の" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" str="1" dex="1" />
                <level num="1" score="25" str="2" dex="2" />
                <level num="2" score="50" str="3" dex="3" />
                <level num="3" score="75" str="4" dex="4" />
                <level num="4" score="100" str="5" dex="5" />
            </prefix>
            <prefix id="yuuki" name="勇気の" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" str="1" luc="1" />
                <level num="1" score="25" str="2" luc="2" />
                <level num="2" score="50" str="3" luc="3" />
                <level num="3" score="75" str="4" luc="4" />
                <level num="4" score="100" str="5" luc="5" />
            </prefix>
            <prefix id="yakudati" name="役に立つ" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" vit="1" dex="1" />
                <level num="1" score="25" vit="2" dex="2" />
                <level num="2" score="50" vit="3" dex="3" />
                <level num="3" score="75" vit="4" dex="4" />
                <level num="4" score="100" vit="5" dex="5" />
            </prefix>
            <prefix id="omosiromi" name="面白みのある" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" vit="1" luc="1" />
                <level num="1" score="25" vit="2" luc="2" />
                <level num="2" score="50" vit="3" luc="3" />
                <level num="3" score="75" vit="4" luc="4" />
                <level num="4" score="100" vit="5" luc="5" />
            </prefix>
            <prefix id="suteki" name="素敵な" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" dex="1" luc="1" />
                <level num="1" score="25" dex="2" luc="2" />
                <level num="2" score="50" dex="3" luc="3" />
                <level num="3" score="75" dex="4" luc="4" />
                <level num="4" score="100" dex="5" luc="5" />
            </prefix>
            <prefix id="jihi" name="慈悲の" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" dmg="-50" vit="10" />
                <level num="1" score="25" dmg="-50" vit="12" />
                <level num="2" score="50" dmg="-50" vit="14" />
                <level num="3" score="75" dmg="-50" vit="16" />
                <level num="4" score="100" dmg="-50" vit="18" />
            </prefix>
            <prefix id="nazonosiroi" name="謎の白い" lv="4" wave="6" score="100" base="11111111111111">
                <level num="0" score="0" dmg="-50" luc="10" />
                <level num="1" score="25" dmg="-50" luc="12" />
                <level num="2" score="50" dmg="-50" luc="14" />
                <level num="3" score="75" dmg="-50" luc="16" />
                <level num="4" score="100" dmg="-50" luc="18" />
            </prefix>
            <prefix id="gouyoku" name="強欲の" lv="4" wave="6" score="100" base="11011011111111">
                <level num="0" score="0" crit="1" kb="1" />
                <level num="1" score="25" crit="2" kb="2" />
                <level num="2" score="50" crit="3" kb="3" />
                <level num="3" score="75" crit="4" kb="4" />
                <level num="4" score="100" crit="5" kb="5" />
            </prefix>
            <prefix id="minnaninaisyo" name="みんなには内緒の" lv="4" wave="6" score="100" base="11111000000000">
                <level num="0" score="0" pene="2" />
                <level num="1" score="25" pene="3" />
                <level num="2" score="50" pene="4" />
                <level num="3" score="75" pene="5" />
                <level num="4" score="100" pene="6" />
            </prefix>
            <prefix id="tokubetu" name="特別な" lv="8" wave="10" score="160" base="11111111111111">
                <level num="0" score="0" dmg="25" />
                <level num="1" score="40" dmg="30" />
                <level num="2" score="80" dmg="35" />
                <level num="3" score="120" dmg="40" />
                <level num="4" score="160" dmg="45" />
            </prefix>
            <prefix id="zankoku" name="残酷な" lv="8" wave="10" score="160" base="11111111111111">
                <level num="0" score="0" dmg="50" vit="-6" dex="-6" luc="-6" />
                <level num="1" score="40" dmg="60" vit="-7" dex="-7" luc="-7" />
                <level num="2" score="80" dmg="70" vit="-8" dex="-8" luc="-8" />
                <level num="3" score="120" dmg="80" vit="-9" dex="-9" luc="-9" />
                <level num="4" score="160" dmg="90" vit="-10" dex="-10" luc="-10" />
            </prefix>
            <prefix id="burai" name="無頼の" lv="8" wave="10" score="160" base="11111111111111">
                <level num="0" score="0" min="2" />
                <level num="1" score="40" min="4" />
                <level num="2" score="80" min="6" />
                <level num="3" score="120" min="8" />
                <level num="4" score="160" min="10" />
            </prefix>
            <prefix id="futeki" name="不敵の" lv="8" wave="10" score="160" base="11111111111111">
                <level num="0" score="0" rand="5" />
                <level num="1" score="40" rand="10" />
                <level num="2" score="80" rand="15" />
                <level num="3" score="120" rand="20" />
                <level num="4" score="160" rand="25" />
            </prefix>
            <prefix id="kagayaki" name="輝きの" lv="8" wave="10" score="160" base="11111111000010">
                <level num="0" score="0" attack="4" />
                <level num="1" score="40" attack="8" />
                <level num="2" score="80" attack="12" />
                <level num="3" score="120" attack="16" />
                <level num="4" score="160" attack="20" />
            </prefix>
            <prefix id="seigi" name="正義の" lv="8" wave="10" score="160" base="11111111111111">
                <level num="0" score="0" crit="5" kb="2" />
                <level num="1" score="40" crit="6" kb="2" />
                <level num="2" score="80" crit="7" kb="2" />
                <level num="3" score="120" crit="8" kb="2" />
                <level num="4" score="160" crit="9" kb="2" />
            </prefix>
            <prefix id="kindan" name="禁断の" lv="10" wave="12" score="180" base="00000000111101">
                <level num="0" score="0" dmg="100" reload="-60" />
                <level num="1" score="50" dmg="110" reload="-60" />
                <level num="2" score="100" dmg="120" reload="-60" />
                <level num="3" score="150" dmg="130" reload="-60" />
                <level num="4" score="200" dmg="140" reload="-60" />
            </prefix>
            <prefix id="risou" name="理想の" lv="10" wave="12" score="180" base="11111111000010">
                <level num="0" score="0" reload="3" ammo="4" />
                <level num="1" score="50" reload="6" ammo="8" />
                <level num="2" score="100" reload="9" ammo="12" />
                <level num="3" score="150" reload="12" ammo="16" />
                <level num="4" score="200" reload="15" ammo="20" />
            </prefix>
            <prefix id="kakugo" name="覚悟の" lv="10" wave="12" score="180" base="11111111111111">
                <level num="0" score="0" dmg="2" str="8" vit="-2" />
                <level num="1" score="50" dmg="4" str="9" vit="-2"  />
                <level num="2" score="100" dmg="6" str="10" vit="-2" />
                <level num="3" score="150" dmg="8" str="11" vit="-2" />
                <level num="4" score="200" dmg="10" str="12" vit="-2" />
            </prefix>
            <prefix id="fukutu" name="不屈の" lv="10" wave="12" score="180" base="11111111111111">
                <level num="0" score="0" dmg="2" str="-2" vit="8" />
                <level num="1" score="50" dmg="4" str="-2" vit="9" />
                <level num="2" score="100" dmg="6" str="-2" vit="10" />
                <level num="3" score="150" dmg="8" str="-2" vit="11" />
                <level num="4" score="200" dmg="10" str="-2" vit="12" />
            </prefix>
            <prefix id="kareina" name="華麗なる" lv="10" wave="12" score="180" base="11111111111111">
                <level num="0" score="0" dmg="2" dex="8" luc="-2" />
                <level num="1" score="50" dmg="4" dex="9" luc="-2" />
                <level num="2" score="100" dmg="6" dex="10" luc="-2" />
                <level num="3" score="150" dmg="8" dex="11" luc="-2" />
                <level num="4" score="200" dmg="10" dex="12" luc="-2" />
            </prefix>
            <prefix id="kakkoii" name="かっこいい" lv="10" wave="12" score="180" base="11111111111111">
                <level num="0" score="0" dmg="2" dex="-2" luc="8" />
                <level num="1" score="50" dmg="4" dex="-2" luc="9" />
                <level num="2" score="100" dmg="6" dex="-2" luc="10" />
                <level num="3" score="150" dmg="8" dex="-2" luc="11" />
                <level num="4" score="200" dmg="10" dex="-2" luc="12" />
            </prefix>
            <prefix id="yakusoku" name="約束の" lv="10" wave="12" score="180" base="11111000000010">
                <level num="0" score="0" min="1" rand="2" pene="2" />
                <level num="1" score="50" min="2" rand="4" pene="2" />
                <level num="2" score="100" min="3" rand="6" pene="2" />
                <level num="3" score="150" min="4" rand="8" pene="2" />
                <level num="4" score="200" min="5" rand="10" pene="2" />
            </prefix>
            <prefix id="tottemouresi" name="とっても嬉しい" lv="12" wave="15" score="200" base="11111111111111">
                <level num="0" score="0" str="1" vit="1" dex="1" luc="1" />
                <level num="1" score="50" str="2" vit="2" dex="2" luc="2" />
                <level num="2" score="100" str="3" vit="3" dex="3" luc="3" />
                <level num="3" score="150" str="4" vit="4" dex="4" luc="4" />
                <level num="4" score="200" str="5" vit="5" dex="5" luc="5" />
            </prefix>
            <prefix id="erabaresi" name="選ばれし" lv="12" wave="15" score="200" base="11111111111111">
                <level num="0" score="0" rand="2" str="6" luc="6" />
                <level num="1" score="50" rand="4" str="7" luc="7" />
                <level num="2" score="100" rand="6" str="8" luc="8" />
                <level num="3" score="150" rand="8" str="9" luc="9" />
                <level num="4" score="200" rand="10" str="10" luc="10" />
            </prefix>
            <prefix id="syugo" name="守護の" lv="12" wave="15" score="200" base="11111111111111">
                <level num="0" score="0" min="1" vit="6" dex="6" />
                <level num="1" score="50" min="2" vit="7" dex="7" />
                <level num="2" score="100" min="3" vit="8" dex="8" />
                <level num="3" score="150" min="4" vit="9" dex="9" />
                <level num="4" score="200" min="5" vit="10" dex="10" />
            </prefix>
            <prefix id="tokiwokoe" name="時を越えた" lv="12" wave="15" score="200" base="11111111111111">
                <level num="0" score="0" dmg="3" reload="8" crit="5" />
                <level num="1" score="50" dmg="6" reload="9" crit="5" />
                <level num="2" score="100" dmg="9" reload="10" crit="5" />
                <level num="3" score="150" dmg="12" reload="11" crit="5" />
                <level num="4" score="200" dmg="15" reload="12" crit="5" />
            </prefix>
            <prefix id="kokoroduyo" name="心強い" lv="12" wave="15" score="200" base="11111111111111">
                <level num="0" score="0" dmg="3" range="8" kb="2" />
                <level num="1" score="50" dmg="6" range="9" kb="2" />
                <level num="2" score="100" dmg="9" range="10" kb="2" />
                <level num="3" score="150" dmg="12" range="11" kb="2" />
                <level num="4" score="200" dmg="15" range="12" kb="2" />
            </prefix>
            <prefix id="kansya" name="感謝の" lv="12" wave="15" score="200" base="11111111000010">
                <level num="0" score="0" attack="5" ammo="30" dex="2" />
                <level num="1" score="50" attack="5" ammo="35" dex="2" />
                <level num="2" score="100" attack="5" ammo="40" dex="2" />
                <level num="3" score="150" attack="5" ammo="45" dex="2" />
                <level num="4" score="200" attack="5" ammo="50" dex="2" />
            </prefix>
            <prefix id="inori" name="祈りの" lv="12" wave="15" score="200" base="00000000111101">
                <level num="0" score="0" dmg="8" range="10" reload="6" />
                <level num="1" score="50" dmg="8" range="12" reload="8" />
                <level num="2" score="100" dmg="8" range="14" reload="10" />
                <level num="3" score="150" dmg="8" range="16" reload="12" />
                <level num="4" score="200" dmg="8" range="18" reload="14" />
            </prefix>
            <prefix id="subarasi" name="素晴らしい" lv="15" wave="18" score="250" base="11111111111111">
                <level num="0" score="0" dmg="32" min="4" rand="8" />
                <level num="1" score="60" dmg="35" min="5" rand="10" />
                <level num="2" score="120" dmg="38" min="6" rand="12" />
                <level num="3" score="180" dmg="41" min="7" rand="14" />
                <level num="4" score="240" dmg="44" min="8" rand="16" />
            </prefix>
            <prefix id="miryokuteki" name="魅力的な" lv="15" wave="18" score="250" base="11111111111111">
                <level num="0" score="0" rand="20" str="10" crit="4" />
                <level num="1" score="60" rand="25" str="10" crit="4" />
                <level num="2" score="120" rand="30" str="10" crit="4" />
                <level num="3" score="180" rand="35" str="10" crit="4" />
                <level num="4" score="240" rand="40" str="10" crit="4" />
            </prefix>
            <prefix id="gisei" name="犠牲の" lv="15" wave="18" score="250" base="11111111111111">
                <level num="0" score="0" dmg="-22" str="-6" vit="6" dex="6" luc="6" />
                <level num="1" score="60" dmg="-24" str="-7" vit="7" dex="7" luc="7" />
                <level num="2" score="120" dmg="-26" str="-8" vit="8" dex="8" luc="8" />
                <level num="3" score="180" dmg="-28" str="-9" vit="9" dex="9" luc="9" />
                <level num="4" score="240" dmg="-30" str="-10" vit="10" dex="10" luc="10" />
            </prefix>
            <prefix id="negai" name="願いの" lv="15" wave="18" score="250" base="11000011111111">
                <level num="0" score="0" attack="8" reload="10" kb="6" />
                <level num="1" score="60" attack="10" reload="10" kb="7" />
                <level num="2" score="120" attack="12" reload="10" kb="8" />
                <level num="3" score="180" attack="14" reload="10" kb="9" />
                <level num="4" score="240" attack="16" reload="10" kb="10" />
            </prefix>
            <prefix id="aino" name="愛の" lv="15" wave="18" score="250" base="11111000000010">
                <level num="0" score="0" dmg="20" ammo="20" pene="1" />
                <level num="1" score="60" dmg="25" ammo="20" pene="1" />
                <level num="2" score="120" dmg="30" ammo="20" pene="1" />
                <level num="3" score="180" dmg="35" ammo="20" pene="1" />
                <level num="4" score="240" dmg="40" ammo="20" pene="1" />
            </prefix>
            <prefix id="sinjitu" name="真実の" lv="15" wave="18" score="250" base="00000111000000">
                <level num="0" score="0" min="8" range="30" reload="-16" />
                <level num="1" score="60" min="9" range="35" reload="-18" />
                <level num="2" score="120" min="10" range="40" reload="-20" />
                <level num="3" score="180" min="11" range="45" reload="-22" />
                <level num="4" score="240" min="12" range="50" reload="-24" />
            </prefix>
            <prefix id="daisyou" name="代償の" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" dmg="160" min="8" rand="16" vit="-11" dex="-11" luc="-11" />
                <level num="1" score="75" dmg="170" min="9" rand="18" vit="-12" dex="-12" luc="-12" />
                <level num="2" score="150" dmg="180" min="10" rand="20" vit="-13" dex="-13" luc="-13" />
                <level num="3" score="225" dmg="190" min="11" rand="22" vit="-14" dex="-14" luc="-14" />
                <level num="4" score="300" dmg="200" min="12" rand="24" vit="-15" dex="-15" luc="-15" />
            </prefix>
            <prefix id="syuuen" name="終焉の" lv="20" wave="24" score="300" base="11111000000010">
                <level num="0" score="0" rand="80" range="-90" pene="3" />
                <level num="1" score="75" rand="85" range="-90" pene="3" />
                <level num="2" score="150" rand="90" range="-90" pene="3" />
                <level num="3" score="225" rand="95" range="-90" pene="3" />
                <level num="4" score="300" rand="100" range="-90" pene="3" />
            </prefix>
            <prefix id="yamifuriharau" name="闇をふり払う" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" reload="28" str="12" crit="5" pene="1" />
                <level num="1" score="75" reload="31" str="14" crit="5" pene="1" />
                <level num="2" score="150" reload="34" str="16" crit="5" pene="1" />
                <level num="3" score="225" reload="37" str="18" crit="5" pene="1" />
                <level num="4" score="300" reload="40" str="20" crit="5" pene="1" />
            </prefix>
            <prefix id="kensin" name="献身の" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" dmg="28" vit="12" crit="5" kb="3" />
                <level num="1" score="75" dmg="31" vit="14" crit="5" kb="3" />
                <level num="2" score="150" dmg="34" vit="16" crit="5" kb="3" />
                <level num="3" score="225" dmg="37" vit="18" crit="5" kb="3" />
                <level num="4" score="300" dmg="40" vit="20" crit="5" kb="3" />
            </prefix>
            <prefix id="kakusei" name="覚醒の" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" rand="24" dex="12" crit="5" pene="1" />
                <level num="1" score="75" rand="26" dex="14" crit="5" pene="1" />
                <level num="2" score="150" rand="28" dex="16" crit="5" pene="1" />
                <level num="3" score="225" rand="30" dex="18" crit="5" pene="1" />
                <level num="4" score="300" rand="32" dex="20" crit="5" pene="1" />
            </prefix>
            <prefix id="saikonisiawase" name="最高に幸せな" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" min="12" luc="12" kb="3" pene="1" />
                <level num="1" score="75" min="13" luc="14" kb="3" pene="1" />
                <level num="2" score="150" min="14" luc="16" kb="3" pene="1" />
                <level num="3" score="225" min="15" luc="18" kb="3" pene="1" />
                <level num="4" score="300" min="16" luc="20" kb="3" pene="1" />
            </prefix>
            <prefix id="bannou" name="万能の" lv="20" wave="24" score="300" base="11111111111111">
                <level num="0" score="0" dmg="22" str="6" vit="6" dex="6" luc="6" />
                <level num="1" score="75" dmg="24" str="7" vit="7" dex="7" luc="7" />
                <level num="2" score="150" dmg="26" str="8" vit="8" dex="8" luc="8" />
                <level num="3" score="225" dmg="28" str="9" vit="9" dex="9" luc="9" />
                <level num="4" score="300" dmg="30" str="10" vit="10" dex="10" luc="10" />
            </prefix>
            <prefix id="inisie" name="古の" lv="20" wave="24" score="300" base="00000000111101">
                <level num="0" score="0" dmg="18" range="18" str="17" dex="-7" />
                <level num="1" score="75" dmg="20" range="21" str="19" dex="-7" />
                <level num="2" score="150" dmg="22" range="24" str="21" dex="-7" />
                <level num="3" score="225" dmg="24" range="27" str="23" dex="-7" />
                <level num="4" score="300" dmg="26" range="30" str="25" dex="-7" />
            </prefix>
            <prefix id="zetubouaragau" name="絶望に抗う" lv="20" wave="24" score="300" base="00000000111101">
                <level num="0" score="0" dmg="30" range="11" vit="17" luc="-7" />
                <level num="1" score="75" dmg="35" range="12" vit="19" luc="-7" />
                <level num="2" score="150" dmg="40" range="13" vit="21" luc="-7" />
                <level num="3" score="225" dmg="45" range="14" vit="23" luc="-7" />
                <level num="4" score="300" dmg="50" range="15" vit="25" luc="-7" />
            </prefix>
            <prefix id="hikariyobisamasu" name="光を呼び覚ます" lv="20" wave="24" score="300" base="00000000111101">
                <level num="0" score="0" dmg="30" range="11" str="-7" dex="17" />
                <level num="1" score="75" dmg="35" range="12" str="-7" dex="19" />
                <level num="2" score="150" dmg="40" range="13" str="-7" dex="21" />
                <level num="3" score="225" dmg="45" range="14" str="-7" dex="23" />
                <level num="4" score="300" dmg="50" range="15" str="-7" dex="25" />
            </prefix>
            <prefix id="unmei" name="運命の" lv="20" wave="24" score="300" base="00000000111101">
                <level num="0" score="0" dmg="18" range="18" vit="-7" luc="17" />
                <level num="1" score="75" dmg="20" range="21" vit="-7" luc="19" />
                <level num="2" score="150" dmg="22" range="24" vit="-7" luc="21" />
                <level num="3" score="225" dmg="24" range="27" vit="-7" luc="23" />
                <level num="4" score="300" dmg="26" range="30" vit="-7" luc="25" />
            </prefix>
            <prefix id="kuukai" name="空海の" lv="25" wave="28" score="350" base="11111111111111">
                <level num="0" score="0" range="36" ammo="20" />
                <level num="1" score="80" range="37" ammo="21" />
                <level num="2" score="160" range="38" ammo="22" />
                <level num="3" score="240" range="39" ammo="23" />
                <level num="4" score="320" range="40" ammo="24" />
            </prefix>
            <prefix id="majogorosi" name="魔女殺しの" lv="25" wave="28" score="350" base="11111111000010">
                <level num="0" score="0" attack="80" reload="-42" crit="6" kb="2" pene="3" />
                <level num="1" score="80" attack="85" reload="-44" crit="7" kb="2" pene="3" />
                <level num="2" score="160" attack="90" reload="-46" crit="8" kb="2" pene="3" />
                <level num="3" score="240" attack="95" reload="-48" crit="9" kb="2" pene="3" />
                <level num="4" score="320" attack="100" reload="-50" crit="10" kb="2" pene="3" />
            </prefix>
            <prefix id="wasuresarare" name="忘れ去られた" lv="25" wave="28" score="350" base="11111111000010">
                <level num="0" score="0" attack="11" reload="13" ammo="24" str="16" dex="-6" />
                <level num="1" score="80" attack="12" reload="16" ammo="28" str="17" dex="-6" />
                <level num="2" score="160" attack="13" reload="19" ammo="32" str="18" dex="-6" />
                <level num="3" score="240" attack="14" reload="22" ammo="36" str="19" dex="-6" />
                <level num="4" score="320" attack="15" reload="25" ammo="40" str="20" dex="-6" />
            </prefix>
            <prefix id="syokuzai" name="贖罪の" lv="25" wave="28" score="350" base="11111111000010">
                <level num="0" score="0" attack="12" reload="13" ammo="18" vit="16" luc="-6" />
                <level num="1" score="80" attack="14" reload="16" ammo="21" vit="17" luc="-6" />
                <level num="2" score="160" attack="16" reload="19" ammo="24" vit="18" luc="-6" />
                <level num="3" score="240" attack="18" reload="22" ammo="27" vit="19" luc="-6" />
                <level num="4" score="320" attack="20" reload="25" ammo="30" vit="20" luc="-6" />
            </prefix>
            <prefix id="kyoufu" name="恐怖の" lv="25" wave="28" score="350" base="11111111000010">
                <level num="0" score="0" attack="13" reload="11" ammo="24" str="-6" dex="16" />
                <level num="1" score="80" attack="16" reload="12" ammo="28" str="-6" dex="17" />
                <level num="2" score="160" attack="19" reload="13" ammo="32" str="-6" dex="18" />
                <level num="3" score="240" attack="22" reload="14" ammo="36" str="-6" dex="19" />
                <level num="4" score="320" attack="25" reload="15" ammo="40" str="-6" dex="20" />
            </prefix>
            <prefix id="hangyaku" name="反逆の" lv="25" wave="28" score="350" base="11111111000010">
                <level num="0" score="0" attack="13" reload="12" ammo="18" vit="-6" luc="16" />
                <level num="1" score="80" attack="16" reload="14" ammo="21" vit="-6" luc="17" />
                <level num="2" score="160" attack="19" reload="16" ammo="24" vit="-6" luc="18" />
                <level num="3" score="240" attack="22" reload="18" ammo="27" vit="-6" luc="19" />
                <level num="4" score="320" attack="25" reload="20" ammo="30" vit="-6" luc="20" />
            </prefix>
            <prefix id="yumekibou" name="夢と希望の" lv="25" wave="28" score="350" base="11111111111111">
                <level num="0" score="0" dmg="-100" luc="30" />
                <level num="1" score="80" dmg="-100" luc="35" />
                <level num="2" score="160" dmg="-100" luc="40" />
                <level num="3" score="240" dmg="-100" luc="45" />
                <level num="4" score="320" dmg="-100" luc="50" />
            </prefix>
            <prefix id="jouka" name="浄化の" lv="25" wave="28" score="350" base="11111111111111">
                <level num="0" score="0" crit="18" />
                <level num="1" score="80" crit="21" />
                <level num="2" score="160" crit="24" />
                <level num="3" score="240" crit="27" />
                <level num="4" score="320" crit="30" />
            </prefix>
            <prefix id="kiseki" name="奇跡の" lv="30" wave="35" score="500" base="11111111111111">
                <level num="0" score="0" str="30" attack="16" reload="42" ammo="50" pene="2" />
                <level num="1" score="100" str="35" attack="17" reload="44" ammo="50" pene="2" />
                <level num="2" score="200" str="40" attack="18" reload="46" ammo="50" pene="2" />
                <level num="3" score="300" str="45" attack="19" reload="48" ammo="50" pene="2" />
                <level num="4" score="400" str="50" attack="20" reload="50" ammo="50" pene="2" />
            </prefix>
            <prefix id="enkan" name="円環の" lv="30" wave="35" score="500" base="11111111111111">
                <level num="0" score="0" rand="60" range="26" vit="30" crit="6" kb="5" pene="2" />
                <level num="1" score="100" rand="70" range="27" vit="35" crit="7" kb="5" pene="2" />
                <level num="2" score="200" rand="80" range="28" vit="40" crit="8" kb="5" pene="2" />
                <level num="3" score="300" rand="90" range="29" vit="45" crit="9" kb="5" pene="2" />
                <level num="4" score="400" rand="100" range="30" vit="50" crit="10" kb="5" pene="2" />
            </prefix>
            <prefix id="kyuusai" name="救済の" lv="30" wave="35" score="500" base="11111111111111">
                <level num="0" score="0" dmg="42" min="11" rand="22" dex="30" crit="8" pene="2" />
                <level num="1" score="100" dmg="44" min="12" rand="24" dex="35" crit="8" pene="2" />
                <level num="2" score="200" dmg="46" min="13" rand="26" dex="40" crit="8" pene="2" />
                <level num="3" score="300" dmg="48" min="14" rand="28" dex="45" crit="8" pene="2" />
                <level num="4" score="400" dmg="50" min="15" rand="30" dex="50" crit="8" pene="2" />
            </prefix>
            <prefix id="vswarupuru" name="対ワルプルギス" lv="30" wave="35" score="500" base="11111111111111">
                <level num="0" score="0" dmg="80" str="12" luc="12" crit="8" />
                <level num="1" score="100" dmg="85" str="13" luc="13" crit="8" />
                <level num="2" score="200" dmg="90" str="14" luc="14" crit="8" />
                <level num="3" score="300" dmg="95" str="15" luc="15" crit="8" />
                <level num="4" score="400" dmg="100" str="16" luc="16" crit="8" />
            </prefix>
            <prefix id="eien" name="永遠の" lv="30" wave="35" score="500" base="11111111000010">
                <level num="0" score="0" reload="80" ammo="80" vit="12" dex="12" />
                <level num="1" score="100" reload="85" ammo="90" vit="13" dex="13" />
                <level num="2" score="200" reload="90" ammo="90" vit="14" dex="14" />
                <level num="3" score="300" reload="95" ammo="95" vit="15" dex="15" />
                <level num="4" score="400" reload="100" ammo="100" vit="16" dex="16" />
            </prefix>
            <prefix id="madan" name="魔弾の" lv="30" wave="35" score="500" base="11111000000010">
                <level num="0" score="0" dmg="46" attack="26" reload="30" ammo="60" pene="3" />
                <level num="1" score="100" dmg="47" attack="27" reload="35" ammo="70" pene="3" />
                <level num="2" score="200" dmg="48" attack="28" reload="40" ammo="80" pene="3" />
                <level num="3" score="300" dmg="49" attack="29" reload="45" ammo="90" pene="3" />
                <level num="4" score="400" dmg="50" attack="30" reload="50" ammo="100" pene="3" />
            </prefix>
            <prefix id="megami" name="女神の" lv="30" wave="35" score="500" base="11111000000010">
                <level num="0" score="0" min="26" rand="52" range="60" attack="30" kb="2" pene="4" />
                <level num="1" score="100" min="27" rand="54" range="70" attack="35" kb="3" pene="5" />
                <level num="2" score="200" min="28" rand="56" range="80" attack="40" kb="4" pene="6" />
                <level num="3" score="300" min="29" rand="58" range="90" attack="45" kb="5" pene="7" />
                <level num="4" score="400" min="30" rand="60" range="100" attack="50" kb="6" pene="8" />
            </prefix>
            <prefix id="tyoudokyu" name="超弩級の" lv="30" wave="35" score="500" base="00000111000000">
                <level num="0" score="0" dmg="72" reload="30" ammo="100" crit="6" />
                <level num="1" score="100" dmg="74" reload="35" ammo="100" crit="7" />
                <level num="2" score="200" dmg="76" reload="40" ammo="100" crit="8" />
                <level num="3" score="300" dmg="78" reload="45" ammo="100" crit="9" />
                <level num="4" score="400" dmg="80" reload="50" ammo="100" crit="10" />
            </prefix>
            <prefix id="watasinosaikyou" name="わたしの最高の" lv="30" wave="35" score="500" base="00000111000000">
                <level num="0" score="0" min="36" range="20" reload="80" dex="12" />
                <level num="1" score="100" min="37" range="25" reload="85" dex="14" />
                <level num="2" score="200" min="38" range="30" reload="90" dex="16" />
                <level num="3" score="300" min="39" range="35" reload="95" dex="18" />
                <level num="4" score="400" min="40" range="40" reload="100" dex="20" />
            </prefix>
            <prefix id="syunsatu" name="瞬殺の" lv="30" wave="35" score="500" base="00000000111101">
                <level num="0" score="0" dmg="46" range="16" reload="30" kb="6" />
                <level num="1" score="100" dmg="47" range="18" reload="35" kb="7" />
                <level num="2" score="200" dmg="48" range="20" reload="40" kb="8" />
                <level num="3" score="300" dmg="49" range="22" reload="45" kb="9" />
                <level num="4" score="400" dmg="50" range="24" reload="50" kb="10" />
            </prefix>
            <prefix id="saigoninokotta" name="最後に残った" lv="30" wave="35" score="500" base="00000000111101">
                <level num="0" score="0" reload="80" vit="12" dex="12" crit="6" />
                <level num="1" score="100" reload="90" vit="14" dex="14" crit="7" />
                <level num="2" score="200" reload="100" vit="16" dex="16" crit="8" />
                <level num="3" score="300" reload="110" vit="18" dex="18" crit="9" />
                <level num="4" score="400" reload="120" vit="20" dex="20" crit="10" />
            </prefix>
            <prefix id="gainen" name="概念の" lv="30" wave="35" score="500" base="11111111111111">
                <level num="0" score="0" dmg="-200" str="17" vit="17" dex="16" luc="17" />
                <level num="1" score="100" dmg="-200" str="19" vit="19" dex="17" luc="19" />
                <level num="2" score="200" dmg="-200" str="21" vit="21" dex="18" luc="21" />
                <level num="3" score="300" dmg="-200" str="23" vit="23" dex="23" luc="23" />
                <level num="4" score="400" dmg="-200" str="25" vit="25" dex="25" luc="25" />
            </prefix>
            <prefix id="eigaka" name="映画化決定の" lv="35" wave="50" score="1500" base="11111111111111">
                <level num="4" score="0" dmg="200" range="50" attack="50" ammo="100" vit="-120" dex="120" luc="-120" kb="5" pene="5" />
            </prefix>
        </root>;
       
        public static const HOWTOPLAY_TEXTS:Array = [
            {
                title: "プレイ開始！",
                body: "魔法少女としてQBを撃退し、世界を守ってください！\n"
                    + "QBが契約ノルマを達成してしまうとゲームオーバーです！\n\n"
                    + "[はじめ方]\n"
                    + "左上のボタンの一つを押すと、すぐにゲームがはじまります！\n"
                    + "かっこ内の数字が、その世界で戦闘中の魔法少女の人数です。\n"
                    + "はじめての人は3～8人くらいの世界がオススメです。\n\n"
                    + "[操作方法]\n"
                    + "矢印キー: 移動\n"
                    + "Zキー: 武器で攻撃\n"
                    + "Xキー: 射撃武器のリロード（弾補充）\n"
                    + "Cキー: 武器の持ち替え\n\n"
                    + "[ダメージを受けて、HPが0になると？]\n"
                    + "戦闘不能になり、復帰するまで一切の行動が出来なくなります。\n\n"
                    + "[契約ノルマが0になると？]\n"
                    + "世界が破滅しますが、新しい武器が手に入ったり、キャラクターがレベルアップしたりします。\n\n"
            },
            {
                title: "ステータスについて",
                body: "ステータス画面で、キャラクターの能力を確認することができます。\n\n"
                    + "[詳細]\n"
                    + "名前: あなたのニックネームを入力してください。\n"
                    + "Lv.: レベルです。高くなると良い武器が手に入るようになります。\n"
                    + "次のLvまで: この数以上のQBを撃退するとレベルアップします。\n\n"
                    + "残りポイント: 能力に割り振ることでキャラクターが強くなります。ポイントはレベルアップで1ずつ増えます。"
                    + "割り振りをリセットしたい場合は、キャラクターの変更を行ってください。\n\n"
                    + "魔力: 与えるダメージ、ノックバックに影響します。\n"
                    + "精神: 最大HP、戦闘不能からの復帰時間に影響します。\n"
                    + "敏捷: 移動速度、リロード速度、近接武器の攻撃速度に影響します。\n"
                    + "幸運: 入手武器の質、クリティカル率に影響します。\n\n"
                    + "スキル: キャラクター固有の特殊能力です。\n\n"
            },
            {
                title: "武器について",
                body: "武器は２つ装備でき、プレイ中に自由に持ち替えることができます。状況に応じて使い分けましょう！\n\n"
                    + "[攻撃タイプ]\n"
                    + "射撃: ピストル、ローズボウなど。遠距離から攻撃する基本的な武器です。"
                    + "弾は射程外の敵にも当たりますが、その際は大きく威力が落ちます。貫通して複数の敵に当たるものがあります。\n\n"
                    + "爆発: 消火器、パイプ爆弾など。当たった敵を中心に広範囲の爆発が発生する武器です。"
                    + "強力な反面それぞれにクセがあり、使いこなすのが難しいかもしれません。\n\n"
                    + "近接: サーベル、スピアなど。他のタイプに比べて射程は短いですが、範囲が広くリロード無しで攻撃ができる武器です。"
                    + "敵に近づかなければいけないので、ダメージを受けないように注意しましょう。\n\n"
                    + "[特殊効果]\n"
                    + "クリティカル: 発生すると、与えるダメージが５倍になります。\n"
                    + "ノックバック（KB）: 当たった敵を後ろへ押し戻します。"
            },
            {
                title: "とてもとても、よくある質問",
                body: "[プレイ途中で退出するには？]\n"
                    + "ブラウザを最小化するか他のタブを開くと、自動的に離脱します。"
                    + "ただしその場合、経験値は入りますが武器は入手できません。\n\n"
                    + "[いつ終わるの？いつまで続くの？]\n"
                    + "Waveが進行する度に、敵はより強くなっていきます。"
                    + "とりあえず続けてみて下さい。1プレイの想定時間は15～30分程度です。\n\n"
                    + "[世界が崩壊したのに武器が手に入らない]\n"
                    + "世界が崩壊すると武器を入手できるのですが、この時、入手した武器を所持欄に移動しなければ武器は手元に残りません！"
            },
            {
                title: "重要なヒント",
                body: "[難易度]\n"
                    + "難易度は参加人数には関係なく固定です。自分に合った人数の世界に参加しよう。\n\n"
                    + "[特殊な敵]\n"
                    + "敵の一部には、移動速度・攻撃力が高い速攻タイプ、移動速度は低いがHPが多い頑丈タイプが紛れ込んでいることがあります。"
                    + "他と移動速度が違う敵を見つけたら、早めに倒すようにしましょう！\n\n"
                    + "[入手武器の質]\n"
                    + "ゲームオーバー後に手に入る武器は、キャラクターのレベル、幸運、到達Wave、QB撃退数によって大きく変わります。"
                    + "世界が破滅したとき、新しい武器が手に入ります。n\n"
                    + "特に到達Waveは重要なので、仲間と協力して高いWaveを目指しレア武器をゲットしよう！\n\n"
        },
    ];
        
        public static const FAQ_TEXTS:Array = [
        {
                title: "だお鯖について",
                body: "[はじめに]\n"
                    + "2012年7月前後に本家（跡地）の少人数部屋が廃止されたため、その代替として公開しているのが本鯖です。\n\n"
                    + "[本鯖について]\n"
                    + "本鯖は本家のようなレンタル鯖を借りています\n\n" 
                    + "[フォーク版で本家のデータを動かすために]\n"
                    + "本家（跡地）と本鯖とではセーブデータの格納場所が違います！"
                    + "つまり、本家のデータを本鯖で使用するためには、データを所定の場所に移動しなければならないのです。\n\n"
                    + "[跡地との互換性]\n"
                    + "本鯖は跡地2012/02/12版に準拠しています。これは2012/06/09の時点で跡地が公開している最新のコードです。\n\n"
                    + "[だお鯖フォーラム（外部掲示板）]\n"
                    + "だお鯖ではサポート用の外部掲示板を設置しています。\n"
                    + "http://www43.atpages.jp/daoserver/"
            },
{
                title: "セーブデータの移動",
                body: "[セーブデータの移動詳説（1/2）]\n"
                    + "QB狩りオンラインのセーブデータは各PCのCookieに保存されます。"
                    + "セーブデータは「SaveData.sol」というファイルで、本鯖と跡地とで保存場所が異なります。"
                    + "また、OSによっても格納場所が違います。まずOSによる場所の違いを比較します。\n\n"                   
                    + "[XP以前]\n"
                    + "C：￥Documents and Settings￥ユーザー名￥Application Data￥Macromedia￥Flash Player￥SharedObjects￥ランダムの文字列￥swf.wonderfl.net￥swf￥usercode\n\n"
                    + "[Vista以降]\n"
                    + "C：￥ユーザー￥ユーザー名￥AppData￥Roaming￥Macromedia￥Flash Player￥SharedObjects￥ランダムの文字列￥swf.wonderfl.net￥swf￥usercode\n\n"
                    + "[MacOS ver10]\n"
                    + "C：￥ユーザー￥ユーザー名￥ライブラリ・Library￥Preferences￥Macromedia￥Flash Player￥#SharedObjects￥ランダムの文字列￥swf.wonderfl.net￥swf￥usercode\n\n"  
            },
        {
                title: "セーブデータの移動＆注意",
                body: "[セーブデータの移動詳説（2/2）]\n"
                    + "XP以前の場合は、対象のフォルダが隠しファイル扱いになっている場合があります。また「：」や「￥」は半角にしてください。\n\n"
                    + "「usercode」まで到達すると、フォルダが分岐していると思います。この分岐こそが跡地・本鯖のデータ保存場所の違いです。\n"
                    + "跡地の保存場所は「usercode/1/1b」以下直進にあります。同じように「usercode/b/bb」以下直進が本鯖の保存場所になります。これらの場所にある「SaveData」をすげ替えることで、跡地のデータが使用できるようになります。\n\n"
                    + "尚、MiniChatやSaveDataEx等のファイルは本鯖には意味のないものなので、気にしなくて構いません。\n\n"
        　　+ "[セーブデータが消えるんだけど？]\n"
                    + "ブラウザのcookie削除などを行うとセーブデータも一緒に消えてしまいます。"
                    + "ブラウザの履歴の自動削除などを設定している人は、"
                    + "セーブデータもまとめて削除されてしまわないよう十分に注意して下さい。"
            },  
        {
                title: "本家との変更点",
                body: "[Waveスキップ]\n"
                    + "ノルマ20の状態でwaveが終了した場合、１つwaveを飛ばします。\n"
                    + "その際飛ばされたwaveの分のQBは次のwaveで出現します。\n\n"
                    + "[誰も居ない時に@1しか選べない]\n"
                    + "どの部屋にもプレイヤーが居ない場合に@1しか選択できなくなる仕様（バグ？）があります。これは本家にもある仕様です。"
            },
            {
                title: "基本的な質問",
                body: "[プレイ途中で退出するには？]\n"
                    + "ブラウザを最小化するか他のタブを開くと、自動的に離脱します。"
                    + "ただしその場合、経験値は入りますが武器は入手できません。\n\n"
                    + "[ブラウザによる不具合の可能性]\n"
                    + "ブラウザによってプレイ途中の退出やAlt+Z操作に不具合があると確認されています。"
                    + "FireFoxではプレイ途中の退出に障害があるようです。IEでも同様の報告がありますが、一方で正常に動作するとの報告もあります。"
                    + "Chromeでは退出は正常であるものの、Alt+Zコマンドは効きません。Alt+右クリックを代用してください\n\n"
                    + "[いつ終わるの？いつまで続くの？]\n"
                    + "Waveが進行する度に、敵はより強くなっていきます。"
                    + "とりあえず続けてみて下さい。1プレイの想定時間は15～30分程度です。\n\n"
                    + "[すぐゲームから離脱するんだけど？]\n"
                    + "一定以上処理が遅れると、他のプレイヤーに悪影響が及ぶ前に自動的に離脱するようになっています。"
                    + "PCや回線の性能が低い人は、オプションでエフェクトを切って負荷を下げてください。"
                    + "それでも駄目な場合はもっと少人数の世界で遊びましょう。\n\n"   
            },
            {
                title: "基本的な質問",
                body: "[右上の数字は何？]\n"
                    + "FPS : PINGです。FPSは30が正常で、下がるほど処理落ちが発生します。"
                    + "PINGは300以下が正常で、上がるほどラグが発生します。"
                    + "どちらも一定以上悪くなると、自動的に離脱するようになっていますので、十分に注意して下さい。\n\n"
                    + "[チャット荒らしはどうすればいいの？]\n"
                    + "チャット欄に表示されている発言の一つをクリックして選択した後、チャット欄右下の[+]ボタンを押すと"
                    + "その発言したプレイヤーの発言を全て削除し非表示にすることができます。"
                    + "無視を取り消したい場合には、[-]ボタンを押してください。\n\n"
                    + "[チャットの発言の頭に付く()の数字は？]\n"
                    + "騙り防止用のプレイヤーのIDです。\n\n"
                    + "[チャット欄が邪魔・狭い]\n"
                    + "人数が表示されているバーをドラッグすると、チャット欄を移動できます。"
                    + "また、右下の三角部分をドラッグすると、チャット欄のサイズを変更できます。"
                    + "自分の好きな場所・大きさで利用してください。\n\n"
            },
            {
                title: "基本的な質問",
                body: "[プレイ中の名前の後ろに付く@は何？]\n"
                    + "あなたが現在参加している世界の番号です。\n\n"
                    + "[画面下が切れて見えない]\n"
                    + "フルスクリーンでプレイしている場合は下にスクロールして下さい。"
                    + "もしくは、右上の[X]を押して全体が表示されるようにして下さい。"
                    + "また、フルスクリーンは負荷が大きくなるので、\"この作品のコードを見る\"を押して、"
                    + "普通のサイズでプレイするのもオススメです。\n\n"
                    + "[どの世界に参加するのがいいの？]\n"
                    + "大人数の世界は、お祭り騒ぎ好きな人と高難易度へのチャレンジに適しています。\n"
                    + "少人数の世界は、初心者さんのレベル上げや本格的に狩りたい人に適しています。\n"
                    + "初心者は3～8人程度の世界がオススメです。\n\n"
                    + "[何故かダメージを受けているプレイヤーがいる！？]\n"
                    + "PCや回線が不安定な人のラグです。\n\n"
            },
            {
                title: "マナーとモラル",
                body: "[チャットでの発言について]\n"
                    + "基本的にチャットでは自由に好きな話をしても構いません。"
                    + "ただし、様々な人達がチャットを見ているということは常に意識して、"
                    + "過度の下ネタや内輪ネタ等は自重するよう心がけて下さい。\n\n"
                    + "[放置行為について]\n"
                    + "世界に参加したまま離席するのは、その世界の他プレイヤーの迷惑になりますし、"
                    + "ちゃんと遊びたい人が参加出来なくなることもあるのでなるべくお控えください。\n\n"
                    + "[海外のプレイヤーに関して]\n"
                    + "このゲームのメインターゲットは日本人プレイヤーですが、海外のプレイヤーも歓迎しています。"
                    + "国や言語などにとらわれず、全員で協力して楽しくプレイして下さい。"
                    + "今後海外のIPを遮断するようなことは絶対にありません。\n\n"
         　　+ "[満員部屋の状態からの割り込みについて]\n"
                    + "満員になっている部屋に意図的に割り込みをするのはやめてください＞＜"
                    + "マナーです　これはマナーです\n\n"
            },
            {
                title: "ゲームのシステムに関する質問",
                body: "[威力が低い、敵が倒せない]\n"
                    + "射撃武器には射程が設定されています。射程外の敵にも弾は当たりますが、その際には大きく威力が落ちてしまいます。"
                    + "武器の火力を最大限に生かすために、射撃武器でも積極的に前に出て攻撃しましょう。\n"
                    + "ちなみにマップの全長（左端から右端まで）は465です。\n\n"
                    + "[どのキャラ（武器）が強いの？]\n"
                    + "全てのキャラには、得意な部分と苦手な部分があり、どれが最強というものはありません。"
                    + "自分の好きなキャラ、自分のプレイスタイルに合ったキャラを選んで下さい。武器も同様です。\n\n"
                    + "[サブ武器の補正はメイン武器に影響するの？]\n"
                    + "影響するのはステータス補正のみです。\n\n"
                    + "[キャラのスキル補正はどう計算されるの？]\n"
                    + "一番最後に乗算されます。よってかなり強力に影響します。\n"
            },
            {
                title: "要望について",
                body: "[次はいつ更新するんですか？]\n"                    
                    + "だお鯖ではサポート用の外部掲示板にて逐次告知する予定です。\n"
                    + "http://www43.atpages.jp/daoserver/"
            }         
        ];
        
        public static const INFO_MESSAGE:String = "経験値繰越導入！　セーブデータの移動のやり方はよくある質問にありますよ！";
        public static const HISTORY_TEXTS:Array = [
{
                title: "更新履歴【本鯖の変更点】",
                body: ""
                    + "2012/07/15 部屋の人数割りを変更しました（15部屋→16部屋）\n"
                    + "2012/07/15 レベル上昇時に経験値の持ち越しをするようにしました\n"
                    + "2012/06/26 遊び方とよくある質問を整理・加筆しました。\n"
                    + "2012/06/25 Waveスキップを導入しました\n"
                    + "2012/06/23 部屋の人数割りを変更しました\n"
                    + "----本鯖からの変更点です。----\n"
            },
            {
                title: "更新履歴【跡地（本家）の変更点】",
                body: ""
                    + "2012/02/12 まど神様の無敵化の範囲を広くしました\n"
                    + "2012/02/10 崩壊直後の世界の人数を正しく表示するようにしました\n"
                    + "2012/02/10 よくある質問を加筆しました\n"
                    + "2012/02/09 黒さやかのスキルを変更しました\n"
                    + "2012/02/09 次のLvまでの値がアンダーフローしないようにしました\n"
                    + "2012/02/09 あそび方・よくある質問を整理しました\n"
                    + "2012/02/04 ティロフィナーレの性能を多段ヒットタイプにしました\n"
                    + "2012/02/03 復帰時の無敵時間を3秒から5秒に変更しました\n"
                    + "2012/02/03 無敵中のプレイヤーが点滅するようになりました\n"
                    + "2012/02/03 まど神様のスキルを変更しました\n"
                    + "2012/02/03 メガほむの近接の攻撃速度を正しく修正しました\n"
                    + "2012/02/03 腹パンの毒ガスにエフェクトを追加しました\n"
                    + "2012/02/03 毒ガスをQBの現在HP依存ダメージに変更しました\n"
                    + "2012/02/03 武器に「ティロフィナーレ」を追加しました\n"
                    + "2012/02/03 武器に「パンチ」を追加しました\n"
                    + "2012/01/13 接続が切れた際チャット欄がバグる問題を修正しました\n"
            },
            {
                title: "更新履歴【跡地（本家）の変更点】",
                body: ""
                    + "2012/01/13 オプションにStats表示ON/OFFを追加しました\n"
                    + "2012/01/12 世界の初期化が失敗するバグを修正しました\n"
                    + "2012/01/12 Wave330から開始することがあるバグを修正しました\n"
                    + "2012/01/08 よくある質問のチャット部分を更新しました\n"
                    + "2012/01/08 チャット欄のサイズを変更できるようにしました\n"
                    + "2012/01/04 よくある質問のチャット部分を更新しました\n"
                    + "2012/01/04 チャット欄に様々な機能を追加しました\n"
                    + "2011/12/30 よくある質問を加筆しました\n"
                    + "2011/12/22 リロード速度が攻撃速度を上回らないようにしました\n"
                    + "2011/12/18 チャット欄をドラッグできるようにしました\n"
                    + "2011/12/18 よくある質問を加筆しました\n"
                    + "2011/12/17 名前に | が含まれるとバグる問題を修正しました\n"
                    + "2011/12/16 QBの速度がオーバーフローするバグを修正しました\n"
                    + "2011/12/15 Wave61以降の難易度を調整しました\n"
                    + "2011/12/14 ステータス画面に補正前の値を表示するようにしました\n"
                    + "2011/12/13 オプションにQB撃退エフェクトON/OFFを追加しました\n"
                    + "2011/12/13 他プレイヤーの回復速度が確認できるようになりました\n"
                    + "2011/12/12 あそび方・よくある質問を加筆しました\n"
                    + "2011/12/12 更新履歴を追加しました\n"
                    + "2011/11/03 公開\n"
            }
        ];
    } // End of Class
} // End of package