/**
 * Copyright 0954321982 ( http://wonderfl.net/user/0954321982 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cqqU
 */

// forked from paq's QuickBox2D練習
package 
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import com.actionsnippet.qbox.*;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x333333, frameRate = 60)]
    public class Main extends MovieClip
    {
        private var sim:QuickBox2D;
        private var canvas:MovieClip;
        private var dx:Number = 0;
        private var dy:Number = 0;
        private var time:Number = 0;
        private var scale:Number = 1;
        private var scaleDest:Number = 1.0;
        private var currQuick:QuickObject;
        private var xx:Number = 0;
        private var yy:Number = 0;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            canvas = new MovieClip();
            addChild(canvas);
            
            sim = new QuickBox2D(canvas, {debug:true});
            //sim.worldAABB.upperBound = new b2Vec2(3000, 20);
            
            sim.addBox( { x:50, y:15.5, width:100, height:1, density:0 } );
            sim.addBox( { x:60, y:15.5, width:10, height:1, angle:-0.5, density:0 } );
            
            var body:QuickObject = sim.addBox( { x:2.5, y:13, width:4, height:1 } );
            var wheelA:QuickObject = sim.addCircle( { x:1, y:14, radius:0.5 } );
            var wheelB:QuickObject = sim.addCircle( { x:4, y:14, radius:0.5 } );
            sim.setDefault({type:"revolute", enableMotor:true, maxMotorTorque:250});
            var jointA:b2RevoluteJoint = sim.addJoint( { a:body.body, b:wheelA.body, x1:wheelA.x, y1:wheelA.y } ).joint as b2RevoluteJoint;
            var jointB:b2RevoluteJoint = sim.addJoint( { a:body.body, b:wheelB.body, x1:wheelB.x, y1:wheelB.y } ).joint as b2RevoluteJoint;
            jointA.SetMotorSpeed(5);
            jointB.SetMotorSpeed(5);
            sim.setDefault({});
            
            currQuick = body;
            
            var domino:Array = []
            for (var i:int = 0; i < 20; i++) 
            {
                domino.push(sim.addBox( { x:20 + i, y:14, width:0.15, height:1+i*0.1 } ));
            }
            
            var ball:QuickObject = sim.addCircle( { x:50, y:15.5, radius:1, restitution:2 } );
            
            sim.addTimeStepSequence({ time:240, callback:camera, args:[domino[0], 1.5] },
                                    { time:480, callback:camera, args:[domino[4], 0.7, 0, -130] },
                                    { time:700, callback:camera, args:[body, 1] },
                                    { time:930, callback:camera, args:[ball, 1.2] }
                                    );
                                    
            sim.start();
            sim.mouseDrag();
            
            addEventListener(Event.ENTER_FRAME, loop);
            loop()
        }
        
        private function loop(e:Event = null):void 
        {
            scale += (scaleDest - scale) * 0.2;
            dx += (currQuick.x * 30+xx - dx) * 0.2;
            dy += (currQuick.y * 30+yy - dy) * 0.2;
            var m:Matrix = canvas.transform.matrix;
            m.identity();
            m.translate(-dx+100,-dy+200);
            m.scale(scale, scale);
            canvas.transform.matrix = m;
        }   
        
        private function camera(quickObj:QuickObject, scale:Number = -1, x:Number = 0, y:Number = 0):void
        {
            currQuick = quickObj;
            xx = x;
            yy = y;
            if (scale != -1){
                scaleDest = scale;
            }
        }
        
    }
    
}