/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cqoG
 */

package {
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import net.wonderfl.utils.FontLoader;
    
    [SWF(width = "465", height = "465", frameRate = "30")]
    public class Main extends Sprite {
        private static const EMBED_FONT:String = "IPAGP";
        
        public function Main() {
            var loader:FontLoader = new FontLoader();
            loader.addEventListener(Event.COMPLETE, initialize);
            loader.load(EMBED_FONT);
        }
        
        private function initialize(event:Event):void {
            makeTest(25);
            makeTest(170, EMBED_FONT);
            makeTest(315, EMBED_FONT);
        }
        
        private function makeTest(y:Number, embedFontName:String = ""):void {
            var builder:TextBuilder = new TextBuilder().fontSize(70).pos(50, y).size(365, 80);
            if (embedFontName != "") { builder.font(embedFontName); }
            var tf:TextField = builder.build("test てすと");
            addChild(tf);
            
            // bold
            var bold:CheckBox = new CheckBox(this, 400, y + 100, "bold", function(event:Event):void {
                var format:TextFormat = tf.getTextFormat();
                format.bold = bold.selected;
                tf.setTextFormat(format);
            });
            
            // sharpness
            var sharpness:HUISlider = new HUISlider(this, 50, y + 80, "sharpness", function(event:Event):void {
                tf.sharpness = sharpness.value;
            });
            sharpness.width = 365;
            sharpness.setSliderParams( -400, 400, 0);
            
            // thickness
            var thickness:HUISlider = new HUISlider(this, 50, y + 100, "thickness", function(event:Event):void {
                tf.thickness = thickness.value;
            });
            thickness.width = 365;
            thickness.setSliderParams( -400, 400, 0);
        }
    }
}
/* ------------------------------------------------------------------------------------------------
 * TextBuilder
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.geom.Point;
    import flash.text.AntiAliasType;
    import flash.text.GridFitType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    /** 複雑な設定の flash.text.TextField クラスの生成を単純化します。 */
    //public 
    class TextBuilder {
        public static const LEFT:String = "left";
        public static const RIGHT:String = "right";
        public static const CENTER:String = "center";
        
        private var _align:String;
        private var _autoSize:Boolean;
        private var _bold:Boolean;
        private var _filters:Array;
        private var _fontName:String;
        private var _sharpness:Number;
        private var _thickness:Number;
        private var _fontColor:uint;
        private var _fontSize:int;
        private var _position:Point;
        private var _size:Point;
        
        public function TextBuilder() {
            _align = TextBuilder.LEFT;
            _autoSize = _bold = false;
            _filters = [];
            _fontName = null;
            _sharpness = _thickness = 0;
            _fontColor = 0x000000;
            _fontSize = 12;
            _position = new Point(0, 0);
            _size = new Point(100, 100);
        }
        
        public function align(value:String):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSize = enabled;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function filters(value:Array):TextBuilder {
            _filters = value;
            return this;
        }
        
        public function font(name:String, sharpness:Number = 0, thickness:Number = 0):TextBuilder {
            _fontName = name;
            _sharpness = sharpness;
            _thickness = thickness;
            return this;
        }
        
        public function fontColor(value:uint):TextBuilder {
            _fontColor = value;
            return this;
        }
        
        public function fontSize(value:int):TextBuilder {
            _fontSize = value;
            return this;
        }
        
        public function pos(x:Number, y:Number, relative:Boolean = false):TextBuilder {
            _position.x = ((relative) ? _position.x : 0) + x;
            _position.y = ((relative) ? _position.y : 0) + y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _size.x = width;
            _size.y = height;
            return this;
        }
        
        public function build(text:String):TextField {
            var tf:TextField = new TextField();
            tf.x = _position.x;
            tf.width = _size.x;
            tf.height = _size.y;
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_fontName) {
                tf.embedFonts = true;
                tf.antiAliasType = AntiAliasType.ADVANCED;
                tf.gridFitType = (_align == TextBuilder.LEFT) ? GridFitType.PIXEL : GridFitType.SUBPIXEL;
                tf.sharpness = _sharpness;
                tf.thickness = _thickness;
            }
            if (_autoSize) {
                switch(_align) {
                    case TextBuilder.LEFT: { tf.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.RIGHT: { tf.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.CENTER: { tf.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            tf.defaultTextFormat = format;
            tf.text = text;
            tf.y = _position.y + ((_autoSize) ? Math.max(0, int((_size.y - (tf.textHeight + 4)) / 2)) : 0);
            tf.filters = _filters.concat();
            tf.mouseEnabled = tf.selectable = false;
            return tf;
        }
        
        public function clone():TextBuilder {
            return new TextBuilder().align(_align).autoSize(_autoSize).bold(_bold).filters(_filters)
            .font(_fontName, _sharpness, _thickness).fontColor(_fontColor).fontSize(_fontSize)
            .pos(_position.x, _position.y).size(_size.x, _size.y);
        }
    }
//}