/**
 * Copyright 1sunbou ( http://wonderfl.net/user/1sunbou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cqX3
 */

// forked from ProjectNya's ひよこちゃんキット
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃんキット
//
// [AS3.0] Piyoクラスに挑戦！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1448
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.system.LoaderContext;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var piyoPath:String = "http://www.project-nya.jp/images/flash/wonderfl_piyo.swf";
        private var Piyo:Class;
        private var piyo:MovieClip;
        private var label:Label;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            draw();
            //
            Security.allowDomain("www.project-nya.jp");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(piyoPath), new LoaderContext(true));
            //
            label = new Label(200, 40, 32, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 100;
            label.textColor = 0xFFFFFF;
            label.alpha = 0.6;
            label.text = "Piyo Kit";
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(Event.COMPLETE, complete);
            var content:MovieClip = MovieClip(evt.target.content);
            //Piyoクラス
            Piyo = MovieClip(content.piyo).constructor;
            setup();
            loader = null;
        }
        private function setup():void {
            piyo = new Piyo();
            addChild(piyo);
            piyo.x = 232;
            piyo.y = 400;
            //スケール
            piyo.scale = 2.5;
            //首を振る (マウスオーバー時)
            //piyo.swingHead();
            //ジャンプする (クリック時)
            //piyo.jump();
            //ボタン無効化
            //piyo.mouseChildren = false;
        }
        /////////////////////////////////////////////
        //背景
        /////////////////////////////////////////////
        private function draw():void {
            drawSky();
            drawGround();
        }
        private function drawSky():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 350, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x0069A0, 0x00AAE4], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 350);
            graphics.endFill();
        }
        private function drawGround():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 115, 0.5*Math.PI, 0, 350);
            graphics.beginGradientFill(GradientType.LINEAR, [0x99CC33, 0x7EB133], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 350, 465, 115);
            graphics.endFill();
        }

    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
