/**
 * Copyright yuugurenote ( http://wonderfl.net/user/yuugurenote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cpdu
 */

// forked from Scmiz's snaky
package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    public class FlashTest extends Sprite {
        private const NUM:uint = 1;
        
        private const COLOR_MIN:uint = 128;
        private const COLOR_MAX:uint = 255;
        
        private const CTF_RedInc:uint = 0;
        private const CTF_GreenInc:uint = 1;
        private const CTF_RedDec:uint = 2;
        private const CTF_BlueInc:uint = 3;
        private const CTF_GreenDec:uint = 4;
        private const CTF_BlueDec:uint = 5;
        
        private var _sprite:Sprite;
        private var _array:Array;
        private var _count:uint = 0;
        private var _colorTransformMode:uint = CTF_RedInc;
        private var _r:uint = COLOR_MIN;
        private var _g:uint = COLOR_MIN;
        private var _b:uint = COLOR_MAX;
        
        public function FlashTest() {
            var g:Graphics = this.graphics;
            g.beginFill(0x000000);
            g.drawRect(0, 0, 465, 465);
            g.endFill();

            _sprite = new Sprite();
            _array = new Array();


            var length:Number = 200;
            for (var index:uint = 0; index < NUM; ++index) {
                var rad:Number = Math.PI * 2 * (index / NUM);
                var x:Number = Math.cos(rad) * length;
                var y:Number = Math.sin(rad) * length;
                _array.push(new Point(x, y));
            }
        
            _sprite.x = 232.5;
            _sprite.y = 232.5;
            this.addChild(_sprite);
            
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            ++_count;
            if (_count >= _array.length) _count = 0;

            _sprite.rotationZ += 1;
            
            var g:Graphics = _sprite.graphics;
            g.clear();

            var colorSpeed:uint = 5;
            switch (_colorTransformMode) {
                case CTF_RedInc:
                    _r += colorSpeed;
                    if (_r >= COLOR_MAX) {
                        _r = COLOR_MAX;
                        _colorTransformMode = CTF_BlueDec;
                    }
                    break;
                case CTF_BlueDec:
                    _b -= colorSpeed;
                    if (_b <= COLOR_MIN) {
                        _b = COLOR_MIN;
                        _colorTransformMode = CTF_GreenInc;
                    }
                    break;
                case CTF_GreenInc:
                    _g += colorSpeed;
                    if (_g >= COLOR_MAX) {
                        _g = COLOR_MAX;
                        _colorTransformMode = CTF_RedDec;
                    }
                    break;
                case CTF_RedDec:
                    _r -= colorSpeed;
                    if (_r <= COLOR_MIN) {
                        _r = COLOR_MIN;
                        _colorTransformMode = CTF_BlueInc;
                    }
                    break;
                case CTF_BlueInc:
                    _b += colorSpeed;
                    if (_b >= COLOR_MAX) {
                        _b = COLOR_MAX;
                        _colorTransformMode = CTF_GreenDec;
                    }
                    break;
                case CTF_GreenDec:
                    _g -= colorSpeed;
                    if (_g <= COLOR_MIN) {
                        _g = COLOR_MIN;
                        _colorTransformMode = CTF_RedInc;
                    }
                    break;
            }
            
            var color:uint = (_r << 16) + (_g << 8) + (_b << 0);
            g.lineStyle(2, color);
            for (var index:uint = 0; index < _array.length; ++index) {
                var pos:Point = _array[index];
                var nextPos:Point = _array[(index + _count) % _array.length];
                
                g.moveTo(pos.x, pos.y);
                g.curveTo(nextPos.x, nextPos.y, 0, 0);
            }

        }
    }
}